/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.nav;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.TypeSearcher;
import org.netbeans.modules.php.editor.index.IndexedClass;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.index.IndexedElement;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.index.NbUtilities;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPTypeSearcher
implements TypeSearcher {
    public Set<? extends TypeSearcher.GsfTypeDescriptor> getDeclaredTypes(Index index, String string, NameKind nameKind, EnumSet<Index.SearchScope> enumSet, TypeSearcher.Helper helper) {
        PHPIndex pHPIndex = PHPIndex.get(index);
        if (pHPIndex == null) {
            return Collections.emptySet();
        }
        int n = string.indexOf("::");
        HashSet<PHPTypeDescriptor> hashSet = new HashSet<PHPTypeDescriptor>();
        if (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 2);
            for (IndexedClass indexedClass : pHPIndex.getClasses(null, string2, nameKind)) {
                for (IndexedFunction indexedFunction : pHPIndex.getMethods(null, indexedClass.getName(), string3, nameKind, -1)) {
                    hashSet.add(new PHPTypeDescriptor(indexedFunction, indexedClass, helper));
                }
            }
        } else {
            for (IndexedFunction indexedElement : pHPIndex.getFunctions(null, string, nameKind)) {
                hashSet.add(new PHPTypeDescriptor(indexedElement, helper));
            }
            for (IndexedClass indexedClass : pHPIndex.getClasses(null, string, nameKind)) {
                hashSet.add(new PHPTypeDescriptor(indexedClass, helper));
            }
            for (IndexedConstant indexedConstant : pHPIndex.getConstants(null, string, nameKind)) {
                hashSet.add(new PHPTypeDescriptor(indexedConstant, helper));
            }
        }
        return hashSet;
    }

    public String getMimetype() {
        return "text/x-php5";
    }

    private class PHPTypeDescriptor
    extends TypeSearcher.GsfTypeDescriptor {
        private final IndexedElement element;
        private final IndexedElement enclosingClass;
        private String projectName;
        private Icon projectIcon;
        private final TypeSearcher.Helper helper;

        public PHPTypeDescriptor(IndexedElement indexedElement, TypeSearcher.Helper helper) {
            this(indexedElement, null, helper);
        }

        public PHPTypeDescriptor(IndexedElement indexedElement, IndexedElement indexedElement2, TypeSearcher.Helper helper) {
            this.element = indexedElement;
            this.enclosingClass = indexedElement2;
            this.helper = helper;
        }

        public Icon getIcon() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            return this.helper.getIcon((ElementHandle)this.element);
        }

        public String getTypeName() {
            return this.element.getName();
        }

        public String getProjectName() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            return this.projectName;
        }

        private void initProjectInfo() {
            FileObject fileObject = this.element.getFileObject();
            if (fileObject != null) {
                Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                if (project != null) {
                    ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                    this.projectName = projectInformation.getDisplayName();
                    this.projectIcon = projectInformation.getIcon();
                }
            } else {
                Logger.getLogger(PHPTypeSearcher.class.getName()).fine("No fileobject for " + this.element.toString() + " with fileurl=" + this.element.getFilenameUrl());
            }
            if (this.projectName == null) {
                this.projectName = "";
            }
        }

        public Icon getProjectIcon() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            return this.projectIcon;
        }

        public FileObject getFileObject() {
            return this.element.getFileObject();
        }

        public void open() {
            NbUtilities.open(this.element.getFileObject(), this.element.getOffset(), this.element.getName());
        }

        public String getContextName() {
            FileObject fileObject;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            if (this.enclosingClass != null) {
                stringBuilder.append(this.enclosingClass.getName());
                bl = true;
            }
            if ((fileObject = this.getFileObject()) != null) {
                if (bl) {
                    stringBuilder.append(" in ");
                }
                stringBuilder.append(FileUtil.getFileDisplayName((FileObject)fileObject));
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(")");
                stringBuilder.insert(0, " (");
                return stringBuilder.toString();
            }
            return null;
        }

        public ElementHandle getElement() {
            return this.element;
        }

        public int getOffset() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getSimpleName() {
            return this.element.getName();
        }

        public String getOuterName() {
            return null;
        }
    }
}

