/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.StructureItem;
import org.netbeans.modules.gsf.api.StructureScanner;
import org.netbeans.modules.php.editor.parser.GSFPHPElementHandle;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.ClassConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhpStructureScanner
implements StructureScanner {
    private CompilationInfo info;
    private static ImageIcon INTERFACE_ICON = null;
    private static final String FOLD_CODE_BLOCKS = "codeblocks";
    private static final String FOLD_CLASS = "codeblocks";
    private static final String FOLD_PHPDOC = "comments";
    private static final String FOLD_COMMENT = "initial-comment";
    private static final String FONT_GRAY_COLOR = "<font color=\"#999999\">";
    private static final String CLOSE_FONT = "</font>";

    public List<? extends StructureItem> scan(CompilationInfo compilationInfo) {
        this.info = compilationInfo;
        Program program = Utils.getRoot(compilationInfo);
        ArrayList<StructureItem> arrayList = new ArrayList<StructureItem>();
        if (program != null) {
            program.accept(new StructureVisitor(arrayList));
            return arrayList;
        }
        return Collections.emptyList();
    }

    public Map<String, List<OffsetRange>> folds(CompilationInfo compilationInfo) {
        Program program = Utils.getRoot(compilationInfo);
        HashMap<String, List<OffsetRange>> hashMap = new HashMap<String, List<OffsetRange>>();
        if (program != null) {
            program.accept(new FoldVisitor(hashMap));
            List<Comment> list = program.getComments();
            if (list != null) {
                ArrayList arrayList = new ArrayList();
                String string = compilationInfo.getText();
                for (Comment comment : list) {
                    if (comment.getCommentType() == Comment.Type.TYPE_PHPDOC) {
                        this.getRanges(hashMap, FOLD_PHPDOC).add(this.createOffsetRange(comment));
                        continue;
                    }
                    if (comment.getCommentType() != Comment.Type.TYPE_MULTILINE) continue;
                    this.getRanges(hashMap, FOLD_COMMENT).add(this.createOffsetRange(comment));
                }
            }
            return hashMap;
        }
        return Collections.emptyMap();
    }

    private OffsetRange createOffsetRange(ASTNode aSTNode) {
        return new OffsetRange(aSTNode.getStartOffset(), aSTNode.getEndOffset());
    }

    private List<OffsetRange> getRanges(Map<String, List<OffsetRange>> map, String string) {
        List<OffsetRange> list = map.get(string);
        if (list == null) {
            list = new ArrayList<OffsetRange>();
            map.put(string, list);
        }
        return list;
    }

    public StructureScanner.Configuration getConfiguration() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FoldVisitor
    extends DefaultVisitor {
        final Map<String, List<OffsetRange>> folds;
        private String foldType;

        public FoldVisitor(Map<String, List<OffsetRange>> map) {
            this.folds = map;
            this.foldType = null;
        }

        @Override
        public void visit(ClassDeclaration classDeclaration) {
            this.foldType = "codeblocks";
            if (classDeclaration.getBody() != null) {
                classDeclaration.getBody().accept(this);
            }
        }

        @Override
        public void visit(InterfaceDeclaration interfaceDeclaration) {
            this.foldType = "codeblocks";
            if (interfaceDeclaration.getBody() != null) {
                interfaceDeclaration.getBody().accept(this);
            }
        }

        @Override
        public void visit(Block block) {
            if (this.foldType != null) {
                PhpStructureScanner.this.getRanges(this.folds, this.foldType).add(PhpStructureScanner.this.createOffsetRange(block));
                this.foldType = null;
                if (block.getStatements() != null) {
                    for (Statement statement : block.getStatements()) {
                        statement.accept(this);
                    }
                }
            }
        }

        @Override
        public void visit(FunctionDeclaration functionDeclaration) {
            this.foldType = "codeblocks";
            if (functionDeclaration.getBody() != null) {
                functionDeclaration.getBody().accept(this);
            }
        }
    }

    private class PHPConstructorStructureItem
    extends PHPStructureItem {
        public PHPConstructorStructureItem(GSFPHPElementHandle gSFPHPElementHandle) {
            super(gSFPHPElementHandle, null, "con");
        }

        public ElementKind getKind() {
            return ElementKind.CONSTRUCTOR;
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.reset();
            GSFPHPElementHandle.MethodDeclarationHandle methodDeclarationHandle = (GSFPHPElementHandle.MethodDeclarationHandle)this.getElementHandle();
            MethodDeclaration methodDeclaration = (MethodDeclaration)methodDeclarationHandle.getASTNode();
            this.appendFunctionDescription(methodDeclaration.getFunction(), htmlFormatter);
            return htmlFormatter.getText();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PHPInterfaceStructureItem
    extends PHPStructureItem {
        private static final String PHP_INTERFACE_ICON = "org/netbeans/modules/php/editor/resources/interface.png";

        public PHPInterfaceStructureItem(GSFPHPElementHandle gSFPHPElementHandle, List<? extends StructureItem> list) {
            super(gSFPHPElementHandle, list, "cl");
        }

        @Override
        public ImageIcon getCustomIcon() {
            if (INTERFACE_ICON == null) {
                INTERFACE_ICON = new ImageIcon(Utilities.loadImage((String)PHP_INTERFACE_ICON));
            }
            return INTERFACE_ICON;
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.reset();
            htmlFormatter.appendText(this.getElementHandle().getName());
            GSFPHPElementHandle.InterfaceDeclarationHandle interfaceDeclarationHandle = (GSFPHPElementHandle.InterfaceDeclarationHandle)this.getElementHandle();
            InterfaceDeclaration interfaceDeclaration = (InterfaceDeclaration)interfaceDeclarationHandle.getASTNode();
            List<Identifier> list = interfaceDeclaration.getInterfaes();
            if (list != null && list.size() > 0) {
                htmlFormatter.appendHtml("<font color=\"#999999\">::");
                this.appendInterfeas(list, htmlFormatter);
                htmlFormatter.appendHtml(PhpStructureScanner.CLOSE_FONT);
            }
            return htmlFormatter.getText();
        }
    }

    private class PHPMethodStructureItem
    extends PHPStructureItem {
        public PHPMethodStructureItem(GSFPHPElementHandle gSFPHPElementHandle) {
            super(gSFPHPElementHandle, null, "fn");
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.reset();
            GSFPHPElementHandle.MethodDeclarationHandle methodDeclarationHandle = (GSFPHPElementHandle.MethodDeclarationHandle)this.getElementHandle();
            MethodDeclaration methodDeclaration = (MethodDeclaration)methodDeclarationHandle.getASTNode();
            this.appendFunctionDescription(methodDeclaration.getFunction(), htmlFormatter);
            return htmlFormatter.getText();
        }
    }

    private class PHPFunctionStructureItem
    extends PHPStructureItem {
        public PHPFunctionStructureItem(GSFPHPElementHandle gSFPHPElementHandle) {
            super(gSFPHPElementHandle, null, "fn");
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.reset();
            GSFPHPElementHandle.FunctionDeclarationHandle functionDeclarationHandle = (GSFPHPElementHandle.FunctionDeclarationHandle)this.getElementHandle();
            FunctionDeclaration functionDeclaration = (FunctionDeclaration)functionDeclarationHandle.getASTNode();
            this.appendFunctionDescription(functionDeclaration, htmlFormatter);
            return htmlFormatter.getText();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PHPClassStructureItem
    extends PHPStructureItem {
        public PHPClassStructureItem(GSFPHPElementHandle gSFPHPElementHandle, List<? extends StructureItem> list) {
            super(gSFPHPElementHandle, list, "cl");
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            List<Identifier> list;
            htmlFormatter.reset();
            GSFPHPElementHandle.ClassDeclarationHandle classDeclarationHandle = (GSFPHPElementHandle.ClassDeclarationHandle)this.getElementHandle();
            htmlFormatter.appendText(classDeclarationHandle.getName());
            ClassDeclaration classDeclaration = (ClassDeclaration)classDeclarationHandle.getASTNode();
            if (classDeclaration.getSuperClass() != null) {
                htmlFormatter.appendHtml("<font color=\"#999999\">::");
                htmlFormatter.appendText(classDeclaration.getSuperClass().getName());
                htmlFormatter.appendHtml(PhpStructureScanner.CLOSE_FONT);
            }
            if ((list = classDeclaration.getInterfaes()) != null && list.size() > 0) {
                htmlFormatter.appendHtml("<font color=\"#999999\">:");
                this.appendInterfeas(list, htmlFormatter);
                htmlFormatter.appendHtml(PhpStructureScanner.CLOSE_FONT);
            }
            return htmlFormatter.getText();
        }
    }

    private class PHPSimpleStructureItem
    extends PHPStructureItem {
        private String simpleText;

        public PHPSimpleStructureItem(GSFPHPElementHandle gSFPHPElementHandle, String string, String string2) {
            super(gSFPHPElementHandle, null, string2);
            this.simpleText = string;
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.appendText(this.simpleText);
            return htmlFormatter.getText();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class PHPStructureItem
    implements StructureItem {
        private final GSFPHPElementHandle elementHandle;
        private final List<? extends StructureItem> children;
        private final String sortPrefix;

        public PHPStructureItem(GSFPHPElementHandle gSFPHPElementHandle, List<? extends StructureItem> list, String string) {
            this.elementHandle = gSFPHPElementHandle;
            this.sortPrefix = string;
            this.children = list != null ? list : Collections.emptyList();
        }

        public String getName() {
            return this.elementHandle.getName();
        }

        public String getSortText() {
            return this.sortPrefix + this.elementHandle.getName();
        }

        public ElementHandle getElementHandle() {
            return this.elementHandle;
        }

        public ElementKind getKind() {
            return this.elementHandle.getKind();
        }

        public Set<Modifier> getModifiers() {
            return this.elementHandle.getModifiers();
        }

        public boolean isLeaf() {
            return this.children.size() == 0;
        }

        public List<? extends StructureItem> getNestedItems() {
            return this.children;
        }

        public long getPosition() {
            return this.elementHandle.getASTNode().getStartOffset();
        }

        public long getEndPosition() {
            return this.elementHandle.getASTNode().getEndOffset();
        }

        public ImageIcon getCustomIcon() {
            return null;
        }

        protected void appendInterfeas(List<Identifier> list, HtmlFormatter htmlFormatter) {
            boolean bl = true;
            for (Identifier identifier : list) {
                if (identifier == null) continue;
                if (!bl) {
                    htmlFormatter.appendText(", ");
                } else {
                    bl = false;
                }
                htmlFormatter.appendText(identifier.getName());
            }
        }

        protected void appendFunctionDescription(FunctionDeclaration functionDeclaration, HtmlFormatter htmlFormatter) {
            htmlFormatter.reset();
            htmlFormatter.appendText(functionDeclaration.getFunctionName().getName());
            htmlFormatter.appendText("(");
            List<FormalParameter> list = functionDeclaration.getFormalParameters();
            if (list != null && list.size() > 0) {
                boolean bl = true;
                for (FormalParameter formalParameter : list) {
                    Object object;
                    String string = null;
                    Expression expression = formalParameter.getParameterName();
                    if (expression != null) {
                        object = null;
                        boolean bl2 = false;
                        if (expression instanceof Reference) {
                            Reference reference = (Reference)expression;
                            bl2 = true;
                            if (reference.getExpression() instanceof Variable) {
                                object = (Variable)reference.getExpression();
                            }
                        } else if (expression instanceof Variable) {
                            object = (Variable)expression;
                        }
                        if (object != null) {
                            string = Utils.resolveVariableName((Variable)object);
                            if (string != null) {
                                String string2 = string = ((Variable)object).isDollared() ? "$" + string : string;
                                if (bl2) {
                                    string = '&' + string;
                                }
                            }
                        } else {
                            string = "??";
                        }
                    }
                    object = null;
                    if (formalParameter.getParameterType() != null) {
                        object = formalParameter.getParameterType().getName();
                    }
                    if (string == null) continue;
                    if (!bl) {
                        htmlFormatter.appendText(", ");
                    }
                    if (object != null) {
                        htmlFormatter.appendHtml(PhpStructureScanner.FONT_GRAY_COLOR);
                        htmlFormatter.appendText((String)object);
                        htmlFormatter.appendText(" ");
                        htmlFormatter.appendHtml(PhpStructureScanner.CLOSE_FONT);
                    }
                    htmlFormatter.appendText(string);
                    bl = false;
                }
            }
            htmlFormatter.appendText(")");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StructureVisitor
    extends DefaultVisitor {
        final List<StructureItem> items;
        private List<StructureItem> children = null;
        private String className;

        public StructureVisitor(List<StructureItem> list) {
            this.items = list;
        }

        @Override
        public void visit(FunctionDeclaration functionDeclaration) {
            if (this.children == null && functionDeclaration.getFunctionName() != null) {
                PHPFunctionStructureItem pHPFunctionStructureItem = new PHPFunctionStructureItem(new GSFPHPElementHandle.FunctionDeclarationHandle(PhpStructureScanner.this.info, functionDeclaration));
                this.items.add(pHPFunctionStructureItem);
            }
        }

        @Override
        public void visit(ClassDeclaration classDeclaration) {
            if (classDeclaration.getName() != null) {
                this.children = new ArrayList<StructureItem>();
                this.className = classDeclaration.getName().getName();
                super.visit(classDeclaration);
                PHPClassStructureItem pHPClassStructureItem = new PHPClassStructureItem(new GSFPHPElementHandle.ClassDeclarationHandle(PhpStructureScanner.this.info, classDeclaration), this.children);
                this.items.add(pHPClassStructureItem);
                this.children = null;
            }
        }

        @Override
        public void visit(InterfaceDeclaration interfaceDeclaration) {
            if (interfaceDeclaration.getName() != null) {
                this.children = new ArrayList<StructureItem>();
                super.visit(interfaceDeclaration);
                PHPInterfaceStructureItem pHPInterfaceStructureItem = new PHPInterfaceStructureItem(new GSFPHPElementHandle.InterfaceDeclarationHandle(PhpStructureScanner.this.info, interfaceDeclaration), this.children);
                this.items.add(pHPInterfaceStructureItem);
            }
        }

        @Override
        public void visit(MethodDeclaration methodDeclaration) {
            FunctionDeclaration functionDeclaration = methodDeclaration.getFunction();
            if (functionDeclaration != null && functionDeclaration.getFunctionName() != null) {
                String string = functionDeclaration.getFunctionName().getName();
                PHPStructureItem pHPStructureItem = this.className != null && (this.className.equals(string) || "__construct".equals(string)) ? new PHPConstructorStructureItem(new GSFPHPElementHandle.MethodDeclarationHandle(PhpStructureScanner.this.info, methodDeclaration)) : new PHPMethodStructureItem(new GSFPHPElementHandle.MethodDeclarationHandle(PhpStructureScanner.this.info, methodDeclaration));
                this.children.add(pHPStructureItem);
            }
        }

        @Override
        public void visit(FieldsDeclaration fieldsDeclaration) {
            Variable[] variableArray;
            for (Variable variable : variableArray = fieldsDeclaration.getVariableNames()) {
                String string = Utils.resolveVariableName(variable);
                if (string == null) continue;
                String string2 = string;
                if (variable.isDollared()) {
                    string2 = "$" + string;
                }
                PHPSimpleStructureItem pHPSimpleStructureItem = new PHPSimpleStructureItem((GSFPHPElementHandle)new GSFPHPElementHandle.FieldsDeclarationHandle(PhpStructureScanner.this.info, fieldsDeclaration), string2, "0");
                this.children.add(pHPSimpleStructureItem);
            }
        }

        @Override
        public void visit(ClassConstantDeclaration classConstantDeclaration) {
            List<Identifier> list = classConstantDeclaration.getNames();
            for (Identifier identifier : list) {
                String string = identifier.getName();
                if (string == null) continue;
                PHPSimpleStructureItem pHPSimpleStructureItem = new PHPSimpleStructureItem((GSFPHPElementHandle)new GSFPHPElementHandle.ClassConstantDeclarationHandle(PhpStructureScanner.this.info, classConstantDeclaration), string, "con");
                this.children.add(pHPSimpleStructureItem);
            }
        }

        @Override
        public void visit(FunctionInvocation functionInvocation) {
            Scalar scalar;
            List<Expression> list;
            String string;
            if (functionInvocation.getFunctionName().getName() instanceof Identifier && "define".equals(string = ((Identifier)functionInvocation.getFunctionName().getName()).getName()) && (list = functionInvocation.getParameters()).size() == 2 && list.get(0) instanceof Scalar && list.get(1) instanceof Scalar && (scalar = (Scalar)list.get(0)).getScalarType() == Scalar.Type.STRING) {
                String string2 = scalar.getStringValue().substring(1);
                string2 = string2.substring(0, string2.length() - 1);
                PHPSimpleStructureItem pHPSimpleStructureItem = new PHPSimpleStructureItem((GSFPHPElementHandle)new GSFPHPElementHandle.GlobalConstant(PhpStructureScanner.this.info, functionInvocation), string2, "con");
                this.items.add(pHPSimpleStructureItem);
            }
        }
    }
}

