/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.gsf.api.ColoringAttributes;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.SemanticAnalyzer;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionName;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticAnalysis
implements SemanticAnalyzer {
    public static final EnumSet<ColoringAttributes> UNUSED_FIELD_SET = EnumSet.of(ColoringAttributes.UNUSED, ColoringAttributes.FIELD);
    public static final EnumSet<ColoringAttributes> UNUSED_STATIC_FIELD_SET = EnumSet.of(ColoringAttributes.UNUSED, ColoringAttributes.FIELD, ColoringAttributes.STATIC);
    public static final EnumSet<ColoringAttributes> UNUSED_METHOD_SET = EnumSet.of(ColoringAttributes.UNUSED, ColoringAttributes.METHOD);
    public static final EnumSet<ColoringAttributes> STATIC_METHOD_SET = EnumSet.of(ColoringAttributes.STATIC, ColoringAttributes.METHOD);
    public static final EnumSet<ColoringAttributes> UNUSED_STATIC_METHOD_SET = EnumSet.of(ColoringAttributes.STATIC, ColoringAttributes.METHOD, ColoringAttributes.UNUSED);
    private boolean cancelled;
    private Map<OffsetRange, Set<ColoringAttributes>> semanticHighlights = null;

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.semanticHighlights;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void run(CompilationInfo compilationInfo) throws Exception {
        this.resume();
        if (this.isCancelled()) {
            return;
        }
        PHPParseResult pHPParseResult = this.getParseResult(compilationInfo);
        HashMap<OffsetRange, Set<ColoringAttributes>> hashMap = new HashMap<OffsetRange, Set<ColoringAttributes>>(100);
        if (pHPParseResult.getProgram() != null) {
            pHPParseResult.getProgram().accept(new SemanticHighlightVisitor(hashMap));
            this.semanticHighlights = hashMap.size() > 0 ? hashMap : null;
        }
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    private PHPParseResult getParseResult(CompilationInfo compilationInfo) {
        ParserResult parserResult = compilationInfo.getEmbeddedResult("text/x-php5", 0);
        if (parserResult == null) {
            return null;
        }
        return (PHPParseResult)parserResult;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SemanticHighlightVisitor
    extends DefaultVisitor {
        Map<OffsetRange, Set<ColoringAttributes>> highlights;
        private final Map<String, IdentifierColoring> privateFieldsUsed;
        private final Map<String, IdentifierColoring> privateMethod;
        private final List<Block> needToScan;

        public SemanticHighlightVisitor(Map<OffsetRange, Set<ColoringAttributes>> map) {
            this.highlights = map;
            this.privateFieldsUsed = new HashMap<String, IdentifierColoring>();
            this.privateMethod = new HashMap<String, IdentifierColoring>();
            this.needToScan = new ArrayList<Block>();
        }

        private OffsetRange createOffsetRange(ASTNode aSTNode) {
            return new OffsetRange(aSTNode.getStartOffset(), aSTNode.getEndOffset());
        }

        @Override
        public void visit(ClassDeclaration classDeclaration) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            Identifier identifier = classDeclaration.getName();
            OffsetRange offsetRange = new OffsetRange(identifier.getStartOffset(), identifier.getEndOffset());
            this.highlights.put(offsetRange, ColoringAttributes.CLASS_SET);
            classDeclaration.getBody().accept(this);
            for (Block object : this.needToScan) {
                object.accept(this);
            }
            for (IdentifierColoring identifierColoring : this.privateFieldsUsed.values()) {
                offsetRange = new OffsetRange(identifierColoring.identifier.getStartOffset(), identifierColoring.identifier.getEndOffset());
                if (identifierColoring.coloring.contains(ColoringAttributes.STATIC)) {
                    this.highlights.put(offsetRange, UNUSED_STATIC_FIELD_SET);
                    continue;
                }
                this.highlights.put(offsetRange, UNUSED_FIELD_SET);
            }
            for (IdentifierColoring identifierColoring : this.privateMethod.values()) {
                offsetRange = new OffsetRange(identifierColoring.identifier.getStartOffset(), identifierColoring.identifier.getEndOffset());
                if (identifierColoring.coloring.contains(ColoringAttributes.STATIC)) {
                    this.highlights.put(offsetRange, UNUSED_STATIC_METHOD_SET);
                    continue;
                }
                this.highlights.put(offsetRange, UNUSED_METHOD_SET);
            }
        }

        @Override
        public void visit(MethodDeclaration methodDeclaration) {
            boolean bl = BodyDeclaration.Modifier.isPrivate(methodDeclaration.getModifier());
            EnumSet<ColoringAttributes> enumSet = ColoringAttributes.METHOD_SET;
            if (BodyDeclaration.Modifier.isStatic(methodDeclaration.getModifier())) {
                enumSet = STATIC_METHOD_SET;
            }
            Identifier identifier = methodDeclaration.getFunction().getFunctionName();
            if (bl) {
                this.privateMethod.put(identifier.getName(), new IdentifierColoring(identifier, enumSet));
            } else {
                this.highlights.put(this.createOffsetRange(identifier), enumSet);
            }
            if (!BodyDeclaration.Modifier.isAbstract(methodDeclaration.getModifier()) && methodDeclaration.getFunction().getBody() != null) {
                this.needToScan.add(methodDeclaration.getFunction().getBody());
            }
        }

        @Override
        public void visit(MethodInvocation methodInvocation) {
            Object object;
            Identifier identifier = null;
            if (methodInvocation.getMethod().getFunctionName().getName() instanceof Variable) {
                object = (Variable)methodInvocation.getMethod().getFunctionName().getName();
                if (((Variable)object).getName() instanceof Identifier) {
                    identifier = (Identifier)((Variable)object).getName();
                }
            } else if (methodInvocation.getMethod().getFunctionName().getName() instanceof Identifier) {
                identifier = (Identifier)methodInvocation.getMethod().getFunctionName().getName();
            }
            if (identifier != null && (object = this.privateMethod.remove(identifier.getName())) != null) {
                OffsetRange offsetRange = new OffsetRange(((IdentifierColoring)object).identifier.getStartOffset(), ((IdentifierColoring)object).identifier.getEndOffset());
                this.highlights.put(offsetRange, ((IdentifierColoring)object).coloring);
            }
            super.visit(methodInvocation);
        }

        @Override
        public void visit(InterfaceDeclaration interfaceDeclaration) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            Identifier identifier = interfaceDeclaration.getName();
            OffsetRange offsetRange = new OffsetRange(identifier.getStartOffset(), identifier.getEndOffset());
            this.highlights.put(offsetRange, ColoringAttributes.CLASS_SET);
            interfaceDeclaration.getBody().accept(this);
        }

        @Override
        public void visit(FieldsDeclaration fieldsDeclaration) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            boolean bl = BodyDeclaration.Modifier.isPrivate(fieldsDeclaration.getModifier());
            EnumSet enumSet = ColoringAttributes.FIELD_SET;
            if (BodyDeclaration.Modifier.isStatic(fieldsDeclaration.getModifier())) {
                enumSet = ColoringAttributes.STATIC_FIELD_SET;
            }
            Variable[] variableArray = fieldsDeclaration.getVariableNames();
            for (int i = 0; i < variableArray.length; ++i) {
                Identifier identifier;
                Variable variable = variableArray[i];
                if (!bl) {
                    identifier = new OffsetRange(variable.getName().getStartOffset(), variable.getName().getEndOffset());
                    this.highlights.put((OffsetRange)identifier, ColoringAttributes.FIELD_SET);
                    continue;
                }
                if (!(variable.getName() instanceof Identifier)) continue;
                identifier = (Identifier)variable.getName();
                this.privateFieldsUsed.put(identifier.getName(), new IdentifierColoring(identifier, enumSet));
            }
        }

        @Override
        public void visit(FieldAccess fieldAccess) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            if (!fieldAccess.getField().isDollared()) {
                Expression expression = fieldAccess.getField().getName();
                this.processFieldAccess(expression);
                OffsetRange offsetRange = new OffsetRange(expression.getStartOffset(), expression.getEndOffset());
                this.highlights.put(offsetRange, ColoringAttributes.FIELD_SET);
            }
        }

        @Override
        public void visit(StaticMethodInvocation staticMethodInvocation) {
            String string;
            IdentifierColoring identifierColoring;
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            FunctionName functionName = staticMethodInvocation.getMethod().getFunctionName();
            if (functionName.getName() instanceof Identifier && (identifierColoring = this.privateMethod.remove(string = ((Identifier)functionName.getName()).getName())) != null) {
                OffsetRange offsetRange = new OffsetRange(identifierColoring.identifier.getStartOffset(), identifierColoring.identifier.getEndOffset());
                this.highlights.put(offsetRange, identifierColoring.coloring);
                return;
            }
            string = new OffsetRange(functionName.getStartOffset(), functionName.getEndOffset());
            this.highlights.put((OffsetRange)string, ColoringAttributes.STATIC_SET);
        }

        @Override
        public void visit(StaticFieldAccess staticFieldAccess) {
            Expression expression = staticFieldAccess.getField().getName();
            this.processFieldAccess(expression);
            OffsetRange offsetRange = new OffsetRange(expression.getStartOffset(), expression.getEndOffset());
            this.highlights.put(offsetRange, ColoringAttributes.STATIC_FIELD_SET);
        }

        private void processFieldAccess(Expression expression) {
            String string;
            IdentifierColoring identifierColoring;
            if (expression instanceof Identifier && (identifierColoring = this.privateFieldsUsed.remove(string = ((Identifier)expression).getName())) != null) {
                OffsetRange offsetRange = new OffsetRange(identifierColoring.identifier.getStartOffset(), identifierColoring.identifier.getEndOffset());
                this.highlights.put(offsetRange, identifierColoring.coloring);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class IdentifierColoring {
            public Identifier identifier;
            public Set<ColoringAttributes> coloring;

            public IdentifierColoring(Identifier identifier, Set<ColoringAttributes> set) {
                this.identifier = identifier;
                this.coloring = set;
            }
        }
    }
}

