/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.spi.project.support.rake;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.ruby.modules.project.rake.FileChangeSupport;
import org.netbeans.modules.ruby.modules.project.rake.FileChangeSupportEvent;
import org.netbeans.modules.ruby.modules.project.rake.FileChangeSupportListener;
import org.netbeans.modules.ruby.modules.project.rake.UserQuestionHandler;
import org.netbeans.modules.ruby.spi.project.support.rake.EditableProperties;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyProvider;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyUtils;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.UserQuestionException;
import org.openide.util.Utilities;

final class ProjectProperties {
    private final RakeProjectHelper helper;
    private final Map<String, PP> properties = new HashMap<String, PP>();
    private PropertyProvider stockPropertyPreprovider = null;
    private PropertyEvaluator standardPropertyEvaluator = null;

    public ProjectProperties(RakeProjectHelper rakeProjectHelper) {
        this.helper = rakeProjectHelper;
    }

    public EditableProperties getProperties(String string) {
        EditableProperties editableProperties = this.getPP(string).getEditablePropertiesOrNull();
        if (editableProperties != null) {
            return editableProperties.cloneProperties();
        }
        return new EditableProperties(true);
    }

    public boolean putProperties(String string, EditableProperties editableProperties) {
        return this.getPP(string).put(editableProperties);
    }

    public FileLock write(String string) throws IOException {
        assert (this.properties.containsKey(string));
        return this.getPP(string).write();
    }

    public PropertyProvider getPropertyProvider(String string) {
        return this.getPP(string);
    }

    private PP getPP(String string) {
        PP pP = this.properties.get(string);
        if (pP == null) {
            pP = new PP(string, this.helper);
            this.properties.put(string, pP);
        }
        return pP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyProvider getStockPropertyPreprovider() {
        if (this.stockPropertyPreprovider == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Properties properties = System.getProperties();
            Serializable serializable = properties;
            synchronized (serializable) {
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    try {
                        hashMap.put((String)entry.getKey(), (String)entry.getValue());
                    }
                    catch (ClassCastException classCastException) {
                        Logger.getLogger(ProjectProperties.class.getName()).warning("WARNING: removing non-String-valued system property " + entry.getKey() + "=" + entry.getValue() + " (cf. #45788)");
                    }
                }
            }
            hashMap.put("basedir", FileUtil.toFile((FileObject)this.helper.getProjectDirectory()).getAbsolutePath());
            serializable = InstalledFileLocator.getDefault().locate("ant/lib/ant.jar", "org.apache.tools.ant.module", false);
            if (serializable != null) {
                File file = ((File)serializable).getParentFile().getParentFile();
                hashMap.put("ant.home", file.getAbsolutePath());
            }
            this.stockPropertyPreprovider = PropertyUtils.fixedPropertyProvider(hashMap);
        }
        return this.stockPropertyPreprovider;
    }

    public PropertyEvaluator getStandardPropertyEvaluator() {
        if (this.standardPropertyEvaluator == null) {
            PropertyEvaluator propertyEvaluator = PropertyUtils.sequentialPropertyEvaluator(this.getStockPropertyPreprovider(), this.getPropertyProvider("nbproject/private/private.properties"));
            PropertyProvider propertyProvider = PropertyUtils.userPropertiesProvider(propertyEvaluator, "user.properties.file", FileUtil.toFile((FileObject)this.helper.getProjectDirectory()));
            this.standardPropertyEvaluator = PropertyUtils.sequentialPropertyEvaluator(this.getStockPropertyPreprovider(), this.getPropertyProvider("nbproject/private/private.properties"), propertyProvider, this.getPropertyProvider("nbproject/project.properties"));
        }
        return this.standardPropertyEvaluator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PP
    implements PropertyProvider,
    FileChangeSupportListener {
        private static final RequestProcessor RP = new RequestProcessor("ProjectProperties.PP.RP");
        private final String path;
        private final RakeProjectHelper helper;
        private EditableProperties properties = null;
        private boolean loaded = false;
        private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
        private boolean writing = false;

        public PP(String string, RakeProjectHelper rakeProjectHelper) {
            this.path = string;
            this.helper = rakeProjectHelper;
            FileChangeSupport.DEFAULT.addListener(this, new File(FileUtil.toFile((FileObject)this.dir()), string.replace('/', File.separatorChar)));
        }

        private FileObject dir() {
            return this.helper.getProjectDirectory();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EditableProperties getEditablePropertiesOrNull() {
            if (!this.loaded) {
                this.properties = null;
                FileObject fileObject = this.dir().getFileObject(this.path);
                if (fileObject != null) {
                    try {
                        EditableProperties editableProperties;
                        InputStream inputStream = fileObject.getInputStream();
                        try {
                            editableProperties = new EditableProperties(true);
                            editableProperties.load(inputStream);
                        }
                        finally {
                            inputStream.close();
                        }
                        this.properties = editableProperties;
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                }
                this.loaded = true;
            }
            return this.properties;
        }

        public boolean put(EditableProperties editableProperties) {
            boolean bl;
            this.loaded = true;
            boolean bl2 = bl = !Utilities.compareObjects((Object)editableProperties, (Object)this.properties);
            if (bl) {
                this.properties = editableProperties != null ? editableProperties.cloneProperties() : null;
                this.fireChange();
            }
            return bl;
        }

        public FileLock write() throws IOException {
            assert (this.loaded);
            final FileObject fileObject = this.dir().getFileObject(this.path);
            assert (!this.writing);
            final FileLock[] fileLockArray = new FileLock[1];
            this.writing = true;
            try {
                if (this.properties != null) {
                    this.dir().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() throws IOException {
                            FileObject fileObject2;
                            if (fileObject == null) {
                                fileObject2 = FileUtil.createData((FileObject)PP.this.dir(), (String)PP.this.path);
                                assert (fileObject2 != null) : "FU.cD must not return null; called on " + PP.access$000(PP.this) + " + " + PP.access$100(PP.this);
                            } else {
                                fileObject2 = fileObject;
                            }
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            PP.this.properties.store(byteArrayOutputStream);
                            final byte[] byArray = byteArrayOutputStream.toByteArray();
                            try {
                                fileLockArray[0] = fileObject2.lock();
                                OutputStream outputStream = fileObject2.getOutputStream(fileLockArray[0]);
                                try {
                                    outputStream.write(byArray);
                                }
                                finally {
                                    outputStream.close();
                                }
                            }
                            catch (UserQuestionException userQuestionException) {
                                PP.this.helper.needPendingHook();
                                UserQuestionHandler.handle(userQuestionException, new UserQuestionHandler.Callback(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void accepted() {
                                        assert (!PP.this.writing);
                                        PP.this.writing = true;
                                        try {
                                            FileLock fileLock = fileObject2.lock();
                                            try {
                                                OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                                                try {
                                                    outputStream.write(byArray);
                                                }
                                                finally {
                                                    outputStream.close();
                                                }
                                            }
                                            finally {
                                                fileLock.releaseLock();
                                            }
                                            PP.this.helper.maybeCallPendingHook();
                                        }
                                        catch (IOException iOException) {
                                            ErrorManager.getDefault().notify((Throwable)iOException);
                                            this.reload();
                                        }
                                        finally {
                                            PP.this.writing = false;
                                        }
                                    }

                                    public void denied() {
                                        this.reload();
                                    }

                                    public void error(IOException iOException) {
                                        ErrorManager.getDefault().notify((Throwable)iOException);
                                        this.reload();
                                    }

                                    private void reload() {
                                        PP.this.helper.cancelPendingHook();
                                        PP.this.diskChange();
                                    }
                                });
                            }
                        }
                    });
                } else if (fileObject != null) {
                    fileObject.delete();
                }
            }
            catch (IOException iOException) {
                if (fileLockArray[0] != null) {
                    fileLockArray[0].releaseLock();
                }
                throw iOException;
            }
            finally {
                this.writing = false;
            }
            return fileLockArray[0];
        }

        @Override
        public Map<String, String> getProperties() {
            EditableProperties editableProperties = this.getEditablePropertiesOrNull();
            if (editableProperties != null) {
                return Collections.unmodifiableMap(editableProperties);
            }
            return Collections.emptyMap();
        }

        @Override
        public synchronized void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        @Override
        public synchronized void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ChangeListener[] changeListenerArray;
            Object object = this;
            synchronized (object) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                changeListenerArray = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            object = new ChangeEvent(this);
            Mutex.Action<Void> action = new Mutex.Action<Void>((ChangeEvent)object){
                final /* synthetic */ ChangeEvent val$ev;
                {
                    this.val$ev = changeEvent;
                }

                public Void run() {
                    for (ChangeListener changeListener : changeListenerArray) {
                        changeListener.stateChanged(this.val$ev);
                    }
                    return null;
                }
            };
            if (ProjectManager.mutex().isWriteAccess()) {
                ProjectManager.mutex().readAccess((Mutex.Action)action);
            } else if (ProjectManager.mutex().isReadAccess()) {
                action.run();
            } else {
                RP.post(new Runnable((Mutex.Action)action){
                    final /* synthetic */ Mutex.Action val$action;
                    {
                        this.val$action = action;
                    }

                    public void run() {
                        ProjectManager.mutex().readAccess(this.val$action);
                    }
                });
            }
        }

        private void diskChange() {
            if (!this.writing) {
                this.loaded = false;
            }
            this.fireChange();
            if (!this.writing) {
                this.helper.fireExternalChange(this.path);
            }
        }

        @Override
        public void fileCreated(FileChangeSupportEvent fileChangeSupportEvent) {
            this.diskChange();
        }

        @Override
        public void fileDeleted(FileChangeSupportEvent fileChangeSupportEvent) {
            this.diskChange();
        }

        @Override
        public void fileModified(FileChangeSupportEvent fileChangeSupportEvent) {
            this.diskChange();
        }
    }
}

