/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.freeform.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.web.freeform.WebProjectGenerator;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebLocationsPanel
extends JPanel
implements HelpCtx.Provider {
    private static String J2EE_SPEC_5 = "1.5";
    private static String J2EE_SPEC_1_4 = "1.4";
    private static String J2EE_SPEC_1_3 = "1.3";
    private File baseFolder;
    private File nbProjectFolder;
    private AntProjectHelper projectHelper;
    private File srcPackagesLocation;
    private String classpath;
    private WizardDescriptor wizardDescriptor;
    private JButton jButtonWeb;
    private JButton jButtonWebInf;
    private JComboBox jComboBoxJ2eeLevel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabelWebInf;
    private JPanel jPanel1;
    private JTextArea jTextArea1;
    private JTextField jTextFieldContextPath;
    private JTextField jTextFieldWeb;
    private JTextField jTextFieldWebInf;

    public WebLocationsPanel(WizardDescriptor wizardDescriptor) {
        this.initComponents();
        this.wizardDescriptor = wizardDescriptor;
        this.jComboBoxJ2eeLevel.addItem(NbBundle.getMessage(WebLocationsPanel.class, (String)"TXT_J2EESpecLevel_5"));
        this.jComboBoxJ2eeLevel.addItem(NbBundle.getMessage(WebLocationsPanel.class, (String)"TXT_J2EESpecLevel_0"));
        this.jComboBoxJ2eeLevel.addItem(NbBundle.getMessage(WebLocationsPanel.class, (String)"TXT_J2EESpecLevel_1"));
        this.jComboBoxJ2eeLevel.setSelectedIndex(0);
    }

    public WebLocationsPanel(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, AuxiliaryConfiguration auxiliaryConfiguration) {
        this((WizardDescriptor)null);
        this.projectHelper = antProjectHelper;
        this.setFolders(Util.getProjectLocation((AntProjectHelper)antProjectHelper, (PropertyEvaluator)propertyEvaluator), FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory()));
        List<WebProjectGenerator.WebModule> list = WebProjectGenerator.getWebmodules(antProjectHelper, auxiliaryConfiguration);
        if (list != null) {
            WebProjectGenerator.WebModule webModule = list.get(0);
            String string = WebLocationsPanel.getLocationDisplayName(propertyEvaluator, this.nbProjectFolder, webModule.docRoot);
            String string2 = webModule.webInf != null ? WebLocationsPanel.getLocationDisplayName(propertyEvaluator, this.nbProjectFolder, webModule.webInf) : string + "/WEB-INF";
            this.classpath = webModule.classpath;
            this.jTextFieldWeb.setText(string);
            this.jTextFieldWebInf.setText(string2);
            this.jTextFieldContextPath.setText(webModule.contextPath);
            if (webModule.j2eeSpecLevel == null || webModule.j2eeSpecLevel.equals(J2EE_SPEC_5)) {
                this.jComboBoxJ2eeLevel.setSelectedItem(NbBundle.getMessage(WebLocationsPanel.class, (String)"TXT_J2EESpecLevel_5"));
            } else if (webModule.j2eeSpecLevel.equals(J2EE_SPEC_1_4)) {
                this.jComboBoxJ2eeLevel.setSelectedItem(NbBundle.getMessage(WebLocationsPanel.class, (String)"TXT_J2EESpecLevel_0"));
            } else {
                this.jComboBoxJ2eeLevel.setSelectedItem(NbBundle.getMessage(WebLocationsPanel.class, (String)"TXT_J2EESpecLevel_1"));
            }
        }
    }

    public static String getLocationDisplayName(PropertyEvaluator propertyEvaluator, File file, String string) {
        File file2 = Util.resolveFile((PropertyEvaluator)propertyEvaluator, (File)file, (String)string);
        if (file2 == null) {
            return string;
        }
        String string2 = file2.getAbsolutePath();
        if (CollocationQuery.areCollocated((File)file, (File)file2)) {
            string2 = PropertyUtils.relativizeFile((File)file, (File)file2).replace('/', File.separatorChar);
        }
        return string2;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(WebLocationsPanel.class);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldWeb = new JTextField();
        this.jButtonWeb = new JButton();
        this.jLabelWebInf = new JLabel();
        this.jTextFieldWebInf = new JTextField();
        this.jButtonWebInf = new JButton();
        this.jLabel4 = new JLabel();
        this.jTextFieldContextPath = new JTextField();
        this.jLabel5 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jTextArea1 = new JTextArea();
        this.jComboBoxJ2eeLevel = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText(NbBundle.getMessage(WebLocationsPanel.class, (String)"LBL_WebPagesPanel_Description"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setLabelFor(this.jTextFieldWeb);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(WebLocationsPanel.class, (String)"LBL_WebPagesPanel_WebPagesLocation_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.jTextFieldWeb, gridBagConstraints);
        this.jTextFieldWeb.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebLocationsPanel.class, (String)"ACS_LBL_WebPagesPanel_WebPagesLocation_A11YDesc"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonWeb, (String)NbBundle.getMessage(WebLocationsPanel.class, (String)"BTN_BasicProjectInfoPanel_browseAntScript"));
        this.jButtonWeb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebLocationsPanel.this.jButtonWebActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.jButtonWeb, gridBagConstraints);
        this.jButtonWeb.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebLocationsPanel.class, (String)"ACS_LBL_WebPagesPanel_WebPagesLocationBrowse_A11YDesc"));
        this.jLabelWebInf.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/freeform/ui/Bundle").getString("MNE_DeploymentDescriptorFolder").charAt(0));
        this.jLabelWebInf.setLabelFor(this.jTextFieldWebInf);
        this.jLabelWebInf.setText(NbBundle.getMessage(WebLocationsPanel.class, (String)"LBL_DeploymentDescriptorFolder_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jLabelWebInf, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jTextFieldWebInf, gridBagConstraints);
        this.jTextFieldWebInf.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebLocationsPanel.class, (String)"ACSD_WEBINF_TEXTFIELD"));
        this.jButtonWebInf.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/freeform/ui/Bundle").getString("MNE_BrowseWebInfLocation").charAt(0));
        this.jButtonWebInf.setText(NbBundle.getMessage(WebLocationsPanel.class, (String)"LBL_DeploymentDescriptorBrowse_Label"));
        this.jButtonWebInf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebLocationsPanel.this.jButtonWebInfActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.add((Component)this.jButtonWebInf, gridBagConstraints);
        this.jButtonWebInf.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebLocationsPanel.class, (String)"ACSD_WEBINF_BROWSE"));
        this.jLabel4.setLabelFor(this.jTextFieldContextPath);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(WebLocationsPanel.class, (String)"LBL_WebPagesPanel_ContextPath_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jTextFieldContextPath, gridBagConstraints);
        this.jTextFieldContextPath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebLocationsPanel.class, (String)"ACS_LBL_WebPagesPanel_ContextPath_A11YDesc"));
        this.jLabel5.setLabelFor(this.jComboBoxJ2eeLevel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(WebLocationsPanel.class, (String)"LBL_WebPagesPanel_J2EESpecLevel_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Label.disabledForeground")));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel6.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/web/freeform/resources/alert_32.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 8, 8, 0);
        this.jPanel1.add((Component)this.jLabel6, gridBagConstraints);
        this.jTextArea1.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setText(NbBundle.getMessage(WebLocationsPanel.class, (String)"Freeform_Warning_Message"));
        this.jTextArea1.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 10, 4, 4);
        this.jPanel1.add((Component)this.jTextArea1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jComboBoxJ2eeLevel, gridBagConstraints);
        this.jComboBoxJ2eeLevel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebLocationsPanel.class, (String)"ACS_LBL_WebPagesPanel_J2EESpecLevel_A11YDesc"));
    }

    private void jButtonWebInfActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = WebLocationsPanel.createChooser(this.getWebInfLocation(), this.wizardDescriptor);
        if (0 == jFileChooser.showOpenDialog(this)) {
            this.setWebInf(jFileChooser.getSelectedFile());
        }
    }

    private void jButtonWebActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = WebLocationsPanel.createChooser(this.getWebPagesLocation(), this.wizardDescriptor);
        if (0 == jFileChooser.showOpenDialog(this)) {
            this.setWebPages(jFileChooser.getSelectedFile());
        }
    }

    private static JFileChooser createChooser(File file, WizardDescriptor wizardDescriptor) {
        String string = file.getAbsolutePath();
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, (File)new File(string));
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        if (string.length() > 0 && file.exists()) {
            jFileChooser.setSelectedFile(file);
        } else if (wizardDescriptor != null) {
            File file2;
            File file3 = null;
            FileObject fileObject = Templates.getExistingSourcesFolder((WizardDescriptor)wizardDescriptor);
            if (fileObject != null && (file2 = FileUtil.toFile((FileObject)fileObject)) != null && file2.isDirectory()) {
                file3 = file2;
            }
            if (file3 != null) {
                jFileChooser.setCurrentDirectory(file3);
            } else {
                jFileChooser.setSelectedFile(ProjectChooser.getProjectsFolder());
            }
        } else {
            jFileChooser.setSelectedFile(ProjectChooser.getProjectsFolder());
        }
        return jFileChooser;
    }

    protected List<WebProjectGenerator.WebModule> getWebModules() {
        ArrayList<WebProjectGenerator.WebModule> arrayList = new ArrayList<WebProjectGenerator.WebModule>();
        WebProjectGenerator.WebModule webModule = new WebProjectGenerator.WebModule();
        webModule.docRoot = this.getRelativeLocation(this.getWebPagesLocation());
        webModule.webInf = this.getRelativeLocation(this.getWebInfLocation());
        webModule.contextPath = this.jTextFieldContextPath.getText().trim();
        String string = (String)this.jComboBoxJ2eeLevel.getSelectedItem();
        webModule.j2eeSpecLevel = string.equals(NbBundle.getMessage(WebLocationsPanel.class, (String)"TXT_J2EESpecLevel_5")) ? J2EE_SPEC_5 : (string.equals(NbBundle.getMessage(WebLocationsPanel.class, (String)"TXT_J2EESpecLevel_0")) ? J2EE_SPEC_1_4 : J2EE_SPEC_1_3);
        webModule.classpath = this.classpath;
        arrayList.add(webModule);
        return arrayList;
    }

    protected List<String> getJavaSrcFolder() {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = this.getSrcPackagesLocation();
        arrayList.add(this.getRelativeLocation(file));
        arrayList.add(file.getName());
        return arrayList;
    }

    protected List<String> getWebSrcFolder() {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = this.getWebPagesLocation();
        arrayList.add(this.getRelativeLocation(file));
        arrayList.add(file.getName());
        return arrayList;
    }

    protected List<String> getWebInfFolder() {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = this.getWebInfLocation();
        arrayList.add(this.getRelativeLocation(file));
        arrayList.add(file.getName());
        return arrayList;
    }

    private File getAsFile(String string) {
        return PropertyUtils.resolveFile((File)this.nbProjectFolder, (String)string);
    }

    public void setFolders(File file, File file2) {
        this.baseFolder = file;
        this.nbProjectFolder = file2;
    }

    protected void setWebPages(String string) {
        this.jTextFieldWeb.setText(string);
    }

    protected void setWebInf(String string) {
        this.jTextFieldWebInf.setText(string);
    }

    protected void setSrcPackages(String string) {
        this.setSrcPackages(this.getAsFile(string));
    }

    private void setWebPages(File file) {
        this.setWebPages(this.relativizeFile(file));
    }

    private void setWebInf(File file) {
        this.setWebInf(this.relativizeFile(file));
    }

    protected File getWebPagesLocation() {
        return this.getAsFile(this.jTextFieldWeb.getText()).getAbsoluteFile();
    }

    protected File getWebInfLocation() {
        return this.getAsFile(this.jTextFieldWebInf.getText()).getAbsoluteFile();
    }

    private void setSrcPackages(File file) {
        this.srcPackagesLocation = file;
    }

    protected File getSrcPackagesLocation() {
        return this.srcPackagesLocation;
    }

    private String relativizeFile(File file) {
        File file2 = FileUtil.normalizeFile((File)file);
        if (CollocationQuery.areCollocated((File)this.nbProjectFolder, (File)file)) {
            return PropertyUtils.relativizeFile((File)this.nbProjectFolder, (File)file2);
        }
        return file2.getAbsolutePath();
    }

    private String getRelativeLocation(File file) {
        File file2 = FileUtil.normalizeFile((File)file);
        return Util.relativizeLocation((File)this.baseFolder, (File)this.nbProjectFolder, (File)file2);
    }

    ActionListener getCustomizerOkListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AuxiliaryConfiguration auxiliaryConfiguration = Util.getAuxiliaryConfiguration((AntProjectHelper)WebLocationsPanel.this.projectHelper);
                WebProjectGenerator.putWebSourceFolder(WebLocationsPanel.this.projectHelper, WebLocationsPanel.this.getWebSrcFolder());
                WebProjectGenerator.putWebInfFolder(WebLocationsPanel.this.projectHelper, WebLocationsPanel.this.getWebInfFolder());
                WebProjectGenerator.putWebModules(WebLocationsPanel.this.projectHelper, auxiliaryConfiguration, WebLocationsPanel.this.getWebModules());
            }
        };
    }
}

