/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbDataModel;
import org.netbeans.modules.visualweb.ejb.load.EjbDataSourceXmlCreator;
import org.netbeans.modules.visualweb.ejb.load.EjbDataSourceXmlParser;
import org.netbeans.modules.visualweb.ejb.load.EjbLoadException;
import org.netbeans.modules.visualweb.ejb.nodes.EjbLibReferenceHelper;
import org.netbeans.modules.visualweb.ejb.util.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;

public class EjbDataSourceManager {
    public static final String EJB_DATA_SUB_DIR = "ejb-sources";
    private static EjbDataSourceManager mgr = new EjbDataSourceManager();

    public static EjbDataSourceManager getInstance() {
        return mgr;
    }

    private EjbDataSourceManager() {
    }

    public void load() throws EjbLoadException, IOException {
        String string = EjbDataSourceManager.getUserDirDataSrcFileName();
        File file = new File(string);
        if (file.exists()) {
            EjbDataSourceXmlParser ejbDataSourceXmlParser = new EjbDataSourceXmlParser(string);
            EjbDataModel.getInstance().addEjbGroups(ejbDataSourceXmlParser.parse());
        }
        EjbDataModel.getInstance().resetModifiedFlag();
        OpenProjects.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("openProjects".equals(propertyChangeEvent.getPropertyName())) {
                    List<Project> list = Arrays.asList((Project[])propertyChangeEvent.getOldValue());
                    List<Project> list2 = Arrays.asList((Project[])propertyChangeEvent.getNewValue());
                    LinkedHashSet<Project> linkedHashSet = new LinkedHashSet<Project>(list2);
                    linkedHashSet.removeAll(list);
                    Project[] projectArray = linkedHashSet.toArray(new Project[linkedHashSet.size()]);
                    EjbLibReferenceHelper.syncArchiveRefs(projectArray);
                }
            }
        });
    }

    public void save() {
        String string;
        if (!EjbDataModel.getInstance().isModified()) {
            return;
        }
        try {
            string = EjbDataSourceManager.getUserDirDataSrcFileName();
        }
        catch (IOException iOException) {
            Util.getLogger().log(Level.SEVERE, "Unable to save EJB datasource state", iOException);
            return;
        }
        try {
            File file = new File(string);
            if (!file.exists()) {
                file.createNewFile();
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            EjbDataSourceXmlCreator ejbDataSourceXmlCreator = new EjbDataSourceXmlCreator(EjbDataModel.getInstance(), (Writer)bufferedWriter);
            ejbDataSourceXmlCreator.toXml();
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.EjbDataSourceManager").log(65536, "Failed to save ejb datasource to file: " + string);
            exception.printStackTrace();
        }
    }

    private static String getUserDirDataSrcFileName() throws IOException {
        File file;
        String string;
        File file2 = new File(Util.getEjbStateDir(), "ejb-datasource");
        if (!file2.isDirectory() && (string = System.getProperty("netbeans.user")) != null && (file = new File(string, "ejb-datasource")).exists()) {
            Util.copyFileRecursive(file, file2);
            try {
                FileUtil.toFileObject((File)file).delete();
            }
            catch (Exception exception) {
                Util.getLogger().log(Level.WARNING, "Unable to remove legacy ejb-datasource dir", exception);
            }
        }
        return new File(file2, "ejbsources.xml").getAbsolutePath();
    }
}

