/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.datamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbDataModelEvent;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbDataModelListener;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbGroup;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbInfo;
import org.netbeans.modules.visualweb.ejb.util.Util;

public class EjbDataModel {
    private static EjbDataModel instance = new EjbDataModel();
    private boolean modified = false;
    private Set ejbGroups = new HashSet();
    private Set listeners;

    public static EjbDataModel getInstance() {
        return instance;
    }

    private EjbDataModel() {
    }

    public EjbGroup findEjbGroupForJar(String string) {
        for (EjbGroup ejbGroup : this.ejbGroups) {
            Iterator iterator = ejbGroup.getClientJarFiles().iterator();
            while (iterator.hasNext()) {
                String string2 = Util.getFileName((String)iterator.next());
                if (!string2.equals(string)) continue;
                return ejbGroup;
            }
        }
        return null;
    }

    public Collection findEjbGroupsForJar(String string) {
        ArrayList<EjbGroup> arrayList = new ArrayList<EjbGroup>();
        for (EjbGroup ejbGroup : this.ejbGroups) {
            Iterator iterator = ejbGroup.getClientJarFiles().iterator();
            while (iterator.hasNext()) {
                String string2 = Util.getFileName((String)iterator.next());
                if (!string2.equals(string)) continue;
                arrayList.add(ejbGroup);
            }
        }
        return arrayList;
    }

    public EjbGroup findEjbGroupForJars(ArrayList arrayList) {
        for (EjbGroup ejbGroup : this.ejbGroups) {
            if (ejbGroup.getClientJarFiles().size() != arrayList.size()) continue;
            boolean bl = true;
            Iterator iterator = ejbGroup.getClientJarFiles().iterator();
            while (iterator.hasNext()) {
                String string = Util.getFileName((String)iterator.next());
                if (arrayList.contains(string)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return ejbGroup;
        }
        return null;
    }

    public EjbGroup findEjbGroupForClientWrapperJar(String string) {
        for (EjbGroup ejbGroup : this.ejbGroups) {
            String string2 = Util.getFileName(ejbGroup.getClientWrapperBeanJar());
            if (!string2.equals(string)) continue;
            return ejbGroup;
        }
        return null;
    }

    public EjbInfo findEjbInfo(String string) {
        for (EjbGroup ejbGroup : this.ejbGroups) {
            EjbInfo ejbInfo = ejbGroup.getEjbInfo(string);
            if (ejbInfo == null) continue;
            return ejbInfo;
        }
        return null;
    }

    public EjbGroup findEjbGroup(String string) {
        for (EjbGroup ejbGroup : this.ejbGroups) {
            EjbInfo ejbInfo = ejbGroup.getEjbInfo(string);
            if (ejbInfo == null) continue;
            return ejbGroup;
        }
        return null;
    }

    public EjbGroup getEjbGroup(String string) {
        for (EjbGroup ejbGroup : this.ejbGroups) {
            if (!ejbGroup.getName().equals(string)) continue;
            return ejbGroup;
        }
        return null;
    }

    public Set getEjbGroups() {
        return this.ejbGroups;
    }

    public Collection getEjbGroupNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (EjbGroup ejbGroup : this.ejbGroups) {
            arrayList.add(ejbGroup.getName());
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public void modifyEjbGroup(EjbGroup ejbGroup, EjbGroup ejbGroup2) {
        EjbGroup ejbGroup3 = this.getEjbGroup(ejbGroup.getName());
        ejbGroup3.setName(ejbGroup2.getName());
        ejbGroup3.setAppServerVendor(ejbGroup2.getAppServerVendor());
        ejbGroup3.setClientJarFiles(ejbGroup2.getClientJarFiles());
        ejbGroup3.setIIOPPort(ejbGroup2.getIIOPPort());
        ejbGroup3.setServerHost(ejbGroup2.getServerHost());
        ejbGroup3.setClientWrapperBeanJar(ejbGroup2.getClientWrapperBeanJar());
        ejbGroup3.setDesignInfoJar(ejbGroup2.getDesignInfoJar());
        if (this.listeners != null && !this.listeners.isEmpty()) {
            EjbDataModelEvent ejbDataModelEvent = new EjbDataModelEvent(ejbGroup2);
            for (EjbDataModelListener ejbDataModelListener : this.listeners) {
                ejbDataModelListener.groupChanged(ejbDataModelEvent);
            }
        }
        this.touchModifiedFlag();
    }

    public void refreshEjbGroup(EjbGroup ejbGroup) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            EjbDataModelEvent ejbDataModelEvent = new EjbDataModelEvent(ejbGroup);
            for (EjbDataModelListener ejbDataModelListener : this.listeners) {
                ejbDataModelListener.groupChanged(ejbDataModelEvent);
            }
        }
        this.touchModifiedFlag();
    }

    public void addEjbGroups(Collection collection) {
        if (this.ejbGroups == null) {
            this.ejbGroups = new HashSet(collection);
        } else {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addEjbGroup((EjbGroup)iterator.next());
            }
        }
        this.touchModifiedFlag();
    }

    public void addEjbGroup(EjbGroup ejbGroup) {
        if (this.ejbGroups == null) {
            this.ejbGroups = new HashSet();
        }
        this.checkNameUniqueness(ejbGroup);
        this.ejbGroups.add(ejbGroup);
        if (this.listeners != null && !this.listeners.isEmpty()) {
            EjbDataModelEvent ejbDataModelEvent = new EjbDataModelEvent(ejbGroup);
            for (EjbDataModelListener ejbDataModelListener : this.listeners) {
                ejbDataModelListener.groupAdded(ejbDataModelEvent);
            }
        }
        this.touchModifiedFlag();
    }

    public void removeEjbGroup(String string) {
        EjbGroup ejbGroup = this.getEjbGroup(string);
        this.removeEjbGroup(ejbGroup);
    }

    public void removeEjbGroup(EjbGroup ejbGroup) {
        this.ejbGroups.remove(ejbGroup);
        if (this.listeners != null && !this.listeners.isEmpty()) {
            EjbDataModelEvent ejbDataModelEvent = new EjbDataModelEvent(ejbGroup);
            for (EjbDataModelListener ejbDataModelListener : this.listeners) {
                ejbDataModelListener.groupDeleted(ejbDataModelEvent);
            }
        }
        this.touchModifiedFlag();
    }

    public void removeEjbGroups(Collection collection) {
        this.ejbGroups.removeAll(collection);
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (EjbDataModelListener ejbDataModelListener : this.listeners) {
                ejbDataModelListener.groupsDeleted();
            }
        }
        this.touchModifiedFlag();
    }

    public void addListener(EjbDataModelListener ejbDataModelListener) {
        if (!(ejbDataModelListener instanceof EjbDataModelListener)) {
            throw new IllegalArgumentException("Incorrect listener");
        }
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(ejbDataModelListener);
    }

    public void removeListener(EjbDataModelListener ejbDataModelListener) {
        this.listeners.remove(ejbDataModelListener);
    }

    private void checkNameUniqueness(EjbGroup ejbGroup) {
        String string;
        Collection collection = this.getEjbGroupNames();
        if (!collection.contains(string = ejbGroup.getName())) {
            return;
        }
        ejbGroup.setName(this.getAUniqueName(string));
    }

    public String getAUniqueName(String string) {
        Collection collection = this.getEjbGroupNames();
        int n = 1;
        String string2 = string + n;
        while (collection.contains(string2)) {
            string2 = string + ++n;
        }
        return string2;
    }

    public void resetModifiedFlag() {
        this.modified = false;
    }

    public void touchModifiedFlag() {
        this.modified = true;
    }

    public boolean isModified() {
        return this.modified;
    }
}

