/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.datamodel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbContainerVendor;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbInfo;
import org.netbeans.modules.visualweb.ejb.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbGroup
implements Cloneable {
    private Vector propertyChangeListeners;
    private String name;
    private String appServerVendorName;
    private String hostName;
    private int iiopPort;
    private ArrayList clientJarFileNames;
    private String ddLocationFileName;
    private String clientWrapperBeanJar;
    private String designInfoJar;
    private Map sessionBeans;
    private Map entityBeans;
    private Map mdbs;
    private ArrayList allClazz = new ArrayList();

    public EjbGroup(String string, String string2, String string3, int n, ArrayList arrayList, String string4) {
        this.name = string;
        this.appServerVendorName = string2;
        this.hostName = string3;
        this.iiopPort = n;
        this.clientJarFileNames = arrayList;
        this.ddLocationFileName = string4;
    }

    public EjbGroup(String string, String string2, String string3, int n, ArrayList arrayList) {
        this(string, string2, string3, n, arrayList, null);
    }

    public EjbGroup() {
    }

    public EjbInfo getEjbInfo(String string) {
        return (EjbInfo)this.sessionBeans.get(string);
    }

    public void setName(String string) {
        if (this.name != null && !this.name.equals(string)) {
            this.notifyPropertyChangeListeners("name", this.name, string);
        }
        this.name = string;
    }

    public void setAppServerVendor(String string) {
        this.appServerVendorName = string;
    }

    public void setServerHost(String string) {
        this.hostName = string;
    }

    public void setIIOPPort(int n) {
        this.iiopPort = n;
    }

    public void setClientJarFiles(ArrayList arrayList) {
        this.clientJarFileNames = arrayList;
    }

    public void addClientJarFile(String string) {
        if (this.clientJarFileNames == null) {
            this.clientJarFileNames = new ArrayList();
        }
        this.clientJarFileNames.add(string);
    }

    public void setDDLocationFile(String string) {
        this.ddLocationFileName = string;
    }

    public void setSessionBeans(Collection collection) {
        if (collection == null) {
            this.sessionBeans = null;
            return;
        }
        this.sessionBeans = new HashMap();
        for (EjbInfo ejbInfo : collection) {
            this.sessionBeans.put(ejbInfo.getCompInterfaceName(), ejbInfo);
        }
    }

    public void addSessionBeans(Collection collection) {
        if (this.sessionBeans == null) {
            this.sessionBeans = new HashMap();
        }
        for (EjbInfo ejbInfo : collection) {
            this.sessionBeans.put(ejbInfo.getCompInterfaceName(), ejbInfo);
        }
    }

    public void addSessionBean(EjbInfo ejbInfo) {
        if (this.sessionBeans == null) {
            this.sessionBeans = new HashMap();
        }
        this.sessionBeans.put(ejbInfo.getCompInterfaceName(), ejbInfo);
    }

    public void setEntityBeans(Collection collection) {
        if (collection == null) {
            this.entityBeans = null;
            return;
        }
        this.entityBeans = new HashMap();
        for (EjbInfo ejbInfo : collection) {
            this.entityBeans.put(ejbInfo.getCompInterfaceName(), ejbInfo);
        }
    }

    public void setMDBs(Collection collection) {
        if (collection == null) {
            this.mdbs = null;
            return;
        }
        this.mdbs = new HashMap();
        for (EjbInfo ejbInfo : collection) {
            this.mdbs.put(ejbInfo.getCompInterfaceName(), ejbInfo);
        }
    }

    public void setClientWrapperBeanJar(String string) {
        this.clientWrapperBeanJar = string;
    }

    public void setDesignInfoJar(String string) {
        this.designInfoJar = string;
    }

    public void setAllClazz(Set set) {
        ArrayList arrayList = new ArrayList(set);
        Collections.sort(arrayList);
        this.allClazz = arrayList;
    }

    public String getName() {
        return this.name;
    }

    public String getAppServerVendor() {
        return this.appServerVendorName;
    }

    public String getServerHost() {
        return this.hostName;
    }

    public int getIIOPPort() {
        return this.iiopPort;
    }

    public ArrayList getClientJarFiles() {
        return this.clientJarFileNames;
    }

    public String getDDLocationFile() {
        return this.ddLocationFileName;
    }

    public ArrayList getAllClazz() {
        return this.allClazz;
    }

    public boolean hasAnyMethodWithColletionReturn() {
        for (EjbInfo ejbInfo : this.getSessionBeans()) {
            if (!ejbInfo.hasAnyMethodWithCollectionReturn()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyConfigurableMethod() {
        for (EjbInfo ejbInfo : this.getSessionBeans()) {
            if (!ejbInfo.hasAnyConfigurableMethod()) continue;
            return true;
        }
        return false;
    }

    public String getClientJarFilesAsOneStr() {
        if (this.clientJarFileNames == null || this.clientJarFileNames.isEmpty()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (String string : this.clientJarFileNames) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public ArrayList getClientJarFileNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.clientJarFileNames != null) {
            Iterator iterator = this.clientJarFileNames.iterator();
            while (iterator.hasNext()) {
                arrayList.add(Util.getFileName((String)iterator.next()));
            }
        }
        return arrayList;
    }

    public List<EjbInfo> getSessionBeans() {
        if (this.sessionBeans != null) {
            ArrayList<EjbInfo> arrayList = new ArrayList<EjbInfo>(this.sessionBeans.values());
            Collections.sort(arrayList);
            return arrayList;
        }
        return null;
    }

    public Collection getEntityBeans() {
        if (this.entityBeans != null) {
            return this.entityBeans.values();
        }
        return null;
    }

    public Collection getMDBs() {
        if (this.mdbs != null) {
            return this.mdbs.values();
        }
        return null;
    }

    public String getDesignInfoJar() {
        return this.designInfoJar;
    }

    public String getClientWrapperBeanJar() {
        return this.clientWrapperBeanJar;
    }

    public boolean isSunAppServer() {
        return EjbContainerVendor.isSunAppServer(this.getAppServerVendor());
    }

    public boolean isWebLogicAppServer() {
        return this.getAppServerVendor().equals(EjbContainerVendor.WEBLOGIC_8_1);
    }

    public boolean isWebsphereAppServer() {
        return this.getAppServerVendor().equals(EjbContainerVendor.WEBSPHERE_5_1);
    }

    public void fixJarDir(String string) {
        Serializable serializable;
        if (this.clientJarFileNames != null) {
            serializable = new ArrayList();
            for (String string2 : this.clientJarFileNames) {
                String string3 = new File(string, Util.getFileName(string2)).getAbsolutePath();
                ((ArrayList)serializable).add(string3);
            }
            this.clientJarFileNames = serializable;
        }
        if (this.clientWrapperBeanJar != null) {
            serializable = new File(string, Util.getFileName(this.clientWrapperBeanJar));
            this.clientWrapperBeanJar = ((File)serializable).getAbsolutePath();
        }
        if (this.designInfoJar != null) {
            serializable = new File(string, Util.getFileName(this.designInfoJar));
            this.designInfoJar = ((File)serializable).getAbsolutePath();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EJB Group Name: " + this.getName() + "\n");
        stringBuffer.append("ApplicationServerVendor: " + this.getAppServerVendor() + "\n");
        stringBuffer.append("Server host: " + this.getServerHost() + "\n");
        stringBuffer.append("IIOP port: " + this.getIIOPPort() + "\n");
        stringBuffer.append("Client Jar files: " + this.getClientJarFiles().toString() + "\n");
        stringBuffer.append("WrapperBeanJarFile: " + this.getClientWrapperBeanJar() + "\n");
        stringBuffer.append("DesignInfoJar: " + this.getDesignInfoJar() + "\n");
        if (this.sessionBeans != null) {
            stringBuffer.append("Num of Session beans: " + this.sessionBeans.size() + "\n");
            stringBuffer.append(this.sessionBeans.toString());
        }
        if (this.mdbs != null) {
            stringBuffer.append("Num of MBDs: " + this.mdbs.size() + "\n");
        }
        if (this.entityBeans != null) {
            stringBuffer.append("Num of Entity beans: " + this.entityBeans.size() + "\n");
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        try {
            Iterator<Object> iterator;
            AbstractCollection abstractCollection;
            EjbGroup ejbGroup = (EjbGroup)super.clone();
            if (this.clientJarFileNames != null) {
                abstractCollection = new ArrayList();
                for (String string : this.clientJarFileNames) {
                    ((ArrayList)abstractCollection).add(string);
                }
                ejbGroup.setClientJarFiles((ArrayList)abstractCollection);
            }
            if (this.sessionBeans != null) {
                abstractCollection = new HashSet();
                for (String string : this.sessionBeans.keySet()) {
                    abstractCollection.add(((EjbInfo)this.sessionBeans.get(string)).clone());
                }
                ejbGroup.setSessionBeans(abstractCollection);
            }
            if (this.entityBeans != null) {
                abstractCollection = new ArrayList();
                iterator = this.entityBeans.keySet().iterator();
                while (iterator.hasNext()) {
                    abstractCollection.add(((EjbInfo)iterator.next()).clone());
                }
                ejbGroup.setEntityBeans(abstractCollection);
            }
            if (this.mdbs != null) {
                abstractCollection = new ArrayList();
                iterator = this.mdbs.keySet().iterator();
                while (iterator.hasNext()) {
                    abstractCollection.add(((EjbInfo)iterator.next()).clone());
                }
                ejbGroup.setMDBs(abstractCollection);
            }
            return ejbGroup;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeListeners == null) {
            this.propertyChangeListeners = new Vector();
        }
        this.propertyChangeListeners.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeListeners == null) {
            this.propertyChangeListeners.remove(propertyChangeListener);
        }
    }

    private void notifyPropertyChangeListeners(String string, Object object, Object object2) {
        if (this.propertyChangeListeners != null && !this.propertyChangeListeners.isEmpty()) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
            for (int i = 0; i < this.propertyChangeListeners.size(); ++i) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.propertyChangeListeners.get(i);
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }
}

