/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.load;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbDataModel;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbGroup;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbInfo;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodInfo;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodParam;

public class EjbDataSourceXmlCreator {
    public static final String XML_BEGIN_1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    public static final String XML_BEGIN_2 = "<ejb-data-source xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n";
    public static final String XML_END = "</ejb-data-source>";
    private static final int INDENT_SPACES = 4;
    private Collection ejbGroups;
    private Writer out;

    public EjbDataSourceXmlCreator(EjbDataModel ejbDataModel, Writer writer) {
        this.ejbGroups = ejbDataModel.getEjbGroups();
        this.out = writer;
    }

    public EjbDataSourceXmlCreator(Collection collection, Writer writer) {
        this.ejbGroups = collection;
        this.out = writer;
    }

    public void toXml() throws IOException {
        this.out.write(XML_BEGIN_1);
        this.out.write(XML_BEGIN_2);
        if (this.ejbGroups == null || this.ejbGroups.isEmpty()) {
            this.out.write(XML_END);
            return;
        }
        for (EjbGroup ejbGroup : this.ejbGroups) {
            this.out.write(this.openTag("ejb-group", true, 1));
            this.out.write(this.openTag("group-name", false, 2));
            this.out.write(ejbGroup.getName());
            this.out.write(this.closeTag("group-name", 0));
            this.out.write(this.openTag("container", false, 2));
            this.out.write(ejbGroup.getAppServerVendor());
            this.out.write(this.closeTag("container", 0));
            this.out.write(this.openTag("server-host", false, 2));
            this.out.write(ejbGroup.getServerHost());
            this.out.write(this.closeTag("server-host", 0));
            this.out.write(this.openTag("iiop-port", false, 2));
            this.out.write(Integer.toString(ejbGroup.getIIOPPort()));
            this.out.write(this.closeTag("iiop-port", 0));
            for (String string : ejbGroup.getClientJarFiles()) {
                this.out.write(this.openTag("client-jar", false, 2));
                this.out.write(string);
                this.out.write(this.closeTag("client-jar", 0));
            }
            this.out.write(this.openTag("bean-wrapper-jar", false, 2));
            this.out.write(ejbGroup.getClientWrapperBeanJar());
            this.out.write(this.closeTag("bean-wrapper-jar", 0));
            if (ejbGroup.getDesignInfoJar() != null) {
                this.out.write(this.openTag("design_time_jar", false, 2));
                this.out.write(ejbGroup.getDesignInfoJar());
                this.out.write(this.closeTag("design_time_jar", 0));
            }
            if (ejbGroup.getDDLocationFile() != null) {
                this.out.write(this.openTag("additional-deployment-descriptors", false, 2));
                this.out.write(ejbGroup.getDDLocationFile());
                this.out.write(this.closeTag("additional-deployment-descriptors", 0));
            }
            this.out.write(this.openTag("enterprise-beans", true, 2));
            if (ejbGroup.getSessionBeans() != null && !ejbGroup.getSessionBeans().isEmpty()) {
                this.writeOutSessionBeans(ejbGroup.getSessionBeans());
            }
            this.out.write(this.closeTag("enterprise-beans", 2));
            this.out.write(this.closeTag("ejb-group", 1));
        }
        this.out.write(XML_END);
    }

    private void writeOutSessionBeans(Collection collection) throws IOException {
        for (EjbInfo ejbInfo : collection) {
            String string = "stateless-session";
            if (ejbInfo.getBeanType() == 2) {
                string = "stateful-session";
            }
            this.out.write(this.openTag(string, true, 3));
            this.out.write(this.openTag("jndi-name", false, 4));
            this.out.write(ejbInfo.getJNDIName());
            this.out.write(this.closeTag("jndi-name", 0));
            this.out.write(this.openTag("ejb-name", false, 4));
            this.out.write(ejbInfo.getEjbName());
            this.out.write(this.closeTag("ejb-name", 0));
            this.out.write(this.openTag("home", false, 4));
            this.out.write(ejbInfo.getHomeInterfaceName());
            this.out.write(this.closeTag("home", 0));
            this.out.write(this.openTag("remote", false, 4));
            this.out.write(ejbInfo.getCompInterfaceName());
            this.out.write(this.closeTag("remote", 0));
            this.out.write(this.openTag("web-ejb-ref", false, 4));
            this.out.write(ejbInfo.getWebEjbRef());
            this.out.write(this.closeTag("web-ejb-ref", 0));
            this.out.write(this.openTag("wrapper-bean", false, 4));
            this.out.write(ejbInfo.getBeanWrapperName());
            this.out.write(this.closeTag("wrapper-bean", 0));
            this.out.write(this.openTag("wrapper-bean-info", false, 4));
            this.out.write(ejbInfo.getBeanInfoWrapperName());
            this.out.write(this.closeTag("wrapper-bean-info", 0));
            if (ejbInfo.getMethods() != null && !ejbInfo.getMethods().isEmpty()) {
                this.writeOutMethods(ejbInfo.getMethods());
            }
            this.out.write(this.closeTag(string, 3));
        }
    }

    private void writeOutMethods(Collection collection) throws IOException {
        for (MethodInfo methodInfo : collection) {
            ArrayList arrayList;
            String string = "method";
            if (!methodInfo.isBusinessMethod()) {
                string = "create-method";
            }
            this.out.write(this.openTag(string, true, 4));
            this.out.write(this.openTag("method-name", false, 5));
            this.out.write(methodInfo.getName());
            this.out.write(this.closeTag("method-name", 0));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (methodInfo.getReturnType().isCollection()) {
                hashMap.put("is-collection", "true");
                if (methodInfo.getReturnType().getElemClassName() != null) {
                    hashMap.put("element-type", methodInfo.getReturnType().getElemClassName());
                }
            } else {
                hashMap.put("is-collection", "false");
            }
            this.out.write(this.openTag("return-type", hashMap, false, 5));
            this.out.write(methodInfo.getReturnType().getClassName());
            this.out.write(this.closeTag("return-type", 0));
            ArrayList arrayList2 = methodInfo.getParameters();
            if (arrayList2 != null && !arrayList2.isEmpty()) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    MethodParam methodParam = (MethodParam)arrayList2.get(i);
                    HashMap<String, String> hashMap2 = new HashMap<String, String>();
                    hashMap2.put("name", methodParam.getName());
                    this.out.write(this.openTag("parameter", hashMap2, false, 5));
                    this.out.write(methodParam.getType());
                    this.out.write(this.closeTag("parameter", 0));
                }
            }
            if ((arrayList = methodInfo.getExceptions()) != null && !arrayList.isEmpty()) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.out.write(this.openTag("exception", false, 5));
                    this.out.write((String)arrayList.get(i));
                    this.out.write(this.closeTag("exception", 0));
                }
            }
            if (methodInfo.getDataProvider() != null) {
                this.out.write(this.openTag("dataprovider", false, 5));
                this.out.write(methodInfo.getDataProvider());
                this.out.write(this.closeTag("dataprovider", 0));
            }
            this.out.write(this.closeTag(string, 4));
        }
    }

    private String openTag(String string, boolean bl, int n) {
        return this.openTag(string, null, bl, n);
    }

    private String openTag(String string, Map map, boolean bl, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n * 4; ++i) {
            stringBuffer.append(" ");
        }
        stringBuffer.append("<");
        stringBuffer.append(string);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                stringBuffer.append(" ");
                stringBuffer.append((String)entry.getKey());
                stringBuffer.append("=\"");
                stringBuffer.append((String)entry.getValue());
                stringBuffer.append("\"");
            }
        }
        stringBuffer.append(">");
        if (bl) {
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private String closeTag(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n * 4; ++i) {
            stringBuffer.append(" ");
        }
        stringBuffer.append("</");
        stringBuffer.append(string);
        stringBuffer.append(">");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

