/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.load;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.visualweb.ejb.load.EjbLoadException;
import org.netbeans.modules.visualweb.ejb.load.StdDeploymentDescriptorParser;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SunDeploymentDescriptorParser
extends DefaultHandler {
    private static final String EJB_TAG = "ejb";
    private static final String EJB_NAME_TAG = "ejb-name";
    private static final String JNDI_NAME_TAG = "jndi-name";
    private String xmlFileName;
    private String jndiName;
    private String ejbName;
    private String currentTag;
    private String data;
    private Map nameMapping = new HashMap();

    public SunDeploymentDescriptorParser(String string) {
        this.xmlFileName = string;
    }

    public Map parse() throws EjbLoadException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(this.xmlFileName, (DefaultHandler)this);
            return this.nameMapping;
        }
        catch (IOException iOException) {
            String string = "Error occured when trying to parse the vendor EJB deployment descriptor. Cannot read file " + this.xmlFileName;
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.SunDeploymentDescriptorParser").log(16, string);
            iOException.printStackTrace();
            throw new EjbLoadException(iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = "Error occured when trying to parse the vendor EJB deployment descriptor file " + this.xmlFileName;
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.SunDeploymentDescriptorParser").log(16, string);
            parserConfigurationException.printStackTrace();
            String string2 = NbBundle.getMessage(StdDeploymentDescriptorParser.class, (String)"CANNOT_PARSE_VENDOR_DD");
            throw new EjbLoadException(1, string2);
        }
        catch (SAXException sAXException) {
            String string = "Error occured when trying to parse the vendor EJB deployment descriptor file " + this.xmlFileName;
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.SunDeploymentDescriptorParser").log(16, string);
            sAXException.printStackTrace();
            String string3 = NbBundle.getMessage(StdDeploymentDescriptorParser.class, (String)"CANNOT_PARSE_VENDOR_DD");
            throw new EjbLoadException(1, string3);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.currentTag = string3;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.currentTag != null) {
            this.setData();
        }
        if (this.ejbName != null && this.jndiName != null) {
            this.nameMapping.put(this.ejbName, this.jndiName);
            this.ejbName = null;
            this.jndiName = null;
        }
        this.currentTag = null;
        this.data = null;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.data = this.data == null ? new String(cArray, n, n2) : this.data + new String(cArray, n, n2);
    }

    private void setData() {
        if (this.data != null) {
            this.data = this.data.trim();
        }
        if (this.currentTag.equalsIgnoreCase(JNDI_NAME_TAG)) {
            this.jndiName = this.data;
        } else if (this.currentTag.equalsIgnoreCase(EJB_NAME_TAG)) {
            this.ejbName = this.data;
        }
    }

    public InputSource resolveEntity(String string, String string2) {
        return new InputSource(new StringReader(""));
    }
}

