/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URLClassLoader;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbGroup;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodInfo;
import org.netbeans.modules.visualweb.ejb.load.EjbLoaderHelper;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class ComboBoxAutoCompletion
extends PlainDocument {
    private JComboBox comboBox;
    private ComboBoxModel model;
    private JTextComponent editor;
    private boolean selecting = false;
    private boolean hidePopupOnFocusLoss;
    private boolean hitBackspace = false;
    private boolean hitBackspaceOnSelection;
    private boolean listContainsSelectedItem;
    private boolean enterKeyPressed = false;
    private EjbGroup ejbGroup;
    private MethodInfo methodInfo;
    private URLClassLoader classloader;

    public ComboBoxAutoCompletion(JComboBox jComboBox) {
        this.comboBox = jComboBox;
        this.model = this.comboBox.getModel();
        this.editor = (JTextComponent)this.comboBox.getEditor().getEditorComponent();
        this.editor.setDocument(this);
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ComboBoxAutoCompletion.this.selecting) {
                    ComboBoxAutoCompletion.this.highlightCompletedText(0);
                }
                if (ComboBoxAutoCompletion.this.methodInfo != null && ComboBoxAutoCompletion.this.enterKeyPressed) {
                    ComboBoxAutoCompletion.this.validateColElemClassName((String)ComboBoxAutoCompletion.this.comboBox.getSelectedItem());
                }
            }
        });
        this.editor.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (ComboBoxAutoCompletion.this.comboBox.isDisplayable()) {
                    ComboBoxAutoCompletion.this.comboBox.setPopupVisible(true);
                }
                ComboBoxAutoCompletion.this.hitBackspace = false;
                ComboBoxAutoCompletion.this.enterKeyPressed = false;
                switch (keyEvent.getKeyCode()) {
                    case 8: {
                        ComboBoxAutoCompletion.this.hitBackspace = true;
                        ComboBoxAutoCompletion.this.hitBackspaceOnSelection = ComboBoxAutoCompletion.this.editor.getSelectionStart() != ComboBoxAutoCompletion.this.editor.getSelectionEnd();
                        break;
                    }
                    case 10: {
                        ComboBoxAutoCompletion.this.enterKeyPressed = true;
                    }
                }
            }
        });
        this.hidePopupOnFocusLoss = System.getProperty("java.version").startsWith("1.5");
        this.editor.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ComboBoxAutoCompletion.this.highlightCompletedText(0);
            }

            public void focusLost(FocusEvent focusEvent) {
                if (ComboBoxAutoCompletion.this.hidePopupOnFocusLoss) {
                    ComboBoxAutoCompletion.this.comboBox.setPopupVisible(false);
                }
            }
        });
        Object object = this.comboBox.getSelectedItem();
        if (object != null) {
            this.setText(object.toString());
        }
        this.highlightCompletedText(0);
    }

    public void setEjbGroup(EjbGroup ejbGroup) {
        this.ejbGroup = ejbGroup;
    }

    public void setMethodInfo(MethodInfo methodInfo) {
        this.methodInfo = methodInfo;
    }

    public void validateColElemClassName(String string) {
        if (!this.methodInfo.getReturnType().isCollection()) {
            return;
        }
        if (string == null || string.trim().length() == 0) {
            return;
        }
        if (this.classloader == null) {
            this.classloader = EjbLoaderHelper.getEjbGroupClassLoader(this.ejbGroup);
        }
        try {
            Class<?> clazz = Class.forName(string, true, this.classloader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)("Class " + string + " not found"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
    }

    public void remove(int n, int n2) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        if (this.hitBackspace) {
            if (this.listContainsSelectedItem) {
                if (n > 0) {
                    if (this.hitBackspaceOnSelection) {
                        --n;
                    }
                } else {
                    this.comboBox.getToolkit().beep();
                }
                this.highlightCompletedText(n);
                return;
            }
            super.remove(n, n2);
            String string = this.getText(0, this.getLength());
            Object object = this.lookupItem(string);
            if (object != null) {
                this.setSelectedItem(object);
                this.listContainsSelectedItem = true;
            } else {
                object = string;
                this.setSelectedItem(object);
                this.listContainsSelectedItem = false;
            }
            String string2 = object.toString();
            this.setText(string2);
            if (this.listContainsSelectedItem) {
                this.highlightCompletedText(n);
            }
        } else {
            super.remove(n, n2);
            this.setSelectedItem(this.getText(0, this.getLength()));
            this.listContainsSelectedItem = false;
        }
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        super.insertString(n, string, attributeSet);
        Object object = this.lookupItem(this.getText(0, this.getLength()));
        this.listContainsSelectedItem = true;
        if (object == null) {
            object = this.getText(0, this.getLength());
            this.listContainsSelectedItem = false;
        }
        this.setSelectedItem(object);
        this.setText(object.toString());
        if (this.listContainsSelectedItem) {
            this.highlightCompletedText(n + string.length());
        }
    }

    private void setText(String string) {
        try {
            super.remove(0, this.getLength());
            super.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException(badLocationException.toString());
        }
    }

    private void highlightCompletedText(int n) {
        this.editor.setCaretPosition(this.getLength());
        this.editor.moveCaretPosition(n);
    }

    private void setSelectedItem(Object object) {
        this.selecting = true;
        this.model.setSelectedItem(object);
        this.selecting = false;
    }

    private Object lookupItem(String string) {
        Object object = this.model.getSelectedItem();
        if (object != null && this.startsWithIgnoreCase(object.toString(), string) && this.listContainsSelectedItem) {
            return object;
        }
        int n = this.model.getSize();
        for (int i = 0; i < n; ++i) {
            Object e = this.model.getElementAt(i);
            if (!e.toString().startsWith(string)) continue;
            return e;
        }
        return null;
    }

    private boolean startsWithIgnoreCase(String string, String string2) {
        return string.toUpperCase().startsWith(string2.toUpperCase());
    }

    private static void createAndShowGUI() {
        JComboBox<Object> jComboBox = new JComboBox<Object>(new Object[]{"Ester", "Jordi", "Jordina", "Jorge", "Sergi"});
        jComboBox.setEditable(true);
        new ComboBoxAutoCompletion(jComboBox);
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(jComboBox);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ComboBoxAutoCompletion.createAndShowGUI();
            }
        });
    }
}

