/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JButton;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbDataModel;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbGroup;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbInfo;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodInfo;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodParam;
import org.netbeans.modules.visualweb.ejb.load.EjbLoadException;
import org.netbeans.modules.visualweb.ejb.load.EjbLoader;
import org.netbeans.modules.visualweb.ejb.ui.ConfigureMethodsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class ConfigureMethodsDialog
implements ActionListener {
    private boolean cancelled = false;
    private boolean refresh = false;
    private DialogDescriptor dialogDescriptor;
    private Dialog dialog;
    private ConfigureMethodsPanel configurePanel;
    private JButton okButton;
    private JButton cancelButton;
    private EjbGroup ejbGroup;
    private EjbGroup origCopy;

    public ConfigureMethodsDialog(EjbGroup ejbGroup, boolean bl) {
        this(ejbGroup);
        this.refresh = bl;
    }

    public ConfigureMethodsDialog(EjbGroup ejbGroup) {
        this.origCopy = ejbGroup;
        this.ejbGroup = (EjbGroup)ejbGroup.clone();
        this.configurePanel = new ConfigureMethodsPanel(this.ejbGroup);
        this.dialogDescriptor = new DialogDescriptor((Object)this.configurePanel, NbBundle.getMessage(ConfigureMethodsDialog.class, (String)"CONFIGURE_METHODS"), true, (ActionListener)this);
        this.okButton = new JButton(NbBundle.getMessage(ConfigureMethodsDialog.class, (String)"OK"));
        this.okButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("OK"));
        this.cancelButton = new JButton(NbBundle.getMessage(ConfigureMethodsDialog.class, (String)"CANCEL_BUTTON_LABEL"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("CANCEL_BUTTON_DESC"));
        this.dialogDescriptor.setOptions(new Object[]{this.okButton, this.cancelButton});
        this.dialogDescriptor.setClosingOptions(new Object[]{this.cancelButton});
        this.dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        this.dialog.setResizable(true);
        this.dialog.pack();
    }

    public void showDialog() {
        this.dialog.setVisible(true);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public EjbGroup getEjbGroup() {
        return this.ejbGroup;
    }

    public void enableAddButton(boolean bl) {
        this.okButton.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.configurePanel.getMethodDetailPanel().stopLastCellEditing();
            this.configurePanel.getMethodDetailPanel().updateColElemClassName();
            if (this.refresh || this.isModified(this.origCopy, this.ejbGroup)) {
                EjbLoader ejbLoader = new EjbLoader(this.ejbGroup);
                try {
                    ejbLoader.createWrapperClientBeans();
                    this.doModification(this.origCopy, this.ejbGroup);
                    EjbDataModel.getInstance().touchModifiedFlag();
                }
                catch (EjbLoadException ejbLoadException) {
                    String string = ejbLoadException.getMessage();
                    if (ejbLoadException.getExceptionType() == 2) {
                        string = NbBundle.getMessage(ConfigureMethodsDialog.class, (String)"FAILED_TO_MODIFY_METHODS_CONFIG", (Object)this.ejbGroup.getName());
                    }
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    return;
                }
            }
            this.dialog.dispose();
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.cancelled = true;
        }
    }

    private boolean isModified(EjbGroup ejbGroup, EjbGroup ejbGroup2) {
        return this.findModifications(ejbGroup, ejbGroup2, false);
    }

    private void doModification(EjbGroup ejbGroup, EjbGroup ejbGroup2) {
        this.findModifications(ejbGroup, ejbGroup2, true);
    }

    private boolean findModifications(EjbGroup ejbGroup, EjbGroup ejbGroup2, boolean bl) {
        boolean bl2 = false;
        for (EjbInfo ejbInfo : ejbGroup.getSessionBeans()) {
            EjbInfo ejbInfo2 = ejbGroup2.getEjbInfo(ejbInfo.getCompInterfaceName());
            ArrayList arrayList = ejbInfo.getMethods();
            ArrayList arrayList2 = ejbInfo2.getMethods();
            for (int i = 0; i < arrayList.size(); ++i) {
                ArrayList arrayList3;
                MethodInfo methodInfo = (MethodInfo)arrayList.get(i);
                if (!methodInfo.isMethodConfigurable()) continue;
                MethodInfo methodInfo2 = (MethodInfo)arrayList2.get(i);
                if (methodInfo.getReturnType().isCollection() && !methodInfo.getReturnType().getElemClassName().equals(methodInfo2.getReturnType().getElemClassName())) {
                    methodInfo.getReturnType().setElemClassName(methodInfo2.getReturnType().getElemClassName());
                    bl2 = true;
                }
                if ((arrayList3 = methodInfo.getParameters()) == null || arrayList3.isEmpty()) continue;
                ArrayList arrayList4 = methodInfo2.getParameters();
                for (int j = 0; j < arrayList3.size(); ++j) {
                    MethodParam methodParam = (MethodParam)arrayList3.get(j);
                    MethodParam methodParam2 = (MethodParam)arrayList4.get(j);
                    if (methodParam.getName().equals(methodParam2.getName())) continue;
                    if (bl) {
                        methodParam.setName(methodParam2.getName());
                    }
                    bl2 = true;
                }
            }
        }
        return bl2;
    }
}

