/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.swing.JButton;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbDataModel;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbGroup;
import org.netbeans.modules.visualweb.ejb.load.EjbDataSourceXmlCreator;
import org.netbeans.modules.visualweb.ejb.ui.ExportEjbDataSourcesPanel;
import org.netbeans.modules.visualweb.ejb.ui.ImportEjbDataSourcesDialog;
import org.netbeans.modules.visualweb.ejb.ui.PortableEjbDataSource;
import org.netbeans.modules.visualweb.ejb.util.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ExportEjbDataSourceDialog
implements ActionListener {
    private Dialog dialog;
    private JButton okButton;
    private JButton cancelButton;
    private ExportEjbDataSourcesPanel exportPanel;
    private PortableEjbDataSource[] ejbDatasources;

    public ExportEjbDataSourceDialog() {
        this.ejbDatasources = this.getPortableEjbDataSources(null);
        this.createDialog();
    }

    public ExportEjbDataSourceDialog(Collection collection) {
        this.ejbDatasources = this.getPortableEjbDataSources(collection);
        this.createDialog();
    }

    private void createDialog() {
        this.exportPanel = new ExportEjbDataSourcesPanel();
        this.exportPanel.setEjbDataSources(this.ejbDatasources);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.exportPanel, NbBundle.getMessage(ExportEjbDataSourceDialog.class, (String)"EXPORT_EJB_DATASOURCES"), true, (ActionListener)this);
        this.okButton = new JButton(NbBundle.getMessage(ImportEjbDataSourcesDialog.class, (String)"OK_BUTTON_LABEL"));
        this.okButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("OK_BUTTON_DESC"));
        this.okButton.setMnemonic(NbBundle.getMessage(ImportEjbDataSourcesDialog.class, (String)"OK_BUTTON_MNEMONIC").charAt(0));
        this.cancelButton = new JButton(NbBundle.getMessage(ExportEjbDataSourceDialog.class, (String)"CANCEL_BUTTON_LABEL"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("CANCEL_BUTTON_DESC"));
        this.cancelButton.setMnemonic(NbBundle.getMessage(ImportEjbDataSourcesDialog.class, (String)"CANCEL_BUTTON_MNEMONIC").charAt(0));
        dialogDescriptor.setOptions(new Object[]{this.okButton, this.cancelButton});
        dialogDescriptor.setClosingOptions(new Object[]{this.cancelButton});
        dialogDescriptor.setHelpCtx(new HelpCtx("projrave_ejb_howtoejbs_ejb_export"));
        this.dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        this.dialog.setResizable(true);
    }

    public void showDialog() {
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            NotifyDescriptor.Confirmation confirmation;
            String string;
            if (!this.exportPanel.saveChange()) {
                return;
            }
            ArrayList<EjbGroup> arrayList = new ArrayList<EjbGroup>();
            for (int i = 0; i < this.ejbDatasources.length; ++i) {
                if (!this.ejbDatasources[i].isPortable()) continue;
                arrayList.add(this.ejbDatasources[i].getEjbGroup());
            }
            if (arrayList.isEmpty()) {
                String string2 = NbBundle.getMessage(ExportEjbDataSourceDialog.class, (String)"NO_EXPORT_SELECTION");
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            String string3 = this.exportPanel.getFilePath();
            if (string3 == null || string3.length() == 0) {
                String string4 = NbBundle.getMessage(ExportEjbDataSourceDialog.class, (String)"NO_EXPORT_FILE");
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string4, 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            if (!string3.toLowerCase().endsWith(".jar")) {
                string3 = string3 + ".jar";
            }
            if (new File(string3).exists()) {
                string = NbBundle.getMessage(ExportEjbDataSourceDialog.class, (String)"FILE_EXISTS", (Object)string3);
                confirmation = new NotifyDescriptor.Confirmation((Object)string, 2);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) != NotifyDescriptor.OK_OPTION) {
                    return;
                }
            }
            if (this.export(arrayList, string3)) {
                string = null;
                string = arrayList.size() == 1 ? NbBundle.getMessage(ExportEjbDataSourceDialog.class, (String)"EXPORT_SUCCESSFULLY_ONE", (Object)string3) : NbBundle.getMessage(ExportEjbDataSourceDialog.class, (String)"EXPORT_SUCCESSFULLY", (Object)Integer.toString(arrayList.size()), (Object)string3);
                confirmation = new NotifyDescriptor.Message((Object)string, 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                this.dialog.dispose();
            }
        }
    }

    private boolean export(Collection collection, String string) {
        Collection collection2 = this.getJarFilePathes(collection);
        if (collection2 == null) {
            return false;
        }
        String string2 = this.createXmlFile(collection);
        if (string2 != null) {
            collection2.add(string2);
            return this.jarThemUp(string, collection2);
        }
        return false;
    }

    private String createXmlFile(Collection collection) {
        String string = System.getProperty("java.io.tmpdir") + File.separator + "ejbsources.xml";
        try {
            File file = new File(string);
            file.deleteOnExit();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            for (EjbGroup ejbGroup : collection) {
                ejbGroup.setClientJarFiles(ejbGroup.getClientJarFileNames());
                ejbGroup.setClientWrapperBeanJar(Util.getFileName(ejbGroup.getClientWrapperBeanJar()));
                ejbGroup.setDesignInfoJar(Util.getFileName(ejbGroup.getDesignInfoJar()));
            }
            EjbDataSourceXmlCreator ejbDataSourceXmlCreator = new EjbDataSourceXmlCreator(collection, (Writer)bufferedWriter);
            ejbDataSourceXmlCreator.toXml();
            bufferedWriter.flush();
            bufferedWriter.close();
            return string;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            String string2 = NbBundle.getMessage(ExportEjbDataSourceDialog.class, (String)"ERROR_EXPORT");
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return null;
        }
    }

    private Collection getJarFilePathes(Collection collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (EjbGroup ejbGroup : collection) {
            hashSet.addAll(ejbGroup.getClientJarFiles());
            hashSet.add(ejbGroup.getClientWrapperBeanJar());
            hashSet.add(ejbGroup.getDesignInfoJar());
        }
        return this.checkJarFileExistence(hashSet);
    }

    private Collection checkJarFileExistence(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (String string : collection) {
            if (new File(string).exists()) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string);
        }
        if (stringBuffer.length() != 0) {
            String string;
            String string2 = NbBundle.getMessage(ExportEjbDataSourceDialog.class, (String)"FILES_NOT_FOUND", (Object)stringBuffer);
            string = new NotifyDescriptor.Message((Object)string2, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)string);
            return null;
        }
        return collection;
    }

    private boolean jarThemUp(String string, Collection collection) {
        try {
            int n = 2048;
            BufferedInputStream bufferedInputStream = null;
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            JarOutputStream jarOutputStream = new JarOutputStream(new BufferedOutputStream(fileOutputStream));
            jarOutputStream.setMethod(8);
            byte[] byArray = new byte[n];
            HashSet<String> hashSet = new HashSet<String>();
            for (String string2 : collection) {
                int n2;
                String string3 = new File(string2).getName();
                if (hashSet.contains(string3)) continue;
                hashSet.add(string3);
                FileInputStream fileInputStream = new FileInputStream(string2);
                bufferedInputStream = new BufferedInputStream(fileInputStream, n);
                JarEntry jarEntry = new JarEntry(new File(string2).getName());
                jarOutputStream.putNextEntry(jarEntry);
                while ((n2 = bufferedInputStream.read(byArray, 0, n)) != -1) {
                    jarOutputStream.write(byArray, 0, n2);
                }
                bufferedInputStream.close();
            }
            jarOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string4 = NbBundle.getMessage(ExportEjbDataSourceDialog.class, (String)"ERROR_EXPORT");
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string4, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return false;
        }
    }

    private PortableEjbDataSource[] getPortableEjbDataSources(Collection collection) {
        Set set = EjbDataModel.getInstance().getEjbGroups();
        if (set != null) {
            PortableEjbDataSource[] portableEjbDataSourceArray = new PortableEjbDataSource[set.size()];
            int n = 0;
            for (EjbGroup ejbGroup : set) {
                boolean bl = false;
                if (collection == null) {
                    bl = true;
                } else if (collection.contains(ejbGroup.getName())) {
                    bl = true;
                }
                portableEjbDataSourceArray[n++] = new PortableEjbDataSource((EjbGroup)ejbGroup.clone(), bl);
            }
            return portableEjbDataSourceArray;
        }
        return null;
    }
}

