/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URLClassLoader;
import java.util.ResourceBundle;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbGroup;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodInfo;
import org.netbeans.modules.visualweb.ejb.datamodel.MethodParam;
import org.netbeans.modules.visualweb.ejb.load.EjbLoaderHelper;
import org.netbeans.modules.visualweb.ejb.util.InvalidParameterNameException;
import org.netbeans.modules.visualweb.ejb.util.MethodParamValidator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class MethodDetailPanel
extends JPanel {
    private EjbGroup ejbGroup;
    private MethodInfo methodInfo;
    private URLClassLoader classloader;
    private JTextField classNameTextField;
    private JLabel elemClassTypeLabel;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel methodSigLabel;
    private JLabel paramLabel;
    private JTable paramTable;
    private JLabel returnTypeLabel;
    private JTextField returnTypeTextField;
    private JTextArea signatureTextArea;

    public MethodDetailPanel(EjbGroup ejbGroup, MethodInfo methodInfo) {
        this.initComponents();
        this.paramTable.setPreferredScrollableViewportSize(this.paramTable.getPreferredSize());
        this.ejbGroup = ejbGroup;
        this.methodInfo = methodInfo;
        this.displayValue();
    }

    private void displayValue() {
        if (this.methodInfo != null) {
            this.signatureTextArea.setText(this.methodInfo.toString());
            if (this.methodInfo.getReturnType().isCollection()) {
                this.returnTypeTextField.setText(this.methodInfo.getReturnType().getClassName());
                this.classNameTextField.setEditable(true);
                this.classNameTextField.setText(this.methodInfo.getReturnType().getElemClassName());
            } else {
                this.returnTypeTextField.setText(this.methodInfo.getReturnType().getClassName());
                this.classNameTextField.setText(null);
                this.classNameTextField.setEditable(false);
            }
            MethodParamTableModel methodParamTableModel = new MethodParamTableModel(this.methodInfo);
            this.paramTable.setModel(methodParamTableModel);
            this.paramTable.setDefaultEditor(String.class, new DefaultCellEditor(new JTextField()));
        } else {
            this.paramTable.setModel(new DefaultTableModel());
            this.paramTable.setDefaultEditor(String.class, new DefaultCellEditor(new JTextField()));
            this.classNameTextField.setText(null);
            this.returnTypeTextField.setText(null);
            this.classNameTextField.setEditable(false);
        }
    }

    public void updateColElemClassName() {
        if (this.methodInfo == null) {
            return;
        }
        String string = this.classNameTextField.getText();
        if (string != null && string.trim().length() != 0) {
            if (this.classloader == null) {
                this.classloader = EjbLoaderHelper.getEjbGroupClassLoader(this.ejbGroup);
            }
            try {
                Class<?> clazz = Class.forName(string, true, this.classloader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)("Class " + string + " not found"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            this.methodInfo.getReturnType().setElemClassName(string.trim());
        } else {
            this.methodInfo.getReturnType().setElemClassName(null);
        }
    }

    public void stopLastCellEditing() {
        if (this.paramTable.isEditing()) {
            this.paramTable.getCellEditor().stopCellEditing();
        }
    }

    public void setMethod(MethodInfo methodInfo) {
        this.methodInfo = methodInfo;
        this.displayValue();
    }

    private void initComponents() {
        this.returnTypeLabel = new JLabel();
        this.paramLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.signatureTextArea = new JTextArea();
        this.methodSigLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.paramTable = new JTable();
        this.returnTypeTextField = new JTextField();
        this.elemClassTypeLabel = new JLabel();
        this.classNameTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.returnTypeLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("RETURN_TYPE_LABEL_MNEMONIC").charAt(0));
        this.returnTypeLabel.setLabelFor(this.returnTypeTextField);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle");
        this.returnTypeLabel.setText(resourceBundle.getString("RETURN_TYPE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.returnTypeLabel, gridBagConstraints);
        this.returnTypeLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("RETURN_TYPE_DESC"));
        this.paramLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("METHOD_PARAMETERS_LABEL_MNEMONIC").charAt(0));
        this.paramLabel.setLabelFor(this.paramTable);
        this.paramLabel.setText(resourceBundle.getString("PARAMETER"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.paramLabel, gridBagConstraints);
        this.paramLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("PARAMETER_DESC"));
        this.jScrollPane2.setAutoscrolls(true);
        this.signatureTextArea.setEditable(false);
        this.signatureTextArea.setLineWrap(true);
        this.signatureTextArea.setRows(3);
        this.signatureTextArea.setAutoscrolls(false);
        this.jScrollPane2.setViewportView(this.signatureTextArea);
        this.signatureTextArea.getAccessibleContext().setAccessibleName(resourceBundle.getString("METHOD_SIGNATURE"));
        this.signatureTextArea.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("METHOD_SIGNATURE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        this.methodSigLabel.setLabelFor(this.signatureTextArea);
        Mnemonics.setLocalizedText((JLabel)this.methodSigLabel, (String)NbBundle.getMessage(MethodDetailPanel.class, (String)"METHOD_SIGNATURE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.methodSigLabel, gridBagConstraints);
        this.methodSigLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MethodDetailPanel.class, (String)"METHOD_SIGNATURE"));
        this.paramTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.paramTable);
        this.paramTable.getAccessibleContext().setAccessibleName(resourceBundle.getString("PARAMETER_DESC"));
        this.paramTable.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("PARAMETER_DESC"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.7;
        gridBagConstraints.insets = new Insets(12, 0, 6, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jScrollPane1.getAccessibleContext().setAccessibleName(resourceBundle.getString("PARAMETER"));
        this.jScrollPane1.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("PARAMETER_DESC"));
        this.returnTypeTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 10, 0, 2);
        this.add((Component)this.returnTypeTextField, gridBagConstraints);
        this.returnTypeTextField.getAccessibleContext().setAccessibleName(resourceBundle.getString("RETURN_TYPE_DESC"));
        this.returnTypeTextField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("RETURN_TYPE_DESC"));
        this.elemClassTypeLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("ELEMENT_CLASS_LABEL_MNEMONIC").charAt(0));
        this.elemClassTypeLabel.setLabelFor(this.classNameTextField);
        this.elemClassTypeLabel.setText(resourceBundle.getString("ELEMENT_CLASS_TYPE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.elemClassTypeLabel, gridBagConstraints);
        this.elemClassTypeLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ELEMENT_CLASS_TYPE_DESC"));
        this.classNameTextField.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 10, 0, 2);
        this.add((Component)this.classNameTextField, gridBagConstraints);
        this.classNameTextField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ELEMENT_CLASS_TYPE"));
    }

    public class MethodParamTableModel
    extends AbstractTableModel {
        private MethodInfo method;
        private final String[] columnNames = new String[]{"Name", "Type"};

        public MethodParamTableModel(MethodInfo methodInfo) {
            this.method = methodInfo;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (object == null || ((String)object).trim().length() == 0) {
                return;
            }
            String string = ((String)object).trim();
            try {
                MethodParamValidator.validate(string, this.method, n);
            }
            catch (InvalidParameterNameException invalidParameterNameException) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)invalidParameterNameException.getMessage(), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            MethodParam methodParam = (MethodParam)this.method.getParameters().get(n);
            methodParam.setName(string);
            MethodDetailPanel.this.signatureTextArea.setText(MethodDetailPanel.this.methodInfo.toString());
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            if (this.method.getParameters() == null) {
                return 0;
            }
            return this.method.getParameters().size();
        }

        public Object getValueAt(int n, int n2) {
            MethodParam methodParam = (MethodParam)this.method.getParameters().get(n);
            if (n2 == 0) {
                return methodParam.getName();
            }
            return methodParam.getType();
        }
    }
}

