/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JButton;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbDataModel;
import org.netbeans.modules.visualweb.ejb.datamodel.EjbGroup;
import org.netbeans.modules.visualweb.ejb.ui.AddEjbGroupDialog;
import org.netbeans.modules.visualweb.ejb.ui.ModifyEjbGroupPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class ModifyEjbGroupDialog
implements ActionListener {
    private DialogDescriptor dialogDescriptor;
    private Dialog dialog;
    private ModifyEjbGroupPanel grpPanel;
    private JButton okButton;
    private JButton cancelButton;
    private EjbGroup ejbGroup;
    private EjbGroup origCopy;

    public ModifyEjbGroupDialog(EjbGroup ejbGroup) {
        this.origCopy = ejbGroup;
        this.ejbGroup = (EjbGroup)ejbGroup.clone();
        this.grpPanel = new ModifyEjbGroupPanel(ejbGroup);
        this.dialogDescriptor = new DialogDescriptor((Object)this.grpPanel, NbBundle.getMessage(AddEjbGroupDialog.class, (String)"MODIFY_EJB_GROUP"), true, (ActionListener)this);
        this.okButton = new JButton(NbBundle.getMessage(ModifyEjbGroupDialog.class, (String)"OK"));
        this.okButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("OK"));
        this.cancelButton = new JButton(NbBundle.getMessage(ModifyEjbGroupDialog.class, (String)"CANCEL_BUTTON_LABEL"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/ejb/ui/Bundle").getString("CANCEL_BUTTON_DESC"));
        this.dialogDescriptor.setOptions(new Object[]{this.okButton, this.cancelButton});
        this.dialogDescriptor.setClosingOptions(new Object[]{this.cancelButton});
        this.dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        this.dialog.setResizable(true);
        this.dialog.pack();
    }

    public void showDialog() {
        this.dialog.setVisible(true);
    }

    public void enableAddButton(boolean bl) {
        this.okButton.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            StringBuffer stringBuffer = new StringBuffer();
            if (!this.grpPanel.validateData(stringBuffer)) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)stringBuffer.toString(), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            this.ejbGroup.setName(this.grpPanel.getGroupName());
            this.ejbGroup.setServerHost(this.grpPanel.getServerHost());
            this.ejbGroup.setIIOPPort(Integer.parseInt(this.grpPanel.getIIOPPort()));
            if (this.checkClientJarInfo(this.ejbGroup)) {
                EjbDataModel.getInstance().modifyEjbGroup(this.origCopy, this.ejbGroup);
                this.dialog.dispose();
            }
        }
    }

    private boolean checkClientJarInfo(EjbGroup ejbGroup) {
        NotifyDescriptor.Confirmation confirmation;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : ejbGroup.getClientJarFileNames()) {
            object = EjbDataModel.getInstance().findEjbGroupsForJar(string);
            confirmation = object.iterator();
            while (confirmation.hasNext()) {
                EjbGroup ejbGroup2 = (EjbGroup)confirmation.next();
                if (ejbGroup2 == null || ejbGroup2.getServerHost().equals(ejbGroup.getServerHost()) && ejbGroup2.getIIOPPort() == ejbGroup.getIIOPPort() || arrayList.contains(ejbGroup2.getName()) || ejbGroup2.getName().equals(ejbGroup.getName())) continue;
                arrayList.add(ejbGroup2.getName());
            }
        }
        if (arrayList.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            object = arrayList.iterator();
            while (object.hasNext()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append((String)object.next());
            }
            object = NbBundle.getMessage(ModifyEjbGroupDialog.class, (String)"MISMATCH_INFO_JAR_Q", (Object)stringBuffer.toString());
            confirmation = new NotifyDescriptor.Confirmation(object, 2);
            return DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.OK_OPTION;
        }
        return true;
    }
}

