/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.php.dbgp.SessionProgress;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class SessionId {
    private static final String PREFIX = "netbeans-xdebug";
    private static final String SLASH = "/";
    private static final String BACK_SLASH = "\\";
    private static final Logger LOGGER = Logger.getLogger(SessionId.class.getName());
    private static final String SOURCES_TYPE_PHP = "PHPSOURCE";
    private String myId = "netbeans-xdebug";
    private static int mySessionsCount = 1;
    private String myFileUri;
    private final FileObject myFileObject;
    private FileObject myLocalBase;
    private String myRemoteBase;
    private String myRemoteSeparator;
    private FileObject myDebugFile;

    public SessionId(FileObject fileObject) {
        ++mySessionsCount;
        this.myFileObject = fileObject;
        this.myDebugFile = fileObject;
    }

    public String getId() {
        return this.myId;
    }

    public FileObject getSessionFileObject() {
        return this.myFileObject;
    }

    public Project getProject() {
        return FileOwnerQuery.getOwner((FileObject)this.myFileObject);
    }

    public String getSessionPrefix() {
        return PREFIX;
    }

    public synchronized void setFileUri(String string) {
        if (this.myFileUri == null) {
            this.myFileUri = string;
            this.computeBases();
        }
        this.notifyAll();
        SessionProgress sessionProgress = SessionProgress.forSessionId(this);
        if (sessionProgress != null) {
            sessionProgress.notifyConnectionFinished();
        }
    }

    public synchronized String waitServerFile(boolean bl) {
        String string = this.getFileUri();
        if (string != null) {
            return string;
        }
        if (!bl) {
            return null;
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            return this.getFileUri();
        }
        return this.getFileUri();
    }

    public String getFileUriByLocal(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        return this.getFileUriByLocal(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file)));
    }

    public String getFileUriByLocal(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        if (fileObject.equals(this.getDebugFile())) {
            return this.getFileUri();
        }
        if (this.myLocalBase == null || this.myRemoteBase == null) {
            return null;
        }
        String string = FileUtil.getRelativePath((FileObject)this.myLocalBase, (FileObject)fileObject);
        if (string == null) {
            LOGGER.info("relative path: " + this.myLocalBase.getPath() + "  " + (fileObject != null ? fileObject.getPath() : "null"));
            return null;
        }
        string = string.replace(File.separator, this.myRemoteSeparator);
        return this.myRemoteBase + string;
    }

    public DataObject getDataObjectByRemote(String string) {
        try {
            FileObject fileObject = this.getFileObjectByRemote(string);
            if (fileObject == null) {
                return null;
            }
            return DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
    }

    public FileObject getFileObjectByRemote(String string) {
        Object object;
        FileObject fileObject = null;
        if (string != null) {
            if (string.equals(this.getFileUri())) {
                fileObject = this.getDebugFile();
            } else if (this.myRemoteBase != null && this.myLocalBase != null && string.startsWith(this.myRemoteBase)) {
                object = string.substring(this.myRemoteBase.length());
                object = ((String)object).replace(this.myRemoteSeparator, File.separator);
                fileObject = this.myLocalBase.getFileObject((String)object);
            }
        }
        if (fileObject == null) {
            try {
                FileObject fileObject2;
                object = new URI(string).toURL();
                if ("file".equals(((URL)object).getProtocol()) && (fileObject2 = URLMapper.findFileObject((URL)object)) != null) {
                    return fileObject2;
                }
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
            catch (URISyntaxException uRISyntaxException) {
                Exceptions.printStackTrace((Throwable)uRISyntaxException);
            }
        }
        return fileObject;
    }

    private String getFileUri() {
        return this.myFileUri;
    }

    private void computeBases() {
        FileObject fileObject;
        int n;
        int n2 = this.getFileUri().lastIndexOf(SLASH);
        if (n2 != -1) {
            n = n2;
            this.myRemoteSeparator = SLASH;
        } else if (this.getFileUri().lastIndexOf(BACK_SLASH) != -1) {
            n = this.getFileUri().lastIndexOf(BACK_SLASH);
            this.myRemoteSeparator = BACK_SLASH;
        } else {
            assert (false);
            return;
        }
        if (n == this.getFileUri().length() - 1) {
            assert (false);
            return;
        }
        String string = this.getFileUri().substring(n + 1);
        String string2 = this.getFileUri().substring(0, n);
        if (this.getSessionFileObject().isFolder()) {
            fileObject = this.getSessionFileObject();
            this.myDebugFile = this.getSessionFileObject().getFileObject(string);
        } else {
            String string3 = this.getSessionFileObject().getNameExt();
            if (!string3.equals(string)) {
                assert (false);
                return;
            }
            fileObject = this.getSessionFileObject().getParent();
        }
        this.setupBases(fileObject, string2, string);
    }

    private void setupBases(FileObject fileObject, String string, String string2) {
        FileObject fileObject2;
        Project project = this.getProject();
        FileObject fileObject3 = fileObject2 = project != null ? project.getProjectDirectory() : null;
        if (fileObject2 == null) {
            assert ("On".equals(System.getProperty("TestRun", "Off")));
            this.setRemoteBase(string);
            this.myLocalBase = fileObject;
            this.myDebugFile = this.myLocalBase.getFileObject(string2);
            return;
        }
        if (fileObject.equals(fileObject2)) {
            this.setRemoteBase(string);
            this.myLocalBase = this.getSourceRoot();
            if (this.myDebugFile == null) {
                this.myDebugFile = this.getSourceRoot().getFileObject(string2);
            }
            return;
        }
        if (fileObject.equals(this.getSourceRoot())) {
            this.setRemoteBase(string);
            this.myLocalBase = fileObject;
            return;
        }
        int n = string.lastIndexOf(this.myRemoteSeparator);
        if (n == -1) {
            this.setRemoteBase("");
            this.myLocalBase = fileObject;
            return;
        }
        assert (n + 1 < string.length());
        String string3 = string.substring(n + 1);
        String string4 = fileObject.getNameExt();
        this.setupBases(fileObject.getParent(), string.substring(0, n), string2);
    }

    private void setRemoteBase(String string) {
        this.myRemoteBase = string.endsWith(this.myRemoteSeparator) ? string : string + this.myRemoteSeparator;
    }

    private FileObject getDebugFile() {
        return this.myDebugFile;
    }

    private FileObject getSourceRoot() {
        FileObject[] fileObjectArray = SessionId.getSourceObjects(this.getProject());
        return fileObjectArray != null && fileObjectArray.length > 0 ? fileObjectArray[0] : null;
    }

    public static SourceGroup[] getSourceGroups(Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups(SOURCES_TYPE_PHP);
        return sourceGroupArray;
    }

    public static FileObject[] getSourceObjects(Project project) {
        SourceGroup[] sourceGroupArray = SessionId.getSourceGroups(project);
        FileObject[] fileObjectArray = new FileObject[sourceGroupArray.length];
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            fileObjectArray[i] = sourceGroupArray[i].getRootFolder();
        }
        return fileObjectArray;
    }
}

