/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.annotations;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.StartActionProviderImpl;
import org.netbeans.modules.php.dbgp.UnsufficientValueException;
import org.netbeans.modules.php.dbgp.breakpoints.Utils;
import org.netbeans.modules.php.dbgp.packets.EvalCommand;
import org.netbeans.modules.php.dbgp.packets.Property;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;

public class ToolTipAnnotation
extends Annotation
implements PropertyChangeListener {
    private static final String RIGHT_BRACKET = " ]";
    private static final String COMMA = ", ";
    private static final String LEFT_BRACKET = "[ ";

    public String getAnnotationType() {
        return null;
    }

    public String getShortDescription() {
        final Line.Part part = (Line.Part)this.getAttachedAnnotatable();
        if (part != null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    ToolTipAnnotation.this.evaluate(part);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof EvalCommand) {
            Property property = (Property)propertyChangeEvent.getNewValue();
            this.firePropertyChange("shortDescription", null, this.getStringValue(property));
        }
    }

    private String getStringValue(Property property) {
        if (property == null) {
            return null;
        }
        String string = null;
        try {
            string = property.getStringValue();
        }
        catch (UnsufficientValueException unsufficientValueException) {
            return null;
        }
        if (string != null) {
            return string.trim().length() == 0 ? null : string;
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder(LEFT_BRACKET);
        for (Property property2 : property.getChildren()) {
            if (bl) {
                stringBuilder.append(COMMA);
            }
            stringBuilder.append(this.getStringValue(property2));
            bl = true;
        }
        stringBuilder.append(RIGHT_BRACKET);
        return stringBuilder.toString();
    }

    private void evaluate(Line.Part part) {
        Line line = part.getLine();
        if (line == null) {
            return;
        }
        DataObject dataObject = DataEditorSupport.findDataObject((Line)line);
        FileObject fileObject = dataObject.getPrimaryFile();
        if (!this.isPhpDataObject(dataObject)) {
            return;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        StyledDocument styledDocument = editorCookie.getDocument();
        int n = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)part.getLine().getLineNumber()) + part.getColumn();
        JEditorPane jEditorPane = EditorContextDispatcher.getDefault().getCurrentEditor();
        String string = this.getSelectedText(jEditorPane, n);
        if (string != null) {
            this.sendEvalCommand(string);
        } else {
            String string2;
            String string3 = string2 = jEditorPane != null ? ToolTipAnnotation.getIdentifier(styledDocument, jEditorPane, n) : null;
            if (string2 != null && ToolTipAnnotation.isDollarMark(string2.charAt(0))) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        ToolTipAnnotation.this.sendEvalCommand(string2);
                    }
                };
                RequestProcessor.getDefault().post(runnable);
            }
        }
    }

    private static String getIdentifier(StyledDocument styledDocument, JEditorPane jEditorPane, int n) {
        String string = null;
        if (jEditorPane.getSelectionStart() <= n && n <= jEditorPane.getSelectionEnd()) {
            string = jEditorPane.getSelectedText();
        }
        if (string != null) {
            return string;
        }
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        int n3 = NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n);
        Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument).getElement(n2);
        try {
            if (element == null) {
                return null;
            }
            int n4 = element.getStartOffset();
            int n5 = element.getEndOffset() - n4;
            if (n3 + 1 >= n5) {
                return null;
            }
            string = styledDocument.getText(n4, n5);
            return ToolTipAnnotation.getExpressionToEvaluate(string, n3);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    static String getExpressionToEvaluate(String string, int n) {
        int n2;
        int n3;
        for (n3 = n; n3 > 0 && (ToolTipAnnotation.isPHPIdentifier(string.charAt(n3 - 1)) || string.charAt(n3 - 1) == '.'); --n3) {
        }
        for (n2 = n; n2 < string.length() && Character.isJavaIdentifierPart(string.charAt(n2)); ++n2) {
        }
        if (n3 == n2) {
            return null;
        }
        return string.substring(n3, n2);
    }

    static boolean isPHPIdentifier(char c) {
        return ToolTipAnnotation.isDollarMark(c) || Character.isJavaIdentifierPart(c);
    }

    private static boolean isDollarMark(char c) {
        return c == '$';
    }

    private boolean isPhpDataObject(DataObject dataObject) {
        return Utils.isPhpFile(dataObject.getPrimaryFile());
    }

    private void sendEvalCommand(String string) {
        DebugSession debugSession = this.getSession();
        if (debugSession == null) {
            return;
        }
        EvalCommand evalCommand = new EvalCommand(debugSession.getTransactionId());
        evalCommand.setData(string);
        evalCommand.addPropertyChangeListener(this);
        debugSession.sendCommandLater(evalCommand);
    }

    private String getSelectedText(JEditorPane jEditorPane, int n) {
        if (jEditorPane != null && jEditorPane.getSelectionStart() <= n && n <= jEditorPane.getSelectionEnd()) {
            return jEditorPane.getSelectedText();
        }
        return null;
    }

    private DebugSession getSession() {
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            return null;
        }
        SessionId sessionId = (SessionId)debuggerEngine.lookupFirst(null, SessionId.class);
        if (sessionId == null) {
            return null;
        }
        DebugSession debugSession = StartActionProviderImpl.getInstance().getCurrentSession(sessionId);
        return debugSession;
    }
}

