/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.php.dbgp.breakpoints.AbstractBreakpoint;

public class PersistenceManager
extends DebuggerManagerAdapter {
    public static final Logger LOGGER = Logger.getLogger(PersistenceManager.class.getName());
    private static final String DEBUGGER = "debugger";
    private static final String PHP_DBGP = "PHP-DBGP";

    public Breakpoint[] initBreakpoints() {
        Properties properties = Properties.getDefault().getProperties(DEBUGGER).getProperties("breakpoints");
        Breakpoint[] breakpointArray = (Breakpoint[])properties.getArray(PHP_DBGP, (Object[])new Breakpoint[0]);
        ArrayList<Breakpoint> arrayList = new ArrayList<Breakpoint>();
        for (Breakpoint breakpoint : breakpointArray) {
            if (breakpoint != null) {
                breakpoint.addPropertyChangeListener((PropertyChangeListener)((Object)this));
                arrayList.add(breakpoint);
                continue;
            }
            LOGGER.warning("null stored in the array obtained from \"PHP-DBGP\" property");
        }
        return arrayList.toArray(new Breakpoint[arrayList.size()]);
    }

    public String[] getProperties() {
        return new String[]{"breakpointsInit", "breakpoints"};
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        Properties properties = Properties.getDefault().getProperties(DEBUGGER).getProperties("breakpoints");
        properties.setArray(PHP_DBGP, (Object[])this.getBreakpoints());
        breakpoint.addPropertyChangeListener((PropertyChangeListener)((Object)this));
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        Properties properties = Properties.getDefault().getProperties(DEBUGGER).getProperties("breakpoints");
        properties.setArray(PHP_DBGP, (Object[])this.getBreakpoints());
        breakpoint.removePropertyChangeListener((PropertyChangeListener)((Object)this));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof Breakpoint) {
            Properties.getDefault().getProperties(DEBUGGER).getProperties("breakpoints").setArray(PHP_DBGP, (Object[])this.getBreakpoints());
        }
    }

    private Breakpoint[] getBreakpoints() {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        ArrayList<Breakpoint> arrayList = new ArrayList<Breakpoint>();
        for (Breakpoint breakpoint : breakpointArray) {
            if (!(breakpoint instanceof AbstractBreakpoint)) continue;
            arrayList.add(breakpoint);
        }
        return arrayList.toArray(new Breakpoint[arrayList.size()]);
    }
}

