/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.StartActionProviderImpl;
import org.netbeans.modules.php.dbgp.actions.AbstractActionProvider;
import org.netbeans.modules.php.dbgp.annotations.CurrentLineAnnotation;
import org.netbeans.modules.php.dbgp.annotations.DebuggerAnnotation;
import org.netbeans.modules.php.dbgp.breakpoints.BreakpointModel;
import org.netbeans.modules.php.dbgp.models.CallStackModel;
import org.netbeans.modules.php.dbgp.models.ThreadsModel;
import org.netbeans.modules.php.dbgp.models.VariablesModel;
import org.netbeans.modules.php.dbgp.models.WatchesModel;
import org.netbeans.spi.debugger.ActionsProvider;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.openide.text.Annotatable;
import org.openide.text.Line;

public abstract class AbstractIDEBridge {
    public static final String LOCALS_VIEW_NAME = "LocalsView";
    public static final String CALLSTACK_VIEW_NAME = "CallStackView";
    public static final String WATCHES_VIEW_NAME = "WatchesView";
    public static final String BREAKPOINTS_VIEW_NAME = "BreakpointsView";
    public static final String THREADS_VIEW_NAME = "ThreadsView";
    private Map<String, List<DebuggerAnnotation>> myAnnotations = new HashMap<String, List<DebuggerAnnotation>>();
    private AtomicBoolean isSuspended = new AtomicBoolean(false);

    protected AbstractIDEBridge() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideAnnotations() {
        ArrayList<List<DebuggerAnnotation>> arrayList;
        Map<String, List<DebuggerAnnotation>> map = this.myAnnotations;
        synchronized (map) {
            arrayList = new ArrayList<List<DebuggerAnnotation>>(this.myAnnotations.values());
            this.myAnnotations.clear();
        }
        for (List list : arrayList) {
            for (DebuggerAnnotation debuggerAnnotation : list) {
                debuggerAnnotation.detach();
            }
        }
    }

    public void showCurrentDebuggerLine(final Line line) {
        if (line != null) {
            this.annotate(new CurrentLineAnnotation((Annotatable)line));
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    line.show(2);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(DebuggerAnnotation debuggerAnnotation) {
        String string = debuggerAnnotation.getAnnotationType();
        Map<String, List<DebuggerAnnotation>> map = this.myAnnotations;
        synchronized (map) {
            List<DebuggerAnnotation> list = this.myAnnotations.get(string);
            if (list == null) {
                list = new LinkedList<DebuggerAnnotation>();
                this.myAnnotations.put(string, list);
            }
            list.add(debuggerAnnotation);
        }
    }

    public VariablesModel getVariablesModel() {
        if (this.getEngine() == null) {
            return null;
        }
        return (VariablesModel)this.getEngine().lookupFirst(LOCALS_VIEW_NAME, TreeModel.class);
    }

    public CallStackModel getCallStackModel() {
        if (this.getEngine() == null) {
            return null;
        }
        return (CallStackModel)this.getEngine().lookupFirst(CALLSTACK_VIEW_NAME, TreeModel.class);
    }

    public WatchesModel getWatchesModel() {
        return (WatchesModel)this.getEngine().lookupFirst(WATCHES_VIEW_NAME, TreeModel.class);
    }

    public BreakpointModel getBreakpointModel() {
        for (TableModel tableModel : DebuggerManager.getDebuggerManager().lookup(BREAKPOINTS_VIEW_NAME, TableModel.class)) {
            if (!(tableModel instanceof BreakpointModel)) continue;
            return (BreakpointModel)tableModel;
        }
        return null;
    }

    public ThreadsModel getThreadsModel() {
        return (ThreadsModel)this.getEngine().lookupFirst(THREADS_VIEW_NAME, TreeModel.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuspended(boolean bl) {
        DebugSession debugSession;
        Object object;
        this.isSuspended.set(bl);
        Object object2 = StartActionProviderImpl.getInstance();
        synchronized (object2) {
            object = this.getDebugSession().getSessionId();
            if (object == null) {
                return;
            }
            debugSession = StartActionProviderImpl.getInstance().getCurrentSession((SessionId)object);
            if (debugSession != null && !debugSession.equals(this.getDebugSession())) {
                return;
            }
        }
        object2 = this.getEngine().lookup(null, ActionsProvider.class);
        object = object2.iterator();
        while (object.hasNext()) {
            debugSession = object.next();
            assert (debugSession instanceof AbstractActionProvider);
            AbstractActionProvider abstractActionProvider = (AbstractActionProvider)((Object)debugSession);
            Set set = abstractActionProvider.getActions();
            for (Object e : set) {
                if (e != ActionsManager.ACTION_CONTINUE && e != ActionsManager.ACTION_STEP_INTO && e != ActionsManager.ACTION_STEP_OVER && e != ActionsManager.ACTION_STEP_OUT && e != ActionsManager.ACTION_RUN_TO_CURSOR) continue;
                abstractActionProvider.setEnabled(bl);
            }
        }
    }

    public boolean isSuspended() {
        return this.isSuspended.get();
    }

    protected abstract DebuggerEngine getEngine();

    protected abstract DebugSession getDebugSession();
}

