/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.models;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.StartActionProviderImpl;
import org.netbeans.modules.php.dbgp.breakpoints.Utils;
import org.netbeans.modules.php.dbgp.models.ViewModelSupport;
import org.netbeans.modules.php.dbgp.packets.ContextNamesCommand;
import org.netbeans.modules.php.dbgp.packets.Stack;
import org.netbeans.modules.php.dbgp.packets.StackGetResponse;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.Line;
import org.openide.util.Mutex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallStackModel
extends ViewModelSupport
implements TreeModel,
NodeModel,
NodeActionsProvider,
TableModel {
    public static final String CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/NonCurrentFrame";
    public static final String CURRENT_CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/CurrentFrame";
    private final ContextProvider myContextProvider;
    private AtomicReference<List<Stack>> myStack;
    private AtomicReference<Stack> myCurrentStack;

    public CallStackModel(ContextProvider contextProvider) {
        this.myContextProvider = contextProvider;
        this.myStack = new AtomicReference();
        this.myCurrentStack = new AtomicReference();
    }

    @Override
    public void clearModel() {
        this.setCallStack(new ArrayList<Stack>());
    }

    public Object getRoot() {
        return "Root";
    }

    public void setCallStack(List<Stack> list) {
        ArrayList<Stack> arrayList = new ArrayList<Stack>(list);
        this.myStack.set(arrayList);
        if (arrayList.size() > 0) {
            this.myCurrentStack.set((Stack)arrayList.get(0));
        }
        this.refresh();
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            List<Stack> list = this.myStack.get();
            if (list == null) {
                return new Object[0];
            }
            if (n >= list.size()) {
                return new Object[0];
            }
            int n3 = Math.min(list.size(), n2);
            List<Stack> list2 = list.subList(n, n3);
            return list2.toArray();
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return false;
        }
        if (object instanceof Stack) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object == "Root") {
            List<Stack> list = this.myStack.get();
            if (list == null) {
                return 0;
            }
            return list.size();
        }
        throw new UnknownTypeException(object);
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object instanceof Stack) {
            Stack stack = (Stack)object;
            String string = stack.getCurrentCommandName();
            if (string == null) {
                return this.getFile(stack) + ":" + stack.getLine();
            }
            return this.getFile(stack) + "." + string + ":" + stack.getLine();
        }
        if (object == "Root") {
            return "Root".toString();
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object instanceof Stack) {
            Stack stack = this.myCurrentStack.get();
            if (stack == object) {
                return CURRENT_CALL_STACK;
            }
            return CALL_STACK;
        }
        if (object == "Root") {
            return null;
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return null;
        }
        if (object instanceof Stack) {
            return null;
        }
        throw new UnknownTypeException(object);
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object instanceof Stack) {
            Stack stack = (Stack)object;
            this.updateDependentViews(stack);
            final Line line = Utils.getLine(stack.getLine(), stack.getFileName(), this.getSessionId());
            if (line != null) {
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        line.show(2);
                    }
                });
            }
        }
        throw new UnknownTypeException(object);
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        return new Action[0];
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (object == "Root") {
            return null;
        }
        if (object instanceof Stack) {
            if (string == "CallStackFrameLocation") {
                Stack stack = (Stack)object;
                return this.getFile(stack);
            }
            return "?! unknown column";
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if (object == "Root") {
            return true;
        }
        if (object instanceof Stack) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        throw new UnknownTypeException(object);
    }

    private ContextProvider getContextProvider() {
        return this.myContextProvider;
    }

    private SessionId getSessionId() {
        return (SessionId)this.getContextProvider().lookupFirst(null, SessionId.class);
    }

    private String getFile(Stack stack) {
        Object object;
        String string = stack.getFileName();
        FileObject fileObject = this.getSessionId().getFileObjectByRemote(string);
        if (fileObject == null) {
            return string;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null && (object = FileUtil.getRelativePath((FileObject)project.getProjectDirectory(), (FileObject)fileObject)) != null) {
            return object;
        }
        object = FileUtil.toFile((FileObject)fileObject);
        return object != null ? ((File)object).getAbsolutePath() : string;
    }

    private DebugSession getSession() {
        return StartActionProviderImpl.getInstance().getCurrentSession(this.getSessionId());
    }

    private void updateDependentViews(Stack stack) {
        this.myCurrentStack.set(stack);
        DebugSession debugSession = this.getSession();
        if (debugSession == null) {
            return;
        }
        int n = stack.getLevel();
        ContextNamesCommand contextNamesCommand = new ContextNamesCommand(debugSession.getTransactionId());
        contextNamesCommand.setDepth(n);
        debugSession.sendCommandLater(contextNamesCommand);
        StackGetResponse.updateWatchView(debugSession);
        this.refresh();
    }
}

