/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.packets.DbgpCommand;
import org.netbeans.modules.php.dbgp.packets.InitMessage;
import org.netbeans.modules.php.dbgp.packets.MessageBuilder;
import org.openide.util.NbBundle;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DbgpMessage {
    private static final String ERR_PACKET_ERROR = "ERR_PacketError";
    private static final String INIT = "init";
    private static final String RESPONSE = "response";
    private static final String STREAM = "stream";
    static final String ISO_CHARSET = "ISO-8859-1";
    private static final int MAX_PACKET_SIZE = 1024;
    protected static final String HTML_APOS = "&apos;";
    protected static final String HTML_QUOTE = "&quot;";
    protected static final String HTML_AMP = "&amp";
    protected static final String HTML_LT = "&lt";
    protected static final String HTML_GT = "&gt";
    protected static final Map<String, Character> ENTITIES = new HashMap<String, Character>();
    private Node myNode;
    private static DocumentBuilder BUILDER;
    private static AtomicInteger myMaxDataSize;

    DbgpMessage(Node node) {
        this.myNode = node;
    }

    public static DbgpMessage create(InputStream inputStream) {
        try {
            int n = DbgpMessage.getDataSize(inputStream);
            if (n < 0) {
                DbgpMessage.notifyPacketError(null);
                Logger.getLogger(DbgpMessage.class.getName()).log(Level.FINE, "Got " + n + " as data size");
                return null;
            }
            byte[] byArray = DbgpMessage.getContent(inputStream, n);
            Node node = DbgpMessage.getNode(byArray);
            DbgpMessage.logDebugInfo(byArray);
            return DbgpMessage.create(node);
        }
        catch (IOException iOException) {
            DbgpMessage.log(iOException);
            return null;
        }
    }

    public abstract void process(DebugSession var1, DbgpCommand var2);

    public static int getMaxDataSize() {
        return myMaxDataSize.get();
    }

    public static void setMaxDataSize(int n) {
        int n2 = myMaxDataSize.get();
        if (n2 < n) {
            myMaxDataSize.compareAndSet(n2, n);
        }
    }

    public static DbgpMessage create(Node node) {
        if (node == null) {
            return null;
        }
        String string = node.getNodeName();
        if (INIT.equals(string)) {
            return new InitMessage(node);
        }
        if (STREAM.equals(string)) {
            return MessageBuilder.createStream(node);
        }
        if (RESPONSE.equals(string)) {
            return MessageBuilder.createResponse(node);
        }
        return null;
    }

    protected static void log(IOException iOException) {
        Logger.getLogger(DbgpMessage.class.getName()).log(Level.SEVERE, null, iOException);
    }

    protected static String getNodeValue(Node node) {
        NodeList nodeList = node.getChildNodes();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2 instanceof Text) {
                stringBuilder.append(node2.getNodeValue());
                continue;
            }
            if (!(node2 instanceof CDATASection)) continue;
            stringBuilder.append(node2.getNodeValue());
        }
        return DbgpMessage.replaceHtmlEntities(stringBuilder.toString());
    }

    protected static String getAttribute(Node node, String string) {
        Node node2 = node.getAttributes().getNamedItem(string);
        return node2 == null ? null : DbgpMessage.replaceHtmlEntities(node2.getNodeValue());
    }

    protected static boolean getBoolean(Node node, String string) {
        String string2 = DbgpMessage.getAttribute(node, string);
        if (string2 == null) {
            return false;
        }
        try {
            return Integer.parseInt(string2) > 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    protected static Node getChild(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!string.equals(node2.getNodeName())) continue;
            return node2;
        }
        return null;
    }

    protected static List<Node> getChildren(Node node, String string) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!string.equals(node2.getNodeName())) continue;
            linkedList.add(node2);
        }
        return linkedList;
    }

    protected Node getNode() {
        return this.myNode;
    }

    private static void log(ParserConfigurationException parserConfigurationException) {
        Logger.getLogger(DbgpMessage.class.getName()).log(Level.SEVERE, null, parserConfigurationException);
    }

    private static void logDebugInfo(byte[] byArray) {
        block2: {
            try {
                Logger.getLogger(DbgpMessage.class.getName()).log(Level.FINE, new String(byArray, ISO_CHARSET));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    private static void notifyPacketError(Exception exception) {
        Exception exception2 = exception;
        if (exception2 == null) {
            exception2 = new Exception(NbBundle.getMessage(DbgpMessage.class, (String)ERR_PACKET_ERROR));
        }
        Logger.getLogger(DbgpMessage.class.getName()).log(Level.SEVERE, null, exception);
    }

    private static byte[] getContent(InputStream inputStream, int n) throws IOException {
        int n2;
        int n3;
        int n4;
        byte[] byArray = new byte[n];
        for (n4 = 0; n4 < n; n4 += inputStream.read(byArray, n4, n3)) {
            n2 = n - n4;
            n3 = n2 < DbgpMessage.getMaxDataSize() ? n2 : DbgpMessage.getMaxDataSize();
        }
        if (n4 != n) {
            DbgpMessage.notifyPacketError(null);
            Logger.getLogger(DbgpMessage.class.getName()).log(Level.FINE, "Red " + n4 + " bytes from socket input stream," + " but expected " + n + " bytes");
            return null;
        }
        n2 = inputStream.read();
        assert (n2 == 0);
        return byArray;
    }

    private static int getDataSize(InputStream inputStream) throws IOException {
        int n;
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        while ((n = inputStream.read()) > 0) {
            linkedList.add(n);
        }
        byte[] byArray = new byte[linkedList.size()];
        int n2 = 0;
        for (Integer n3 : linkedList) {
            byte by = n3.byteValue();
            byArray[n2++] = by;
        }
        String string = new String(byArray, ISO_CHARSET);
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            assert (false);
            return -1;
        }
    }

    private static Node getNode(byte[] byArray) throws IOException {
        if (BUILDER == null || byArray == null) {
            return null;
        }
        try {
            Document document = BUILDER.parse(new ByteArrayInputStream(byArray));
            return document.getDocumentElement();
        }
        catch (SAXException sAXException) {
            DbgpMessage.notifyPacketError(sAXException);
            return null;
        }
    }

    private static String replaceHtmlEntities(String string) {
        if (string.indexOf("&") == -1) {
            return string;
        }
        for (Map.Entry<String, Character> entry : ENTITIES.entrySet()) {
            String string2 = entry.getKey();
            Character c = entry.getValue();
            string = string.replace(string2, c + "");
        }
        return string;
    }

    static {
        ENTITIES.put(HTML_APOS, Character.valueOf('\''));
        ENTITIES.put(HTML_QUOTE, Character.valueOf('\"'));
        ENTITIES.put(HTML_AMP, Character.valueOf('&'));
        ENTITIES.put(HTML_LT, Character.valueOf('<'));
        ENTITIES.put(HTML_GT, Character.valueOf('>'));
        myMaxDataSize = new AtomicInteger(1024);
        try {
            BUILDER = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            BUILDER.setEntityResolver(new StubResolver());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            DbgpMessage.log(parserConfigurationException);
        }
    }

    private static class StubResolver
    implements EntityResolver {
        private StubResolver() {
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            return null;
        }
    }
}

