/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xsl.wizard;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class XSLWizardIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 1L;
    private int index;
    private final Set<ChangeListener> changeListeners = new HashSet<ChangeListener>();
    protected transient WizardDescriptor.Panel[] panels;
    protected String encoding;

    protected WizardDescriptor.Panel[] createPanels(Project project, TemplateWizard templateWizard) {
        DataFolder dataFolder = null;
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        if (sourceGroupArray == null || sourceGroupArray.length == 0) {
            sourceGroupArray = sources.getSourceGroups("generic");
        }
        try {
            dataFolder = templateWizard.getTargetFolder();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (dataFolder != null) {
            templateWizard.setTargetFolder(dataFolder);
            WizardDescriptor.Panel panel = Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroupArray);
            return new WizardDescriptor.Panel[]{panel};
        }
        if (sourceGroupArray != null && sourceGroupArray.length != 0) {
            dataFolder = DataFolder.findFolder((FileObject)sourceGroupArray[0].getRootFolder());
            templateWizard.setTargetFolder(dataFolder);
        }
        WizardDescriptor.Panel panel = Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroupArray);
        return new WizardDescriptor.Panel[]{panel};
    }

    public void initialize(TemplateWizard templateWizard) {
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)templateWizard);
        this.panels = this.createPanels(project, templateWizard);
        Object object = templateWizard.getProperty("WizardPanel_contentData");
        String[] stringArray = null;
        if (object instanceof String[]) {
            stringArray = (String[])object;
        }
        String[] stringArray2 = this.createSteps(stringArray, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray2[i] == null) {
                stringArray2[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jComponent.putClientProperty("WizardPanel_contentData", stringArray2);
        }
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.panels = null;
    }

    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        EditCookie editCookie;
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)templateWizard);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        FileObject fileObject2 = Templates.getTemplate((WizardDescriptor)templateWizard);
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, Templates.getTargetName((WizardDescriptor)templateWizard));
        if (dataObject2 == null) {
            return Collections.emptySet();
        }
        this.encoding = EncodingUtil.getProjectEncoding((FileObject)dataFolder.getPrimaryFile());
        if (!EncodingUtil.isValidEncoding((String)this.encoding)) {
            this.encoding = "UTF-8";
        }
        if ((editCookie = (EditCookie)dataObject2.getCookie(EditCookie.class)) != null) {
            EditorCookie editorCookie = (EditorCookie)dataObject2.getCookie(EditorCookie.class);
            StyledDocument styledDocument = editorCookie.openDocument();
            this.fixEncoding(styledDocument, this.encoding);
            SaveCookie saveCookie = (SaveCookie)dataObject2.getCookie(SaveCookie.class);
            if (saveCookie != null) {
                saveCookie.save();
            }
        }
        return Collections.singleton(dataObject2.getPrimaryFile());
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    public void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator<ChangeListener> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().stateChanged(changeEvent);
            }
            catch (Exception exception) {}
        }
    }

    public String name() {
        return NbBundle.getMessage(XSLWizardIterator.class, (String)"TITLE_x_of_y", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    private String[] createSteps(String[] stringArray, WizardDescriptor.Panel[] panelArray) {
        int n = 0;
        if (stringArray == null) {
            stringArray = new String[]{};
        } else if (stringArray.length > 0) {
            n = "...".equals(stringArray[stringArray.length - 1]) ? 1 : 0;
        }
        String[] stringArray2 = new String[stringArray.length - n + panelArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - n ? stringArray[i] : panelArray[i - stringArray.length + n].getComponent().getName();
        }
        return stringArray2;
    }

    void replaceInDocument(Document document, String string, String string2) {
        AbstractDocument abstractDocument = (AbstractDocument)document;
        int n = string.length();
        try {
            String string3 = abstractDocument.getText(0, abstractDocument.getLength());
            int n2 = string3.lastIndexOf(string);
            while (n2 >= 0) {
                abstractDocument.replace(n2, n, string2, null);
                string3 = string3.substring(0, n2);
                n2 = string3.lastIndexOf(string);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    void fixEncoding(Document document, String string) {
        if (string == null) {
            string = "UTF-8";
        }
        try {
            document.insertString(19, " encoding=\"" + string + "\"", null);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }
}

