/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.markup;

import com.sun.rave.designtime.markup.MarkupDesignBean;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.xerces.dom.DocumentImpl;
import org.netbeans.modules.visualweb.api.insync.InSyncService;
import org.netbeans.modules.visualweb.designer.html.HtmlTag;
import org.netbeans.modules.visualweb.designer.markup.RaveDocumentBuilderFactory;
import org.netbeans.modules.visualweb.designer.markup.RaveRenderedDocument;
import org.netbeans.modules.visualweb.designer.markup.RaveSourceDocument;
import org.netbeans.modules.visualweb.designer.markup.RaveTableElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class MarkupServiceImpl {
    private static final Map<Node, Boolean> node2jspx = new WeakHashMap<Node, Boolean>(200);
    private static final Map<Element, StyleMap> element2styleMap = new WeakHashMap<Element, StyleMap>(200);
    private static final Map<Element, WeakReference<CSSStylableElement>> element2cssStylableElement = new WeakHashMap<Element, WeakReference<CSSStylableElement>>(200);
    private static final Map<Text, WeakReference<Text>> sourceText2renderedText = new WeakHashMap<Text, WeakReference<Text>>(200);
    private static final Map<Text, WeakReference<Text>> renderedText2sourceText = new WeakHashMap<Text, WeakReference<Text>>(200);
    private static final Map<Element, WeakReference<Element>> sourceElement2renderedElement = new WeakHashMap<Element, WeakReference<Element>>(200);
    private static final Map<Element, WeakReference<Element>> renderedElement2sourceElement = new WeakHashMap<Element, WeakReference<Element>>(200);

    private MarkupServiceImpl() {
    }

    public static DocumentBuilder createRaveSourceDocumentBuilder(boolean bl) throws ParserConfigurationException {
        return RaveDocumentBuilderFactory.newDocumentBuilder(bl, true);
    }

    public static DocumentBuilder createRaveRenderedDocumentBuilder(boolean bl) throws ParserConfigurationException {
        return RaveDocumentBuilderFactory.newDocumentBuilder(bl, false);
    }

    public static void markRendered(Node node, Node node2) {
        Object object;
        Object object2;
        if (node instanceof Element && node.getOwnerDocument() instanceof RaveSourceDocument) {
            object2 = (Element)node;
            object = (Element)node2;
            MarkupServiceImpl.linkToSourceElement((Element)object, (Element)object2);
        } else if (node instanceof Text && node.getOwnerDocument() instanceof RaveSourceDocument) {
            object2 = (Text)node;
            object = (Text)node2;
            MarkupServiceImpl.linkToSourceText((Text)object, (Text)object2);
        }
        object2 = node.getChildNodes();
        object = node2.getChildNodes();
        int n = object2.getLength();
        assert (object.getLength() == n);
        for (int i = 0; i < n; ++i) {
            MarkupServiceImpl.markRendered(object2.item(i), object.item(i));
        }
    }

    public static void markRenderedNodes(Element element, Node node) {
        Element element2 = node instanceof Element && node.getOwnerDocument() instanceof RaveRenderedDocument ? (Element)node : null;
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = n - 1; i >= 0; --i) {
            MarkupServiceImpl.markRenderedNodes(element2, nodeList.item(i));
        }
        if (node != null && node.getOwnerDocument() instanceof RaveRenderedDocument && element2 != null) {
            MarkupDesignBean markupDesignBean;
            MarkupDesignBean markupDesignBean2 = InSyncService.getProvider().getMarkupDesignBeanForElement(element2);
            MarkupDesignBean markupDesignBean3 = markupDesignBean = element == null ? null : InSyncService.getProvider().getMarkupDesignBeanForElement(element);
            if (markupDesignBean2 == markupDesignBean) {
                MarkupServiceImpl.linkToSourceElement(element2, null);
            } else if (markupDesignBean2 != null) {
                Element element3 = markupDesignBean2.getElement();
                if (element3 != null && element3.getOwnerDocument() instanceof RaveSourceDocument) {
                    MarkupServiceImpl.linkToSourceElement(element2, element3);
                } else {
                    MarkupServiceImpl.linkToSourceElement(element2, null);
                }
            }
        }
    }

    public static void markJspxSource(Node node) {
        MarkupServiceImpl.setJspxNode(node, true);
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            MarkupServiceImpl.markJspxSource(nodeList.item(i));
        }
    }

    public static void setInputEncodingForDocument(Document document, String string) {
        if (document instanceof DocumentImpl) {
            ((DocumentImpl)document).setInputEncoding(string);
        }
    }

    public static String getStyleText(Element element) {
        String string = "";
        Node node = element.getFirstChild();
        if (node != null) {
            StringBuffer stringBuffer = new StringBuffer();
            while (node != null) {
                if (node.getNodeType() == 4 || node.getNodeType() == 8 || node.getNodeType() == 3) {
                    stringBuffer.append(node.getNodeValue());
                }
                node = node.getNextSibling();
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static Element getCorrespondingSourceElement(Element element) {
        Element element2;
        if (element == null || !(element.getOwnerDocument() instanceof RaveRenderedDocument)) {
            return element;
        }
        for (Node node = element2 = element; node != null; node = node.getParentNode()) {
            Node node2;
            Element element3;
            if (!(node instanceof Element) || !(node.getOwnerDocument() instanceof RaveRenderedDocument) || (element3 = MarkupServiceImpl.getSourceElement(node2 = node)) == null) continue;
            return element3;
        }
        return MarkupServiceImpl.getSourceElement(element2);
    }

    public static boolean isJspxNode(Node node) {
        Boolean bl = node2jspx.get(node);
        return bl == null ? false : bl;
    }

    public static void setJspxNode(Node node, boolean bl) {
        if (node == null) {
            return;
        }
        node2jspx.put(node, bl);
    }

    public static Node getRenderedNodeForNode(Node node) {
        if (node instanceof Element && node.getOwnerDocument() instanceof RaveSourceDocument) {
            return MarkupServiceImpl.getRenderedElement((Element)node);
        }
        if (node instanceof Text && node.getOwnerDocument() instanceof RaveSourceDocument) {
            return MarkupServiceImpl.getRenderedText((Text)node);
        }
        if (node != null && node.getOwnerDocument() instanceof RaveRenderedDocument) {
            return node;
        }
        return null;
    }

    public static Node getSourceNodeForNode(Node node) {
        if (node instanceof Element && node.getOwnerDocument() instanceof RaveRenderedDocument) {
            return MarkupServiceImpl.getSourceElement((Element)node);
        }
        if (node instanceof Text && node.getOwnerDocument() instanceof RaveRenderedDocument) {
            return MarkupServiceImpl.getSourceText((Text)node);
        }
        if (node != null && node.getOwnerDocument() instanceof RaveSourceDocument) {
            return node;
        }
        return null;
    }

    public static Element getRenderedElementForElement(Element element) {
        if (element != null && element.getOwnerDocument() instanceof RaveSourceDocument) {
            return MarkupServiceImpl.getRenderedElement(element);
        }
        if (element != null && element.getOwnerDocument() instanceof RaveRenderedDocument) {
            return element;
        }
        return null;
    }

    public static void setRenderedElementForElement(Element element, Element element2) {
        if (element != null && element.getOwnerDocument() instanceof RaveSourceDocument) {
            MarkupServiceImpl.linkToRenderedElement(element, element2);
        }
    }

    public static Element getSourceElementForElement(Element element) {
        if (element != null && element.getOwnerDocument() instanceof RaveRenderedDocument) {
            return MarkupServiceImpl.getSourceElement(element);
        }
        if (element != null && element.getOwnerDocument() instanceof RaveSourceDocument) {
            return element;
        }
        return null;
    }

    public static Text getRenderedTextForText(Text text) {
        if (text != null && text.getOwnerDocument() instanceof RaveSourceDocument) {
            return MarkupServiceImpl.getRenderedText(text);
        }
        if (text != null && text.getOwnerDocument() instanceof RaveRenderedDocument) {
            return text;
        }
        return null;
    }

    public static Text getSourceTextForText(Text text) {
        if (text != null && text.getOwnerDocument() instanceof RaveRenderedDocument) {
            return MarkupServiceImpl.getSourceText(text);
        }
        if (text != null && text.getOwnerDocument() instanceof RaveSourceDocument) {
            return text;
        }
        return null;
    }

    public static void setSourceTextForText(Text text, Text text2) {
        if (text != null && text.getOwnerDocument() instanceof RaveRenderedDocument) {
            MarkupServiceImpl.linkToSourceText(text, text2);
        }
    }

    public static Element getTBodyElementForTableElement(Element element) {
        if (element instanceof RaveTableElement) {
            return ((RaveTableElement)((Object)element)).getTbody();
        }
        return null;
    }

    static void setElementStyleMap(Element element, StyleMap styleMap) {
        if (element == null) {
            return;
        }
        element2styleMap.put(element, styleMap);
    }

    static StyleMap getElementStyleMap(Element element) {
        if (element == null) {
            return null;
        }
        return element2styleMap.get(element);
    }

    static void setElementStyleParent(Element element, CSSStylableElement cSSStylableElement) {
        if (element == null) {
            return;
        }
        element2cssStylableElement.put(element, new WeakReference<CSSStylableElement>(cSSStylableElement));
    }

    static CSSStylableElement getElementStyleParent(Element element) {
        if (element == null) {
            return null;
        }
        WeakReference<CSSStylableElement> weakReference = element2cssStylableElement.get(element);
        return weakReference == null ? null : (CSSStylableElement)weakReference.get();
    }

    static boolean isElementPseudoInstanceOf(Element element, String string) {
        if (element == null) {
            return false;
        }
        if (string.equals("first-child")) {
            Node node;
            for (node = element.getPreviousSibling(); node != null && node.getNodeType() != 1; node = node.getPreviousSibling()) {
            }
            return node == null;
        }
        if (string.equals("link")) {
            String string2 = HtmlTag.A.toString();
            for (Node node = element; node != null; node = node.getParentNode()) {
                if (node.getNodeType() != 1 || !node.getNodeName().equals(string2) || !node.hasAttribute("href")) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    static void setRenderedText(Text text, Text text2) {
        if (text == null) {
            return;
        }
        sourceText2renderedText.put(text, new WeakReference<Text>(text2));
    }

    static Text getRenderedText(Text text) {
        if (text == null) {
            return null;
        }
        WeakReference<Text> weakReference = sourceText2renderedText.get(text);
        return weakReference == null ? null : (Text)weakReference.get();
    }

    static void setSourceText(Text text, Text text2) {
        if (text == null) {
            return;
        }
        renderedText2sourceText.put(text, new WeakReference<Text>(text2));
    }

    static Text getSourceText(Text text) {
        if (text == null) {
            return null;
        }
        WeakReference<Text> weakReference = renderedText2sourceText.get(text);
        return weakReference == null ? null : (Text)weakReference.get();
    }

    static void linkToSourceText(Text text, Text text2) {
        MarkupServiceImpl.setSourceText(text, text2);
        MarkupServiceImpl.setRenderedText(text2, text);
    }

    static void setRenderedElement(Element element, Element element2) {
        if (element == null) {
            return;
        }
        sourceElement2renderedElement.put(element, new WeakReference<Element>(element2));
    }

    static Element getRenderedElement(Element element) {
        if (element == null) {
            return null;
        }
        WeakReference<Element> weakReference = sourceElement2renderedElement.get(element);
        return weakReference == null ? null : (Element)weakReference.get();
    }

    static void linkToRenderedElement(Element element, Element element2) {
        MarkupServiceImpl.setRenderedElement(element, element2);
        MarkupServiceImpl.setSourceElement(element2, element);
    }

    static void setSourceElement(Element element, Element element2) {
        if (element == null) {
            return;
        }
        renderedElement2sourceElement.put(element, new WeakReference<Element>(element2));
    }

    static Element getSourceElement(Element element) {
        if (element == null) {
            return null;
        }
        WeakReference<Element> weakReference = renderedElement2sourceElement.get(element);
        return weakReference == null ? null : (Element)weakReference.get();
    }

    static void linkToSourceElement(Element element, Element element2) {
        String string;
        char c;
        MarkupServiceImpl.setSourceElement(element, element2);
        if (element != null && ((c = (string = element.getTagName()).charAt(0)) == 's' && (string.equals(HtmlTag.SCRIPT.name) || string.equals(HtmlTag.STYLE.name)) || c == 'i' && string.equals(HtmlTag.INPUT.name) && element.getAttribute("type").equals("hidden"))) {
            return;
        }
        MarkupServiceImpl.setRenderedElement(element2, element);
    }
}

