/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.markup;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.jaxp.JAXPConstants;
import org.apache.xerces.parsers.DOMParser;
import org.netbeans.modules.visualweb.designer.markup.RaveDomParser;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class RaveDocumentBuilder
extends DocumentBuilder
implements JAXPConstants {
    private EntityResolver er = null;
    private ErrorHandler eh = null;
    private DOMParser domParser = null;

    public RaveDocumentBuilder(DocumentBuilderFactory documentBuilderFactory, Hashtable hashtable, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.domParser = new RaveDomParser(bl);
        this.domParser.setFeature("http://xml.org/sax/features/validation", documentBuilderFactory.isValidating());
        this.domParser.setFeature("http://xml.org/sax/features/namespaces", documentBuilderFactory.isNamespaceAware());
        this.domParser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", !documentBuilderFactory.isIgnoringElementContentWhitespace());
        this.domParser.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", !documentBuilderFactory.isExpandEntityReferences());
        this.domParser.setFeature("http://apache.org/xml/features/include-comments", !documentBuilderFactory.isIgnoringComments());
        this.domParser.setFeature("http://apache.org/xml/features/create-cdata-nodes", !documentBuilderFactory.isCoalescing());
        this.setDocumentBuilderFactoryAttributes(hashtable);
    }

    private void setDocumentBuilderFactoryAttributes(Hashtable hashtable) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            if (v instanceof Boolean) {
                this.domParser.setFeature(string, ((Boolean)v).booleanValue());
                continue;
            }
            if ("http://java.sun.com/xml/jaxp/properties/schemaLanguage".equals(string)) {
                if (!"http://www.w3.org/2001/XMLSchema".equals(v) || !this.isValidating()) continue;
                this.domParser.setFeature("http://apache.org/xml/features/validation/schema", true);
                this.domParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", (Object)"http://www.w3.org/2001/XMLSchema");
                continue;
            }
            if ("http://java.sun.com/xml/jaxp/properties/schemaSource".equals(string)) {
                if (!this.isValidating()) continue;
                String string2 = (String)hashtable.get("http://java.sun.com/xml/jaxp/properties/schemaLanguage");
                if (string2 != null && "http://www.w3.org/2001/XMLSchema".equals(string2)) {
                    this.domParser.setProperty(string, v);
                    continue;
                }
                throw new IllegalArgumentException(DOMMessageFormatter.formatMessage((String)"http://www.w3.org/dom/DOMTR", (String)"jaxp-order-not-supported", (Object[])new Object[]{"http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://java.sun.com/xml/jaxp/properties/schemaSource"}));
            }
            this.domParser.setProperty(string, v);
        }
    }

    public Document newDocument() {
        return new DocumentImpl();
    }

    public DOMImplementation getDOMImplementation() {
        return DOMImplementationImpl.getDOMImplementation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parse(InputSource inputSource) throws SAXException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        boolean bl = false;
        try {
            ClassLoader classLoader2 = this.getClass().getClassLoader();
            if (classLoader != classLoader2) {
                Thread.currentThread().setContextClassLoader(classLoader2);
                bl = true;
            }
            if (inputSource == null) {
                throw new IllegalArgumentException(DOMMessageFormatter.formatMessage((String)"http://www.w3.org/dom/DOMTR", (String)"jaxp-null-input-source", null));
            }
            if (this.er != null) {
                this.domParser.setEntityResolver(this.er);
            }
            if (this.eh != null) {
                this.domParser.setErrorHandler(this.eh);
            }
            this.domParser.parse(inputSource);
            Document document = this.domParser.getDocument();
            return document;
        }
        finally {
            if (bl) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }

    public boolean isNamespaceAware() {
        try {
            return this.domParser.getFeature("http://xml.org/sax/features/namespaces");
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException.getMessage());
        }
    }

    public boolean isValidating() {
        try {
            return this.domParser.getFeature("http://xml.org/sax/features/validation");
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException.getMessage());
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.er = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.eh = errorHandler == null ? new DefaultHandler() : errorHandler;
    }

    DOMParser getDOMParser() {
        return this.domParser;
    }
}

