/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.project.anttasks.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.spi.BpelModelFactory;
import org.netbeans.modules.bpel.project.CommandlineBpelProjectXmlCatalogProvider;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.ls.LSInput;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CliBpelCatalogModel
implements CatalogModel {
    static CliBpelCatalogModel singletonCatMod = null;
    static File projectCatalogFileLocation = null;

    public CliBpelCatalogModel() {
        URI catalogFileLocPath = CommandlineBpelProjectXmlCatalogProvider.getInstance().getProjectCatalogUri();
        if (catalogFileLocPath != null) {
            projectCatalogFileLocation = new File(catalogFileLocPath);
        }
    }

    public static CliBpelCatalogModel getDefault() {
        if (singletonCatMod == null) {
            singletonCatMod = new CliBpelCatalogModel();
        }
        return singletonCatMod;
    }

    private File getProjectCatalogXML() {
        if (projectCatalogFileLocation != null && projectCatalogFileLocation.exists()) {
            return projectCatalogFileLocation;
        }
        return null;
    }

    public ModelSource getModelSource(URI locationURI) throws CatalogModelException {
        ArrayList<File> catalogFileList = new ArrayList<File>();
        File file = null;
        File projectCatalogXML = this.getProjectCatalogXML();
        if (projectCatalogXML != null) {
            catalogFileList.add(projectCatalogXML);
        }
        if (catalogFileList.size() > 0) {
            URI uri = null;
            try {
                uri = this.resolveUsingApacheCatalog(catalogFileList, locationURI.toString());
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (uri != null) {
                file = new File(uri);
            } else {
                try {
                    file = new File(locationURI);
                }
                catch (IllegalArgumentException ie) {
                    throw new CatalogModelException("Invalid URI" + locationURI.toString());
                }
            }
        } else {
            try {
                file = new File(locationURI);
            }
            catch (IllegalArgumentException ie) {
                throw new CatalogModelException("Invalid URI" + locationURI.toString());
            }
        }
        return this.createModelSource(file, true);
    }

    public ModelSource getModelSource(URI locationURI, ModelSource modelSourceOfSourceDocument) throws CatalogModelException {
        File sFile;
        if (locationURI == null) {
            return null;
        }
        URI resolvedURI = locationURI;
        if (modelSourceOfSourceDocument != null && (sFile = (File)modelSourceOfSourceDocument.getLookup().lookup(File.class)) != null) {
            URI sURI = sFile.toURI();
            resolvedURI = sURI.resolve(locationURI);
        }
        if (resolvedURI != null) {
            return this.getModelSource(resolvedURI);
        }
        return null;
    }

    protected Document getDocument(File file) throws CatalogModelException {
        PlainDocument result = null;
        if (result != null) {
            return result;
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] buffer = new byte[fis.available()];
            result = new PlainDocument();
            result.remove(0, result.getLength());
            fis.read(buffer);
            fis.close();
            String str = new String(buffer);
            result.insertString(0, str, null);
        }
        catch (Exception dObjEx) {
            throw new CatalogModelException(file.getAbsolutePath() + " File Not Found");
        }
        return result;
    }

    private BpelModelFactory getModelFactory() {
        BpelModelFactory factory = null;
        try {
            factory = (BpelModelFactory)Lookup.getDefault().lookup(BpelModelFactory.class);
        }
        catch (Exception cnfe) {
            throw new RuntimeException(cnfe);
        }
        return factory;
    }

    public ModelSource createModelSource(File file, boolean readOnly) throws CatalogModelException {
        Lookup lookup = Lookups.fixed((Object[])new Object[]{file, this.getDocument(file), CliBpelCatalogModel.getDefault(), file});
        return new ModelSource(lookup, readOnly);
    }

    public BpelModel getBPELModel(URI locationURI) throws Exception {
        ModelSource source = CliBpelCatalogModel.getDefault().getModelSource(locationURI);
        BpelModel model = this.getModelFactory().getModel(source);
        model.sync();
        return model;
    }

    protected URI resolveUsingApacheCatalog(List<File> catalogFileList, String locationURI) throws CatalogModelException, IOException {
        CatalogManager manager = new CatalogManager(null);
        manager.setUseStaticCatalog(false);
        manager.setPreferPublic(false);
        CatalogResolver catalogResolver = new CatalogResolver(manager);
        Catalog apacheCatalogResolverObj = catalogResolver.getCatalog();
        for (File catFile : catalogFileList) {
            if (catFile.length() <= 0L) continue;
            try {
                apacheCatalogResolverObj.parseCatalog(catFile.getAbsolutePath());
            }
            catch (Throwable ex) {
                throw new CatalogModelException(ex);
            }
            String result = null;
            try {
                result = apacheCatalogResolverObj.resolveSystem(locationURI);
            }
            catch (MalformedURLException ex) {
                result = "";
            }
            catch (IOException ex) {
                result = "";
            }
            if (result == null) {
                result = "";
            } else {
                try {
                    result = Utilities.normalizeURI((String)result);
                    URI uri = new URI(result);
                    if (uri.isOpaque() && uri.getScheme().equalsIgnoreCase("file")) {
                        StringBuffer resBuff = new StringBuffer(result);
                        result = resBuff.insert("file:".length(), "/").toString();
                    }
                }
                catch (URISyntaxException ex) {
                    return null;
                }
            }
            if (result.length() <= 0) continue;
            try {
                URI res = new URI(result);
                return res;
            }
            catch (URISyntaxException ex) {
            }
        }
        return null;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return null;
    }

    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        return null;
    }
}

