/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.project.anttasks.ide;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Reference;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.project.CommandlineBpelProjectXmlCatalogProvider;
import org.netbeans.modules.bpel.project.anttasks.ide.IdeBpelCatalogModel;
import org.netbeans.modules.bpel.project.anttasks.util.Util;
import org.netbeans.modules.soa.validation.core.Controller;
import org.netbeans.modules.xml.xam.Model;

public class IdeValidateBpelProjectTask
extends Task {
    private String mSourceDirectory;
    private String mProjectClassPath;
    private String mBuildDirectory;
    private String mBuildDependentProjectFilesDirectory;
    private File mSourceDir;
    private File mBuildDir;
    private Map myFileNamesToFileInBuildDir = new HashMap();
    private boolean isFoundErrors = false;
    private boolean myAllowBuildWithError = false;
    private List<MyFile> myMyFiles;

    public void setSourceDirectory(String srcDir) {
        this.mSourceDirectory = srcDir;
    }

    public void setBuildDirectory(String buildDir) {
        this.mBuildDirectory = buildDir;
    }

    public void setRunValidation(String flag) {
        this.setAllowBuildWithError(flag);
        this.myAllowBuildWithError = !this.myAllowBuildWithError;
    }

    public void setAllowBuildWithError(String flag) {
        if (flag != null) {
            if (flag.equals("false")) {
                this.myAllowBuildWithError = false;
            } else if (flag.equals("true")) {
                this.myAllowBuildWithError = true;
            }
        }
    }

    public void setClasspathRef(Reference ref) {
    }

    public void setProjectClassPath(String projectClassPath) {
        this.mProjectClassPath = projectClassPath;
    }

    public void setBuildDependentProjectDir(String dependentProjectFilesDir) {
        this.mBuildDependentProjectFilesDirectory = dependentProjectFilesDir;
    }

    public boolean isFoundErrors() {
        return this.isFoundErrors;
    }

    public void execute() throws BuildException {
        if (this.mSourceDirectory == null) {
            throw new BuildException("No directory is set for source files.");
        }
        if (this.mBuildDirectory == null) {
            throw new BuildException("No build directory is set.");
        }
        if (this.mBuildDependentProjectFilesDirectory == null) {
            throw new BuildException("No dependentProjectFiles directory is set.");
        }
        try {
            this.mSourceDir = new File(this.mSourceDirectory);
            CommandlineBpelProjectXmlCatalogProvider.getInstance().setSourceDirectory(this.mSourceDirectory);
        }
        catch (Exception ex) {
            throw new BuildException("Failed to get File object for project source directory " + this.mSourceDirectory, (Throwable)ex);
        }
        try {
            this.mBuildDir = new File(this.mBuildDirectory);
        }
        catch (Exception ex) {
            throw new BuildException("Failed to get File object for project build directory " + this.mBuildDirectory, (Throwable)ex);
        }
        this.myMyFiles = new ArrayList<MyFile>();
        this.processFilesFolderInBuildDir(this.mBuildDir);
        this.processSourceDirs(Arrays.asList(this.mSourceDir));
    }

    private void processFilesFolderInBuildDir(File folder) {
        File[] files = folder.listFiles(new Util.BpelFileFilter());
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isFile()) {
                this.processFilesInBuildDir(file);
                continue;
            }
            this.processFilesFolderInBuildDir(file);
        }
    }

    private void processFilesInBuildDir(File file) {
        String relativePath = Util.getRelativePath(this.mBuildDir, file);
        this.myFileNamesToFileInBuildDir.put(relativePath, file);
    }

    private void processSourceDirs(List sourceDirs) {
        for (File sourceDir : sourceDirs) {
            this.processSourceDir(sourceDir);
        }
    }

    private void processSourceDir(File sourceDir) {
        this.processFileObject(sourceDir);
    }

    private void processFileObject(File file) {
        if (file.isDirectory()) {
            this.processFolder(file);
        }
    }

    private void processFolder(File fileDir) {
        File[] files = fileDir.listFiles(new Util.BpelFileFilter());
        this.processFiles(files);
    }

    private void processFiles(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                this.processFile(files[i]);
                continue;
            }
            this.processFolder(files[i]);
        }
    }

    private void processFile(File file) throws BuildException {
        block7: {
            BpelModel model = null;
            try {
                model = IdeBpelCatalogModel.getDefault().getBPELModel(file);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while trying to get Model", e);
            }
            Process process = model.getProcess();
            if (process != null) {
                String qName = process.getName() + ", " + process.getTargetNamespace();
                MyFile current = new MyFile(file, this.mSourceDir, qName);
                for (MyFile mFile : this.myMyFiles) {
                    if (!mFile.getQName().equals(qName) || this.myAllowBuildWithError) continue;
                    throw new BuildException(" \nBPEL files " + mFile.getName() + " and " + current.getName() + "\n" + "have the same bpel process name and targetname space:\n" + qName + " \n \n");
                }
                this.myMyFiles.add(current);
            }
            if (this.isModified(file)) {
                try {
                    this.validateFile(file);
                }
                catch (Throwable ex) {
                    if (this.myAllowBuildWithError) break block7;
                    throw new BuildException(ex);
                }
            }
        }
    }

    private boolean isModified(File file) {
        boolean modified = true;
        String relativePath = Util.getRelativePath(this.mSourceDir, file);
        File fileInBuildDir = (File)this.myFileNamesToFileInBuildDir.get(relativePath);
        if (fileInBuildDir != null && fileInBuildDir.lastModified() == file.lastModified()) {
            modified = false;
        }
        return modified;
    }

    private void validateFile(File file) throws BuildException {
        try {
            BpelModel model = IdeBpelCatalogModel.getDefault().getBPELModel(file);
            if (new Controller((Model)model).ideValidate(file)) {
                throw new BuildException("Found validation error(s).");
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private static class MyFile {
        private File myFile;
        private File myProject;
        private String myQName;

        public MyFile(File file, File project, String qName) {
            this.myFile = file;
            this.myProject = project;
            this.myQName = qName;
        }

        public String getQName() {
            return this.myQName;
        }

        public String getName() {
            String path;
            String file = this.myFile.toString();
            if (file.startsWith(path = this.myProject.toString())) {
                return file.substring(path.length() + 1);
            }
            return file;
        }
    }
}

