/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.project.anttasks.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.bpel.project.CommandlineBpelProjectXmlCatalogProvider;
import org.netbeans.modules.bpel.project.anttasks.util.CatalogReader;
import org.netbeans.modules.bpel.project.anttasks.util.Util;
import org.netbeans.modules.xml.catalogsupport.DefaultProjectCatalogSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PackageCatalogArtifacts {
    private Logger logger = Logger.getLogger(PackageCatalogArtifacts.class.getName());

    public void doCopy(File sourceDirectory, File buildDirectory) {
        boolean projectCatalogExists;
        CommandlineBpelProjectXmlCatalogProvider.getInstance().setSourceDirectory(sourceDirectory.getAbsolutePath());
        File projectCatalogFile = new File(CommandlineBpelProjectXmlCatalogProvider.getInstance().getProjectCatalogUri());
        boolean bl = projectCatalogExists = projectCatalogFile.exists() && projectCatalogFile.length() > 0L;
        if (!projectCatalogExists) {
            return;
        }
        try {
            CatalogReader projectCatalogReader = projectCatalogExists ? new CatalogReader(projectCatalogFile.getCanonicalPath()) : null;
            this.doCopy(sourceDirectory, buildDirectory, projectCatalogReader);
        }
        catch (Throwable ex) {
            this.logger.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void doCopy(File sourceDirectory, File buildDirectory, CatalogReader projectCatalog) throws Exception {
        List<Object> listOfProjectNSs = projectCatalog == null ? new ArrayList() : projectCatalog.getNamespaces();
        List<Object> listOfProjectURIs = projectCatalog == null ? new ArrayList() : projectCatalog.getLocations();
        File metaInfDirectory = new File(buildDirectory, "META-INF");
        metaInfDirectory.mkdirs();
        File projectDirectory = buildDirectory.getParentFile();
        File catalogFile = new File(metaInfDirectory, "catalog.xml");
        String retrieverPathPrefix = "nbproject/private/cache/";
        String retrieverPathPrefix2 = "retrieved/";
        PrintWriter catalogWriter = new PrintWriter(new FileWriter(catalogFile));
        catalogWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        catalogWriter.println("<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\" prefer=\"system\">");
        for (int i = 0; i < listOfProjectNSs.size(); ++i) {
            String ns = (String)listOfProjectNSs.get(i);
            String localUri = (String)listOfProjectURIs.get(i);
            URI realUri = new URI(localUri);
            if (realUri.getScheme() == null) {
                if (localUri.startsWith(sourceDirectory.getName() + "/")) {
                    localUri = "../" + localUri.substring(sourceDirectory.getName().length() + 1);
                }
                if (localUri.startsWith("nbproject/private/cache/")) {
                    localUri = localUri.substring("nbproject/private/cache/".length());
                    Util.copyFile(new File(projectDirectory, "nbproject/private/cache/" + localUri), new File(buildDirectory, "_" + localUri));
                    localUri = "../_" + localUri;
                }
                if (localUri.startsWith("retrieved/")) {
                    Util.copyFile(new File(projectDirectory, localUri), new File(buildDirectory, "_" + localUri));
                    localUri = "../_" + localUri;
                }
            } else if (realUri.getScheme().equals("nb-uri")) {
                try {
                    Project project = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)sourceDirectory));
                    AntProjectHelper antHelper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
                    ReferenceHelper referenceHelper = (ReferenceHelper)project.getLookup().lookup(ReferenceHelper.class);
                    DefaultProjectCatalogSupport catalogSupport = new DefaultProjectCatalogSupport(project, antHelper, referenceHelper);
                    FileObject fo = catalogSupport.resolveProjectProtocol(new URI(localUri));
                    File file = FileUtil.toFile((FileObject)fo);
                    Project referencedProject = FileOwnerQuery.getOwner((FileObject)fo);
                    String uri = "_dependent/" + referencedProject.getProjectDirectory().getName() + "/" + Util.getRelativePath(FileUtil.toFile((FileObject)referencedProject.getProjectDirectory()), file);
                    File target = new File(buildDirectory, uri);
                    Util.copyFile(file, target);
                    this.processImports(file, target);
                    localUri = "../" + uri;
                }
                catch (Exception e) {
                    File[] resolved = this.resolveProjectUri(projectDirectory, localUri);
                    if (resolved != null && resolved[0].exists()) {
                        String uri = "_dependent/" + resolved[1] + "/" + Util.getRelativePath(resolved[1], resolved[0]);
                        File target = new File(buildDirectory, uri);
                        Util.copyFile(resolved[0], target);
                        this.processImports(resolved[0], target);
                        localUri = "../" + uri;
                    }
                    localUri = null;
                }
            }
            if (localUri == null) continue;
            localUri = localUri.replace("\\", "/");
            catalogWriter.println("    <system systemId=\"" + ns + "\" uri=\"" + localUri + "\"/>");
        }
        catalogWriter.println("</catalog>");
        catalogWriter.flush();
        catalogWriter.close();
    }

    private File[] resolveProjectUri(File projectDirectory, String uri) throws IOException {
        String corrected = uri.substring("nb-uri:".length());
        String projectName = corrected.substring(0, corrected.indexOf("#"));
        String path = corrected.substring(corrected.indexOf("#") + 1);
        String projectLocation = null;
        File properties = new File(projectDirectory, "nbproject/project.properties");
        BufferedReader reader = new BufferedReader(new FileReader(properties));
        String key = "project." + projectName + "=";
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (!line.startsWith(key)) continue;
            projectLocation = line.substring(key.length());
            break;
        }
        reader.close();
        if (projectLocation == null) {
            return null;
        }
        return new File[]{new File(projectDirectory, projectLocation + "/" + path), new File(projectDirectory, projectLocation)};
    }

    private void processImports(File source, File target) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(source, (DefaultHandler)new MyHandler(source, target));
        }
        catch (IOException e) {
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXException e) {
            // empty catch block
        }
    }

    private class MyHandler
    extends DefaultHandler {
        private File source;
        private File target;

        public MyHandler(File source, File target) {
            this.source = source;
            this.target = target;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("import".equals(qName) || "xsd:import".equals(qName)) {
                String wsdlLocation = attributes.getValue("location");
                String schemaLocation = attributes.getValue("schemaLocation");
                String location = wsdlLocation == null ? schemaLocation : wsdlLocation;
                File referenced = new File(this.source.getParentFile(), location);
                File dereferenced = new File(this.target.getParentFile(), location);
                if (location != null && referenced.exists() && !referenced.isDirectory()) {
                    try {
                        Util.copyFile(referenced, dereferenced);
                    }
                    catch (IOException e) {
                        throw new SAXException(e);
                    }
                    PackageCatalogArtifacts.this.processImports(referenced, dereferenced);
                }
            }
        }
    }
}

