/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.sunas;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import org.netbeans.modules.profiler.attach.panels.AttachWizardPanel;
import org.netbeans.modules.profiler.attach.providers.TargetPlatform;
import org.netbeans.modules.profiler.attach.providers.ValidationResult;
import org.netbeans.modules.profiler.attach.wizard.AttachWizardContext;
import org.netbeans.modules.profiler.j2ee.sunas.SunASAutoIntegrationProvider;
import org.netbeans.modules.profiler.j2ee.sunas.SunASIntegrationPanelUI;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SunASIntegrationPanel
extends AttachWizardPanel {
    private static final String HELP_CTX_KEY = "SunASIntegrationPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("SunASIntegrationPanel.HelpCtx");
    private Model model = new Model();
    private String domainHint = "";
    private String hint = "";
    private SunASIntegrationPanelUI panel = null;

    public HelpCtx getHelp() {
        return HELP_CTX;
    }

    public boolean isValid() {
        return this.model.getInstallPath() != null && this.model.getInstallPath().length() > 0 && this.model.getDomain() != null && this.model.getDomain().length() > 0 && this.model.getSelectedPlatform() != null;
    }

    public boolean canBack(AttachWizardContext attachWizardContext) {
        return true;
    }

    public boolean canFinish(AttachWizardContext attachWizardContext) {
        return false;
    }

    public boolean canNext(AttachWizardContext attachWizardContext) {
        return this.isValid();
    }

    public boolean onCancel(AttachWizardContext attachWizardContext) {
        return true;
    }

    public void onEnter(AttachWizardContext attachWizardContext) {
        if (this.model.getDomain() == null || this.model.getDomain().length() == 0) {
            this.model.setDomain(((SunASAutoIntegrationProvider)attachWizardContext.getIntegrationProvider()).getDomain());
        }
        if (this.model.getInstallPath() == null || this.model.getInstallPath().length() == 0) {
            this.model.setInstallPath(((SunASAutoIntegrationProvider)attachWizardContext.getIntegrationProvider()).getInstallationPath());
        }
        String string = ((SunASAutoIntegrationProvider)attachWizardContext.getIntegrationProvider()).getTargetJava();
        List list = TargetPlatform.getPlatformList((boolean)false);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TargetPlatform targetPlatform = (TargetPlatform)iterator.next();
            if (!targetPlatform.equals((Object)string)) continue;
            this.model.setTargetJava(targetPlatform);
            break;
        }
        this.panel.loadModel();
    }

    public void onExit(AttachWizardContext attachWizardContext) {
        SunASAutoIntegrationProvider sunASAutoIntegrationProvider = (SunASAutoIntegrationProvider)this.getContext().getIntegrationProvider();
        boolean bl = false;
        if (!sunASAutoIntegrationProvider.getInstallationPath().equals(this.model.getInstallPath())) {
            bl = true;
        } else if (!sunASAutoIntegrationProvider.getDomain().equals(this.model.getDomain())) {
            bl = true;
        } else if (sunASAutoIntegrationProvider.getTargetJavaHome() != null && this.model.getSelectedPlatform() != null && !sunASAutoIntegrationProvider.getTargetJavaHome().equals(this.model.getSelectedPlatform().getHomePath())) {
            bl = true;
        }
        if (bl) {
            attachWizardContext.setConfigChanged();
        }
        sunASAutoIntegrationProvider.setInstallationPath(this.model.getInstallPath());
        sunASAutoIntegrationProvider.setDomain(this.model.getDomain());
        sunASAutoIntegrationProvider.setTargetPlatform(this.model.getSelectedPlatform());
    }

    public void onFinish(AttachWizardContext attachWizardContext) {
    }

    protected JPanel getRenderPanel() {
        if (this.panel == null) {
            this.panel = new SunASIntegrationPanelUI(this.model);
        }
        return this.panel;
    }

    protected void onPanelShow() {
        this.panel.refreshJvmList(this.model.getSelectedPlatform());
    }

    class Model {
        private List domains = new Vector();
        private String domain = "";
        private String installPath = "";
        private TargetPlatform targetPlatform = null;

        public void setDomain(String string) {
            this.domain = string;
            SunASIntegrationPanel.this.publishUpdate(new ChangeEvent(this));
        }

        public String getDomain() {
            return this.domain;
        }

        public String getDomainHint() {
            return SunASIntegrationPanel.this.domainHint;
        }

        public List getDomains() {
            return this.domains;
        }

        public void setInstallPath(String string) {
            String string2;
            SunASAutoIntegrationProvider sunASAutoIntegrationProvider = (SunASAutoIntegrationProvider)SunASIntegrationPanel.this.getContext().getIntegrationProvider();
            ValidationResult validationResult = sunASAutoIntegrationProvider.validateInstallation(string2 = SunASIntegrationPanel.this.getContext().getAttachSettings().getHostOS(), string);
            if (!validationResult.isValid()) {
                SunASIntegrationPanel.this.hint = validationResult.getMessage();
                SunASIntegrationPanel.this.domainHint = NbBundle.getMessage(this.getClass(), (String)"SunAS8IntegrationProvider_InstallDirPendingMsg");
            } else {
                SunASIntegrationPanel.this.hint = "";
                SunASIntegrationPanel.this.domainHint = "";
            }
            this.installPath = string;
            this.updateDomains();
            SunASIntegrationPanel.this.publishUpdate(new ChangeEvent(this));
        }

        public String getInstallPath() {
            return this.installPath;
        }

        public String getInstallPathHint() {
            return SunASIntegrationPanel.this.hint;
        }

        public TargetPlatform getSelectedPlatform() {
            return this.targetPlatform;
        }

        public void setTargetJava(TargetPlatform targetPlatform) {
            this.targetPlatform = targetPlatform;
            SunASIntegrationPanel.this.publishUpdate(new ChangeEvent(this));
        }

        private void updateDomains() {
            SunASAutoIntegrationProvider sunASAutoIntegrationProvider = (SunASAutoIntegrationProvider)SunASIntegrationPanel.this.getContext().getIntegrationProvider();
            this.domains.clear();
            this.domains.addAll(sunASAutoIntegrationProvider.getAvailableDomains(this.installPath));
            if ((this.domain == null || this.domain.length() == 0) && this.domains.size() > 0) {
                this.domain = (String)this.domains.get(0);
            } else if (this.domains.size() == 0) {
                this.domain = null;
            }
        }
    }
}

