/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.deployment.ricoh;

import java.awt.Toolkit;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class PortVerifier
extends InputVerifier {
    public static int MIN_PORT_VALUE = 0;
    public static int MAX_PORT_VALUE = 65535;

    public boolean verify(JComponent jComponent) {
        if (jComponent instanceof JTextField) {
            JTextField jTextField = (JTextField)jComponent;
            try {
                if (jTextField.getText().trim().equals("")) {
                    return true;
                }
                int n = Integer.parseInt(jTextField.getText());
                if (n >= MIN_PORT_VALUE && n <= MAX_PORT_VALUE) {
                    return true;
                }
                throw new NumberFormatException("Outside port range");
            }
            catch (NumberFormatException numberFormatException) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(jComponent.getTopLevelAncestor(), "Enter a valid port number (" + MIN_PORT_VALUE + " to " + MAX_PORT_VALUE + ")", "Invalid port number", 2);
                return false;
            }
        }
        return true;
    }
}

