/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ddloaders.multiview.webservice;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.glassfish.eecommon.api.config.GlassfishConfiguration;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.ServiceImplBean;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.sun.ddloaders.Utils;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.common.CommonBeanReader;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortComponentMetadataReader
extends CommonBeanReader {
    private String parentName;

    public PortComponentMetadataReader(String string) {
        super("PortComponent");
        this.parentName = string;
    }

    @Override
    protected CommonDDBean normalizeParent(CommonDDBean commonDDBean) {
        if (this.parentName != null && commonDDBean instanceof Webservices) {
            commonDDBean = this.findWebServiceDescByName((Webservices)commonDDBean, this.parentName);
        }
        return commonDDBean;
    }

    private CommonDDBean findWebServiceDescByName(Webservices webservices, String string) {
        return this.findWebServiceDescByName(webservices.getWebserviceDescription(), string);
    }

    private CommonDDBean findWebServiceDescByName(WebserviceDescription[] webserviceDescriptionArray, String string) {
        WebserviceDescription webserviceDescription = null;
        if (webserviceDescriptionArray != null) {
            for (WebserviceDescription webserviceDescription2 : webserviceDescriptionArray) {
                if (!string.equals(webserviceDescription2.getWebserviceDescriptionName())) continue;
                webserviceDescription = webserviceDescription2;
                break;
            }
        }
        return webserviceDescription;
    }

    @Override
    public Map<String, Object> readAnnotations(DataObject dataObject) {
        Map<String, Object> map = null;
        try {
            J2eeModule j2eeModule;
            File file = FileUtil.toFile((FileObject)dataObject.getPrimaryFile());
            GlassfishConfiguration glassfishConfiguration = GlassfishConfiguration.getConfiguration((File)file);
            if (glassfishConfiguration != null && (j2eeModule = glassfishConfiguration.getJ2eeModule()) != null && (J2eeModule.WAR.equals(j2eeModule.getModuleType()) || J2eeModule.EJB.equals(j2eeModule.getModuleType()))) {
                map = this.readWebservicesMetadata((MetadataModel<WebservicesMetadata>)j2eeModule.getMetadataModel(WebservicesMetadata.class));
            }
        }
        catch (MetadataModelException metadataModelException) {
            ErrorManager.getDefault().notify(1, (Throwable)metadataModelException);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        return map;
    }

    @Override
    public Map<String, Object> genProperties(CommonDDBean[] commonDDBeanArray) {
        HashMap<String, HashMap<String, Object>> hashMap = null;
        if (commonDDBeanArray instanceof PortComponent[]) {
            PortComponent[] portComponentArray;
            for (PortComponent portComponent : portComponentArray = (PortComponent[])commonDDBeanArray) {
                String string = portComponent.getPortComponentName();
                if (!Utils.notEmpty(string)) continue;
                if (hashMap == null) {
                    hashMap = new HashMap<String, HashMap<String, Object>>();
                }
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                hashMap.put(string, hashMap2);
                hashMap2.put("Name", string);
                this.addMapString(hashMap2, "EndpointInterface", portComponent.getServiceEndpointInterface());
                ServiceImplBean serviceImplBean = portComponent.getServiceImplBean();
                if (serviceImplBean == null) continue;
                this.addMapString(hashMap2, "ServletLink", serviceImplBean.getServletLink());
                this.addMapString(hashMap2, "EjbLink", serviceImplBean.getEjbLink());
            }
        }
        return hashMap;
    }
}

