/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.BeanInputDialog;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.BeanTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.FixedHeightJTable;

public abstract class BeanTablePanel
extends JPanel {
    protected JTable table;
    protected JButton moveUpButton;
    protected JButton moveDownButton;
    protected JButton sourceButton;
    private boolean reordable;
    protected BeanTableModel model;
    private boolean isSource;
    private final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private JPanel southPanel;
    protected JButton addButton;
    private JPanel buttonPanel;
    private JScrollPane jScrollPane1;
    protected JButton editButton;
    protected JButton removeButton;
    private JPanel rightPanel;

    public BeanTablePanel(BeanTableModel beanTableModel) {
        this(beanTableModel, false, false);
    }

    public BeanTablePanel(BeanTableModel beanTableModel, boolean bl) {
        this(beanTableModel, bl, false);
    }

    public BeanTablePanel(BeanTableModel beanTableModel, final boolean bl, final boolean bl2) {
        this.model = beanTableModel;
        this.reordable = bl;
        this.isSource = bl2;
        this.initComponents();
        this.table = new FixedHeightJTable();
        this.table.getAccessibleContext().setAccessibleName(this.getAccessibleName());
        this.table.getAccessibleContext().setAccessibleDescription(this.getAccessibleDesc());
        this.getAccessibleContext().setAccessibleName(this.getAccessibleName());
        this.getAccessibleContext().setAccessibleDescription(this.getAccessibleDesc());
        this.table.setSelectionMode(0);
        this.table.setModel(beanTableModel);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (((ListSelectionModel)listSelectionEvent.getSource()).isSelectionEmpty() || BeanTablePanel.this.table.getModel().getRowCount() == 0) {
                    BeanTablePanel.this.editButton.setEnabled(false);
                    BeanTablePanel.this.removeButton.setEnabled(false);
                    if (bl) {
                        BeanTablePanel.this.moveUpButton.setEnabled(false);
                        BeanTablePanel.this.moveDownButton.setEnabled(false);
                    }
                    if (bl2) {
                        BeanTablePanel.this.sourceButton.setEnabled(false);
                    }
                } else {
                    BeanTablePanel.this.editButton.setEnabled(true);
                    BeanTablePanel.this.removeButton.setEnabled(true);
                    if (bl) {
                        int n = BeanTablePanel.this.table.getSelectedRow();
                        if (n < BeanTablePanel.this.table.getModel().getRowCount() - 1) {
                            BeanTablePanel.this.moveDownButton.setEnabled(true);
                        } else {
                            BeanTablePanel.this.moveDownButton.setEnabled(false);
                        }
                        if (n > 0) {
                            BeanTablePanel.this.moveUpButton.setEnabled(true);
                        } else {
                            BeanTablePanel.this.moveUpButton.setEnabled(false);
                        }
                    }
                    if (bl2) {
                        BeanTablePanel.this.sourceButton.setEnabled(true);
                    }
                }
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        if (bl) {
            this.moveUpButton = new JButton(this.bundle.getString("LBL_Move_Up"));
            this.moveDownButton = new JButton(this.bundle.getString("LBL_Move_Down"));
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
            this.buttonPanel.add(this.moveUpButton);
            this.buttonPanel.add(this.moveDownButton);
        }
        if (bl2) {
            this.sourceButton = new JButton(this.bundle.getString("LBL_Go_To_Source"));
            this.sourceButton.setEnabled(false);
            this.rightPanel.add(this.sourceButton);
        }
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = BeanTablePanel.this.table.getSelectedRow();
                if (n >= 0) {
                    BeanTablePanel.this.getModel().removeRow(n);
                    if (n >= BeanTablePanel.this.getModel().getRowCount()) {
                        --n;
                    }
                    if (n >= 0) {
                        BeanTablePanel.this.table.getSelectionModel().setSelectionInterval(n, n);
                    }
                }
            }
        });
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BeanTablePanel.this.displayDialog(true);
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BeanTablePanel.this.displayDialog(false);
            }
        });
    }

    public void setModel(Object object, CommonDDBean[] commonDDBeanArray) {
        this.model.setData(object, commonDDBeanArray);
    }

    protected void displayDialog(boolean bl) {
        int n = -1;
        BeanInputDialog beanInputDialog = null;
        if (bl) {
            n = this.table.getSelectedRow();
            if (n < 0) {
                return;
            }
            Object[] objectArray = this.model.getValues(n);
            beanInputDialog = this.getInputDialog(objectArray);
        } else {
            beanInputDialog = this.getInputDialog();
        }
        do {
            int n2 = beanInputDialog.display();
            if (n2 == 0) break;
            if (n2 != 1) continue;
            if (beanInputDialog.hasErrors()) {
                beanInputDialog.showErrors();
                continue;
            }
            if (bl) {
                this.model.editRow(n, beanInputDialog.getValues());
                continue;
            }
            this.model.addRow(beanInputDialog.getValues());
        } while (beanInputDialog.hasErrors());
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.southPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.addButton = new JButton();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.rightPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.jScrollPane1, "Center");
        this.southPanel.setLayout(new BorderLayout());
        String string = this.bundle.getString("LBL_New");
        int n = string.indexOf(this.bundle.getString("MNC_New").charAt(0));
        if (n < 0) {
            n = 0;
        }
        this.addButton.setText(string);
        this.addButton.setDisplayedMnemonicIndex(n);
        AccessibleContext accessibleContext = this.addButton.getAccessibleContext();
        accessibleContext.setAccessibleName(this.bundle.getString("ACSN_New"));
        accessibleContext.setAccessibleDescription(this.bundle.getString("ACSD_New"));
        this.buttonPanel.add(this.addButton);
        string = this.bundle.getString("LBL_Edit");
        n = string.indexOf(this.bundle.getString("MNC_Edit").charAt(0));
        if (n < 0) {
            n = 0;
        }
        this.editButton.setText(string);
        this.editButton.setDisplayedMnemonicIndex(n);
        this.editButton.setEnabled(false);
        accessibleContext = this.editButton.getAccessibleContext();
        accessibleContext.setAccessibleName(this.bundle.getString("ACSN_Edit"));
        accessibleContext.setAccessibleDescription(this.bundle.getString("ACSD_Edit"));
        this.buttonPanel.add(this.editButton);
        string = this.bundle.getString("LBL_Delete");
        n = string.indexOf(this.bundle.getString("MNC_Delete").charAt(0));
        if (n < 0) {
            n = 0;
        }
        this.removeButton.setText(string);
        this.removeButton.setDisplayedMnemonicIndex(n);
        this.removeButton.setEnabled(false);
        accessibleContext = this.removeButton.getAccessibleContext();
        accessibleContext.setAccessibleName(this.bundle.getString("ACSN_Delete"));
        accessibleContext.setAccessibleDescription(this.bundle.getString("ACSD_Delete"));
        this.buttonPanel.add(this.removeButton);
        this.southPanel.add((Component)this.buttonPanel, "Center");
        this.southPanel.add((Component)this.rightPanel, "East");
        this.add((Component)this.southPanel, "South");
    }

    public abstract BeanInputDialog getInputDialog(Object[] var1);

    public abstract BeanInputDialog getInputDialog();

    protected String getAccessibleName() {
        return this.bundle.getString("ACSN_Table");
    }

    protected String getAccessibleDesc() {
        return this.bundle.getString("ACSD_Table");
    }

    public BeanTableModel getModel() {
        return this.model;
    }

    public void setTitle(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setBorder(new EmptyBorder(5, 5, 5, 0));
        this.add((Component)jLabel, "North");
    }

    public void setSelectedRow(int n) {
        this.table.setRowSelectionInterval(n, n);
    }

    public void setButtons(boolean bl, boolean bl2, boolean bl3) {
        this.addButton.setEnabled(bl);
        this.editButton.setEnabled(bl2);
        this.removeButton.setEnabled(bl3);
    }

    public void setButtons(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.setButtons(bl, bl2, bl3);
        this.moveUpButton.setEnabled(bl4);
        this.moveDownButton.setEnabled(bl5);
    }

    public boolean isReordable() {
        return this.reordable;
    }

    public boolean isSource() {
        return this.isSource;
    }
}

