/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.jruby.ast.IterNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.EditList;
import org.netbeans.modules.gsf.api.EditRegions;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintSeverity;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.PreviewableFix;
import org.netbeans.modules.gsf.api.Rule;
import org.netbeans.modules.gsf.api.RuleContext;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockVarReuse
extends RubyAstRule {
    public boolean appliesTo(RuleContext ruleContext) {
        return true;
    }

    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.ITERNODE);
    }

    public void cancel() {
    }

    public String getId() {
        return "Block_Var_Reuse";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(BlockVarReuse.class, (String)"UnintentionalSideEffect");
    }

    public String getDescription() {
        return NbBundle.getMessage(BlockVarReuse.class, (String)"UnintentionalSideEffectDesc");
    }

    @Override
    public void run(RubyRuleContext rubyRuleContext, List<Hint> list) {
        Node node = rubyRuleContext.node;
        CompilationInfo compilationInfo = rubyRuleContext.compilationInfo;
        if (node.nodeId == NodeType.ITERNODE) {
            List list2 = node.childNodes();
            for (Node node2 : list2) {
                if (node2.nodeId != NodeType.LOCALASGNNODE) continue;
                OffsetRange offsetRange = AstUtilities.getNameRange((Node)node2);
                ArrayList<RenameVarFix> arrayList = new ArrayList<RenameVarFix>(2);
                Node node3 = AstUtilities.getRoot((CompilationInfo)compilationInfo);
                AstPath astPath = new AstPath(node3, node2);
                arrayList.add(new RenameVarFix(rubyRuleContext, astPath, false));
                arrayList.add(new RenameVarFix(rubyRuleContext, astPath, true));
                if ((offsetRange = LexUtilities.getLexerOffsets((CompilationInfo)compilationInfo, (OffsetRange)offsetRange)) == OffsetRange.NONE) continue;
                Hint hint = new Hint((Rule)this, this.getDisplayName(), compilationInfo.getFileObject(), offsetRange, arrayList, 100);
                list.add(hint);
            }
        }
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public boolean showInTasklist() {
        return true;
    }

    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RenameVarFix
    implements PreviewableFix {
        private final RubyRuleContext context;
        private final AstPath path;
        private final boolean renameLocal;

        RenameVarFix(RubyRuleContext rubyRuleContext, AstPath astPath, boolean bl) {
            this.context = rubyRuleContext;
            this.path = astPath;
            this.renameLocal = bl;
        }

        public String getDescription() {
            if (this.renameLocal) {
                return NbBundle.getMessage(BlockVarReuse.class, (String)"ChangeLocalVarName");
            }
            return NbBundle.getMessage(BlockVarReuse.class, (String)"ChangeBlockVarName");
        }

        public void implement() throws Exception {
            Set<OffsetRange> set = this.findRegionsToEdit();
            int n = Integer.MAX_VALUE;
            for (OffsetRange offsetRange : set) {
                if (offsetRange.getStart() >= n) continue;
                n = offsetRange.getStart();
            }
            EditRegions.getInstance().edit(this.context.compilationInfo.getFileObject(), set, n);
        }

        private void addNonBlockRefs(Node node, String string, Set<OffsetRange> set) {
            List list;
            if ((node.nodeId == NodeType.LOCALASGNNODE || node.nodeId == NodeType.LOCALVARNODE) && string.equals(((INameNode)node).getName())) {
                list = AstUtilities.getNameRange((Node)node);
                if ((list = LexUtilities.getLexerOffsets((CompilationInfo)this.context.compilationInfo, (OffsetRange)list)) != OffsetRange.NONE) {
                    set.add((OffsetRange)list);
                }
            }
            list = node.childNodes();
            for (Node node2 : list) {
                if (node2.isInvisible() || node2.nodeId == NodeType.DEFNNODE || node2.nodeId == NodeType.DEFSNODE || node2.nodeId == NodeType.ITERNODE && node2 == this.path.leafParent()) continue;
                this.addNonBlockRefs(node2, string, set);
            }
        }

        private Set<OffsetRange> findRegionsToEdit() {
            HashSet<OffsetRange> hashSet = new HashSet<OffsetRange>();
            assert (this.path.leaf() instanceof INameNode);
            String string = ((INameNode)this.path.leaf()).getName();
            if (this.renameLocal) {
                Node node = AstUtilities.findLocalScope((Node)this.path.leaf(), (AstPath)this.path);
                this.addNonBlockRefs(node, string, hashSet);
            } else {
                Node node = this.path.leafParent();
                assert (node instanceof IterNode);
                this.addNonBlockRefs(node, string, hashSet);
            }
            return hashSet;
        }

        public boolean isSafe() {
            return false;
        }

        public boolean isInteractive() {
            return true;
        }

        public EditList getEditList() throws Exception {
            BaseDocument baseDocument = this.context.doc;
            EditList editList = new EditList(baseDocument);
            Set<OffsetRange> set = this.findRegionsToEdit();
            String string = ((INameNode)this.path.leaf()).getName();
            int n = string.length();
            String string2 = "new_name";
            for (OffsetRange offsetRange : set) {
                editList.replace(offsetRange.getStart(), n, string2, false, 0);
            }
            return editList;
        }

        public boolean canPreview() {
            return true;
        }
    }
}

