/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.checkout;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProjectUtilities {
    private static final String ProjectTab_ID_LOGICAL = "projectTabLogical_tc";

    ProjectUtilities() {
    }

    public static void selectAndExpandProject(final Project project) {
        SwingUtilities.invokeLater(new Runnable(){
            final ExplorerManager.Provider ptLogial = ProjectUtilities.access$000("projectTabLogical_tc");

            public void run() {
                if (this.ptLogial == null) {
                    Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Cannot find Project widnow, aborting.");
                    return;
                }
                Node node = this.ptLogial.getExplorerManager().getRootContext();
                Node node2 = node.getChildren().findChild(ProjectUtils.getInformation((Project)project).getName());
                if (node2 != null) {
                    try {
                        this.ptLogial.getExplorerManager().setSelectedNodes(new Node[]{node2});
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private static synchronized ExplorerManager.Provider findDefault(String string) {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(string);
        return (ExplorerManager.Provider)topComponent;
    }

    public static void newProjectWizard(File file) {
        Action action = CommonProjectActions.newProjectAction();
        if (action != null) {
            File file2 = ProjectChooser.getProjectsFolder();
            ProjectChooser.setProjectsFolder((File)file);
            FileObject fileObject = FileUtil.toFileObject((File)file);
            action.putValue("existingSourcesFolder", fileObject);
            ProjectUtilities.performAction(action);
            try {
                ProjectChooser.setProjectsFolder((File)file2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public static List scanForProjects(FileObject fileObject) {
        ProjectManager.getDefault().clearNonProjectCache();
        return ProjectUtilities.scanForProjectsRecursively(fileObject, 5);
    }

    private static List<Project> scanForProjectsRecursively(FileObject fileObject, int n) {
        Enumeration enumeration;
        if (n <= 0) {
            return Collections.emptyList();
        }
        LinkedList<Project> linkedList = new LinkedList<Project>();
        ProjectManager projectManager = ProjectManager.getDefault();
        if (fileObject.isFolder() && projectManager.isProject(fileObject)) {
            try {
                enumeration = projectManager.findProject(fileObject);
                if (enumeration != null) {
                    linkedList.add((Project)enumeration);
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().annotate((Throwable)iOException, "CVS.PU: ignoring suspicious project folder...");
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
        enumeration = fileObject.getChildren(false);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            if (!fileObject2.isFolder()) continue;
            List<Project> list = ProjectUtilities.scanForProjectsRecursively(fileObject2, n - 1);
            linkedList.addAll(list);
        }
        return linkedList;
    }

    private static boolean performAction(Action action) {
        if (action == null) {
            return false;
        }
        ActionEvent actionEvent = new ActionEvent(ProjectUtilities.class, 1001, "command");
        try {
            action.actionPerformed(actionEvent);
            return true;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(16, (Throwable)exception);
            return false;
        }
    }

    static /* synthetic */ ExplorerManager.Provider access$000(String string) {
        return ProjectUtilities.findDefault(string);
    }
}

