/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.selectors;

import java.awt.Image;
import java.util.Collections;
import java.util.List;
import javax.swing.UIManager;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.ModuleSelector;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.WaitNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class RepositoryPathNode
extends AbstractNode {
    public static RepositoryPathNode create(Client.Factory factory, CVSRoot cVSRoot, String string) {
        String[] stringArray;
        assert (!string.startsWith("/")) : string;
        RepositoryPathChildren repositoryPathChildren = new RepositoryPathChildren(factory, cVSRoot, string);
        Lookup lookup = Lookups.singleton((Object)string);
        RepositoryPathNode repositoryPathNode = new RepositoryPathNode((Children)repositoryPathChildren, lookup);
        String string2 = cVSRoot.getRepository();
        if (!string.equals("") && (stringArray = string.split("/")).length > 0) {
            string2 = stringArray[stringArray.length - 1];
        }
        repositoryPathNode.setDisplayName(string2);
        return repositoryPathNode;
    }

    private RepositoryPathNode(Children children, Lookup lookup) {
        super(children, lookup);
        this.setIconBaseWithExtension("org/netbeans/modules/versioning/system/cvss/ui/selectors/defaultFolder.gif");
    }

    public Image getIcon(int n) {
        Image image = null;
        if (n == 1) {
            image = (Image)UIManager.get("Nb.Explorer.Folder.icon");
        }
        if (image == null) {
            image = super.getIcon(n);
        }
        return image;
    }

    public Image getOpenedIcon(int n) {
        Image image = null;
        if (n == 1) {
            image = (Image)UIManager.get("Nb.Explorer.Folder.openedIcon");
        }
        if (image == null) {
            image = super.getIcon(n);
        }
        return image;
    }

    static class RepositoryPathChildren
    extends Children.Keys
    implements Runnable {
        private final Client.Factory clientFactory;
        private final CVSRoot root;
        private final String path;
        private RequestProcessor.Task task;

        public RepositoryPathChildren(Client.Factory factory, CVSRoot cVSRoot, String string) {
            this.clientFactory = factory;
            this.root = cVSRoot;
            this.path = string;
        }

        protected void addNotify() {
            super.addNotify();
            WaitNode waitNode = new WaitNode(NbBundle.getMessage(RepositoryPathNode.class, (String)"BK2024"));
            this.setKeys(Collections.singleton(waitNode));
            RequestProcessor requestProcessor = RequestProcessor.getDefault();
            this.task = requestProcessor.post((Runnable)this);
        }

        protected void removeNotify() {
            this.task.cancel();
            this.setKeys(Collections.EMPTY_SET);
            super.removeNotify();
        }

        protected Node[] createNodes(Object object) {
            if (object instanceof Node) {
                return new Node[]{(Node)object};
            }
            String string = this.path.equals("") ? (String)object : this.path + "/" + object;
            RepositoryPathNode repositoryPathNode = RepositoryPathNode.create(this.clientFactory, this.root, string);
            return new Node[]{repositoryPathNode};
        }

        public void run() {
            try {
                List<String> list = ModuleSelector.listRepositoryPath(this.clientFactory.createClient(), this.root, this.path);
                this.setKeys(list);
            }
            catch (CommandException commandException) {
                this.setKeys(Collections.singleton(this.errorNode((Exception)((Object)commandException))));
            }
            catch (AuthenticationException authenticationException) {
                this.setKeys(Collections.singleton(this.errorNode((Exception)((Object)authenticationException))));
            }
        }

        private Node errorNode(Exception exception) {
            AbstractNode abstractNode = new AbstractNode(Children.LEAF);
            abstractNode.setDisplayName(NbBundle.getMessage(RepositoryPathNode.class, (String)"BK2025"));
            abstractNode.setShortDescription(exception.getLocalizedMessage());
            return abstractNode;
        }
    }
}

