/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.DiagramFontUtil;
import org.netbeans.modules.bpel.design.DiagramViewLayout;
import org.netbeans.modules.bpel.design.geometry.FDimension;
import org.openide.util.NbBundle;

public class ZoomManager
implements ActionListener {
    private int zoomValue = 100;
    private JButton fitDiagramButton;
    private JButton fitWidthButton;
    private JButton oneToOneButton;
    private JComboBox zoomChooser;
    private JButton zoomOutButton;
    private JButton zoomInButton;
    private JComponent[] components;
    private DesignView designView;
    private Action zoomInAction;
    private Action zoomOutAction;
    public static final int MIN_ZOOM_VALUE = 33;
    public static final int MAX_ZOOM_VALUE = 200;
    private static final String[] ZOOM_PRESETS = new String[]{"33%", "50%", "75%", "100%", "150%", "200%"};
    private static final Icon FIT_DIAGRAM_ICON = ZoomManager.loadIcon("fit_diagram.png");
    private static final Icon FIT_WIDTH_ICON = ZoomManager.loadIcon("fit_width.png");
    private static final Icon ONE_TO_ONE_ICON = ZoomManager.loadIcon("normal_size.png");
    private static final Icon ZOOM_IN_ICON = ZoomManager.loadIcon("zoom_in.png");
    private static final Icon ZOOM_OUT_ICON = ZoomManager.loadIcon("zoom_out.png");
    private static final int ZOOM_STEP_L100 = 5;
    private static final int ZOOM_STEP_G100 = 25;
    private static final String ZOOM_IN_KEY = "diagramZoomInAction";
    private static final String ZOOM_OUT_KEY = "diagramZoomOutAction";
    private static final KeyStroke ZOOM_IN_KEY_STROKE = KeyStroke.getKeyStroke(61, 128);
    private static final KeyStroke ZOOM_OUT_KEY_STROKE = KeyStroke.getKeyStroke(45, 128);

    public ZoomManager(DesignView designView) {
        this.designView = designView;
        this.fitDiagramButton = this.createButton(FIT_DIAGRAM_ICON, "LBL_ZoomPanel_FitDiagram");
        this.fitWidthButton = this.createButton(FIT_WIDTH_ICON, "LBL_ZoomPanel_FitWidth");
        this.oneToOneButton = this.createButton(ONE_TO_ONE_ICON, "LBL_ZoomPanel_OneToOne");
        this.zoomOutButton = this.createButton(ZOOM_OUT_ICON, "LBL_ZoomPanel_ZoomOut");
        this.zoomInButton = this.createButton(ZOOM_IN_ICON, "LBL_ZoomPanel_ZoomIn");
        this.zoomChooser = new JComboBox<String>(ZOOM_PRESETS);
        this.zoomChooser.setSelectedItem("100%");
        this.zoomChooser.setEditable(true);
        this.zoomChooser.addActionListener(this);
        this.zoomChooser.setToolTipText(ZoomManager.getMessage("LBL_ZoomPanel_ZoomValue"));
        ((JTextField)this.zoomChooser.getEditor().getEditorComponent()).setColumns(4);
        this.components = new JComponent[]{this.fitDiagramButton, this.fitWidthButton, this.oneToOneButton, this.zoomChooser, this.zoomOutButton, this.zoomInButton};
        this.zoomInAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ZoomManager.this.zoomIn();
            }
        };
        this.zoomOutAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ZoomManager.this.zoomOut();
            }
        };
        this.registerZoomInZoomOutActions(this.zoomChooser);
        this.registerZoomInZoomOutActions(designView);
    }

    public int getComponentCount() {
        return this.components.length;
    }

    public JComponent getComponent(int n) {
        return this.components[n];
    }

    public DesignView getDesignView() {
        return this.designView;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.fitWidthButton) {
            this.fitWidth();
        } else if (object == this.fitDiagramButton) {
            this.fitDiagram();
        } else if (object == this.oneToOneButton) {
            this.oneToOne();
        } else if (object == this.zoomInButton) {
            this.zoomIn();
        } else if (object == this.zoomOutButton) {
            this.zoomOut();
        } else if (object == this.zoomChooser) {
            String string = this.zoomChooser.getSelectedItem().toString().trim();
            if (string.endsWith("%")) {
                string = string.substring(0, string.length() - 1);
            }
            int n = this.zoomValue;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.setZoom(n);
        }
    }

    private void registerZoomInZoomOutActions(JComponent jComponent) {
        InputMap inputMap = jComponent.getInputMap(1);
        InputMap inputMap2 = jComponent.getInputMap(0);
        inputMap.put(ZOOM_IN_KEY_STROKE, ZOOM_IN_KEY);
        inputMap2.put(ZOOM_IN_KEY_STROKE, ZOOM_IN_KEY);
        inputMap.put(ZOOM_OUT_KEY_STROKE, ZOOM_OUT_KEY);
        inputMap2.put(ZOOM_OUT_KEY_STROKE, ZOOM_OUT_KEY);
        ActionMap actionMap = jComponent.getActionMap();
        actionMap.put(ZOOM_IN_KEY, this.zoomInAction);
        actionMap.put(ZOOM_OUT_KEY, this.zoomOutAction);
    }

    private Point getDefaultZoomPoint() {
        Rectangle rectangle = this.getDesignView().getVisibleRect();
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
    }

    public void fitWidth() {
        double d = DiagramFontUtil.getZoomCorrection();
        int n = this.designView.getWidth();
        n -= DiagramViewLayout.MARGIN_LEFT * 3;
        float f = this.getDesignView().getProcessView().getContentSize().width + this.getDesignView().getConsumersView().getContentSize().width + this.getDesignView().getProvidersView().getContentSize().width;
        double d2 = (double)(n -= DiagramViewLayout.MARGIN_RIGHT * 3) * 100.0 / (double)f / d;
        if (d2 != d2) {
            d2 = 100.0;
        } else if (d2 < 33.0) {
            d2 = 33.0;
        } else if (d2 > 200.0) {
            d2 = 200.0;
        }
        this.setZoom((int)d2);
    }

    public void fitDiagram() {
        double d = DiagramFontUtil.getZoomCorrection();
        JScrollPane jScrollPane = (JScrollPane)this.getDesignView().getProcessView().getParent().getParent();
        Dimension dimension = jScrollPane.getSize();
        Insets insets = jScrollPane.getInsets();
        FDimension fDimension = this.getDesignView().getDiagramSize();
        int n = dimension.width - insets.left - insets.right;
        n -= jScrollPane.getVerticalScrollBar().getWidth();
        n -= DiagramViewLayout.MARGIN_LEFT;
        int n2 = dimension.height - insets.top - insets.bottom;
        n2 -= jScrollPane.getHorizontalScrollBar().getHeight();
        n2 -= DiagramViewLayout.MARGIN_BOTTOM;
        double d2 = (double)(n -= DiagramViewLayout.MARGIN_RIGHT) * 100.0 / (double)fDimension.width / d;
        double d3 = (double)(n2 -= DiagramViewLayout.MARGIN_TOP) * 100.0 / (double)fDimension.height / d;
        double d4 = Math.min(d2, d3);
        if (d4 != d4) {
            d4 = 100.0;
        } else if (d4 < 33.0) {
            d4 = 33.0;
        } else if (d4 > 200.0) {
            d4 = 200.0;
        }
        this.setZoom((int)d4);
    }

    public void oneToOne() {
        this.setZoom(100);
    }

    public void zoomIn() {
        Point point = this.getDefaultZoomPoint();
        this.zoomIn(point.x, point.y);
    }

    public void zoomIn(int n, int n2) {
        int n3 = this.zoomValue >= 100 ? (this.zoomValue + 25) / 25 * 25 : (this.zoomValue + 5) / 5 * 5;
        this.setZoom(n3, n, n2);
    }

    public void zoomOut() {
        Point point = this.getDefaultZoomPoint();
        this.zoomOut(point.x, point.y);
    }

    public void zoomOut(int n, int n2) {
        int n3 = this.zoomValue > 100 ? (this.zoomValue - 1) / 25 * 25 : (this.zoomValue - 1) / 5 * 5;
        this.setZoom(n3, n, n2);
    }

    public void setZoom(int n) {
        Point point = this.getDefaultZoomPoint();
        this.setZoom(n, point.x, point.y);
    }

    public void setZoom(int n, int n2, int n3) {
        DesignView designView = this.getDesignView();
        if (n < 33) {
            n = 33;
        } else if (n > 200) {
            n = 200;
        }
        if (n != this.zoomValue) {
            this.zoomValue = n;
            designView.getProcessView().invalidate();
            designView.getConsumersView().invalidate();
            designView.getProvidersView().invalidate();
            designView.validate();
            designView.repaint();
            this.designView.getRightStripe().repaint();
        }
        this.updateComponentsStates();
    }

    private void updateComponentsStates() {
        this.zoomChooser.removeActionListener(this);
        this.zoomChooser.setSelectedItem(this.getZoomString());
        this.zoomChooser.addActionListener(this);
        this.zoomInButton.setEnabled(!this.isMaxZoom());
        this.zoomOutButton.setEnabled(!this.isMinZoom());
    }

    public void setEnabled(boolean bl) {
        this.fitWidthButton.setEnabled(bl);
        this.fitDiagramButton.setEnabled(bl);
        this.oneToOneButton.setEnabled(bl);
        this.zoomChooser.setEnabled(bl);
        this.zoomInButton.setEnabled(bl);
        this.zoomOutButton.setEnabled(bl);
        this.zoomInAction.setEnabled(bl);
        this.zoomOutAction.setEnabled(bl);
        if (bl) {
            this.updateComponentsStates();
        }
    }

    public int getZoom() {
        return this.zoomValue;
    }

    public String getZoomString() {
        return this.zoomValue + "%";
    }

    public double getScale() {
        return 0.01 * (double)this.zoomValue;
    }

    public boolean isMinZoom() {
        return this.zoomValue == 33;
    }

    public boolean isMaxZoom() {
        return this.zoomValue == 200;
    }

    private JButton createButton(Icon icon, String string) {
        JButton jButton = new JButton(icon);
        jButton.setToolTipText(ZoomManager.getMessage(string));
        jButton.addActionListener(this);
        return jButton;
    }

    private static String getMessage(String string) {
        return NbBundle.getBundle(ZoomManager.class).getString(string);
    }

    private static Icon loadIcon(String string) {
        return new ImageIcon(ZoomManager.class.getResource("resources/" + string));
    }
}

