/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.decoration;

import java.awt.Color;
import java.util.List;
import org.netbeans.modules.bpel.design.decoration.Descriptor;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StripeDescriptor
implements Descriptor {
    public final boolean selection;
    public final int errors;
    public final int warnings;
    public final int advices;
    public final int breakpoints;
    public static final Color WARNING_COLOR = new Color(14789120);
    public static final Color ERROR_COLOR = new Color(16722460);
    public static final Color ADVICE_COLOR = new Color(15321684);
    public static final Color BREAKPOINT_COLOR = new Color(16748501);
    public static final Color SELECTION_COLOR = new Color(12630147);
    public static final Color NO_ERRORS = new Color(0x65B56B);

    public StripeDescriptor() {
        this(false, 0, 0, 0, 0);
    }

    public StripeDescriptor(boolean bl, int n, int n2, int n3, int n4) {
        this.selection = bl;
        this.errors = n;
        this.warnings = n2;
        this.advices = n3;
        this.breakpoints = n4;
    }

    public Color getStatusColor() {
        if (this.errors > 0) {
            return ERROR_COLOR;
        }
        if (this.warnings > 0) {
            return WARNING_COLOR;
        }
        return NO_ERRORS;
    }

    public boolean isFilled() {
        return this.selection;
    }

    public Color getColor() {
        if (this.errors > 0) {
            return ERROR_COLOR;
        }
        if (this.breakpoints > 0) {
            return BREAKPOINT_COLOR;
        }
        if (this.warnings > 0) {
            return WARNING_COLOR;
        }
        if (this.advices > 0) {
            return ADVICE_COLOR;
        }
        if (this.selection) {
            return SELECTION_COLOR;
        }
        return null;
    }

    public String getStatusText() {
        return this.errors + this.advices + this.warnings > 0 ? this.getText(false, false) : this.getMessage("LBL_NoErrors");
    }

    public String getText() {
        return this.getText(true, true);
    }

    public String getText(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer("<html><body>");
        boolean bl3 = false;
        if (this.errors > 0) {
            if (this.errors == 1) {
                stringBuffer.append(this.getMessage("LBL_Error"));
            } else {
                stringBuffer.append(this.errors);
                stringBuffer.append(" ");
                stringBuffer.append(this.getMessage("LBL_Errors"));
            }
            stringBuffer.append("<br>");
            bl3 = true;
        }
        if (this.warnings > 0) {
            if (this.warnings == 1) {
                stringBuffer.append(this.getMessage("LBL_Warning"));
            } else {
                stringBuffer.append(this.warnings);
                stringBuffer.append(" ");
                stringBuffer.append(this.getMessage("LBL_Warnings"));
            }
            stringBuffer.append("<br>");
            bl3 = true;
        }
        if (this.advices > 0) {
            if (this.advices == 1) {
                stringBuffer.append(this.getMessage("LBL_Advice"));
            } else {
                stringBuffer.append(this.advices);
                stringBuffer.append(" ");
                stringBuffer.append(this.getMessage("LBL_Advices"));
            }
            stringBuffer.append("<br>");
            bl3 = true;
        }
        if (bl && this.breakpoints > 0) {
            if (this.breakpoints == 1) {
                stringBuffer.append(this.getMessage("LBL_Breakpoint"));
            } else {
                stringBuffer.append(this.breakpoints);
                stringBuffer.append(" ");
                stringBuffer.append(this.getMessage("LBL_Breakpoints"));
            }
            stringBuffer.append("<br>");
            bl3 = true;
        }
        if (bl2 && this.selection) {
            stringBuffer.append(this.getMessage("LBL_Selection"));
            bl3 = true;
        }
        stringBuffer.append("</body></html>");
        return bl3 ? stringBuffer.toString() : null;
    }

    private String getMessage(String string) {
        return NbBundle.getMessage(StripeDescriptor.class, (String)string);
    }

    public static StripeDescriptor createSelection() {
        return new StripeDescriptor(true, 0, 0, 0, 0);
    }

    public static StripeDescriptor createBreakpoint() {
        return new StripeDescriptor(false, 0, 0, 0, 1);
    }

    public static StripeDescriptor createValidation(List<Validator.ResultItem> list) {
        if (list == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (Validator.ResultItem resultItem : list) {
            switch (resultItem.getType()) {
                case ERROR: {
                    ++n;
                    break;
                }
                case WARNING: {
                    ++n2;
                    break;
                }
                case ADVICE: {
                    ++n3;
                }
            }
        }
        if (n2 + n + n3 == 0) {
            return null;
        }
        return new StripeDescriptor(false, n, n2, n3, 0);
    }

    public static StripeDescriptor merge(StripeDescriptor stripeDescriptor, StripeDescriptor stripeDescriptor2) {
        if (stripeDescriptor2 == null) {
            return stripeDescriptor;
        }
        if (stripeDescriptor == null) {
            return stripeDescriptor2;
        }
        return new StripeDescriptor(stripeDescriptor.selection || stripeDescriptor2.selection, stripeDescriptor.errors + stripeDescriptor2.errors, stripeDescriptor.warnings + stripeDescriptor2.warnings, stripeDescriptor.advices + stripeDescriptor2.advices, stripeDescriptor.breakpoints + stripeDescriptor2.breakpoints);
    }
}

