/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.decoration.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import org.netbeans.modules.bpel.design.decoration.components.ButtonRenderer;
import org.netbeans.modules.bpel.design.decoration.components.DecorationComponent;

public class ContextToolBarButton
extends JButton
implements DecorationComponent {
    private Icon icon;
    private Icon disabledIcon;
    private Color fillColor = null;
    private Color disabledFillColor = null;

    public ContextToolBarButton(Action action) {
        this(action, ButtonRenderer.NORMAL_FILL_COLOR, ButtonRenderer.DISABLED_FILL_COLOR);
    }

    public ContextToolBarButton(Action action, Color color) {
        this(action, color, color);
    }

    public ContextToolBarButton(Action action, Color color, Color color2) {
        super(action);
        this.setText(null);
        this.setOpaque(false);
        this.setBorder(null);
        this.setRolloverEnabled(true);
        this.setContentAreaFilled(false);
        this.setFocusable(false);
        this.icon = (Icon)action.getValue("SmallIcon");
        this.disabledIcon = ButtonRenderer.createDisabledIcon(this, this.icon);
        this.fillColor = color;
        this.disabledFillColor = color2;
        this.setPreferredSize(new Dimension(this.icon.getIconWidth() + 6, this.icon.getIconHeight() + 6));
    }

    public ContextToolBarButton(Icon icon) {
        this.setOpaque(false);
        this.setBorder(null);
        this.setRolloverEnabled(true);
        this.setContentAreaFilled(false);
        this.setFocusable(false);
        this.setPreferredSize(new Dimension(icon.getIconWidth() + 6, icon.getIconHeight() + 6));
        this.icon = icon;
        this.disabledIcon = ButtonRenderer.createDisabledIcon(this, icon);
        this.fillColor = ButtonRenderer.NORMAL_FILL_COLOR;
        this.disabledFillColor = ButtonRenderer.DISABLED_FILL_COLOR;
    }

    protected void paintComponent(Graphics graphics) {
        ButtonModel buttonModel = this.getModel();
        if (!buttonModel.isEnabled()) {
            ButtonRenderer.paintButton(this, graphics, this.disabledFillColor, false, ButtonRenderer.DISABLED_BORDER_COLOR, 1.0f, this.disabledIcon);
        } else if (buttonModel.isPressed()) {
            ButtonRenderer.paintButton(this, graphics, ButtonRenderer.PRESSED_FILL_COLOR, false, ButtonRenderer.PRESSED_BORDER_COLOR, 1.3f, this.icon);
        } else if (buttonModel.isRollover()) {
            ButtonRenderer.paintButton(this, graphics, ButtonRenderer.ROLLOVER_FILL_COLOR, true, ButtonRenderer.ROLLOVER_BORDER_COLOR, 1.0f, this.icon);
        } else {
            ButtonRenderer.paintButton(this, graphics, this.fillColor, false, ButtonRenderer.NORMAL_BORDER_COLOR, 1.0f, this.icon);
        }
    }
}

