/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.model;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.model.ModelChangeHandler;
import org.netbeans.modules.bpel.design.model.PartnerRole;
import org.netbeans.modules.bpel.design.model.ViewFilters;
import org.netbeans.modules.bpel.design.model.patterns.AssignPattern;
import org.netbeans.modules.bpel.design.model.patterns.CatchAllPattern;
import org.netbeans.modules.bpel.design.model.patterns.CatchPattern;
import org.netbeans.modules.bpel.design.model.patterns.CollapsedPattern;
import org.netbeans.modules.bpel.design.model.patterns.CompensatePattern;
import org.netbeans.modules.bpel.design.model.patterns.CompensateScopePattern;
import org.netbeans.modules.bpel.design.model.patterns.CompensationHandlerPattern;
import org.netbeans.modules.bpel.design.model.patterns.ElseIfPattern;
import org.netbeans.modules.bpel.design.model.patterns.ElsePattern;
import org.netbeans.modules.bpel.design.model.patterns.EmptyPattern;
import org.netbeans.modules.bpel.design.model.patterns.EventHandlersPattern;
import org.netbeans.modules.bpel.design.model.patterns.ExitPattern;
import org.netbeans.modules.bpel.design.model.patterns.FaultHandlersPattern;
import org.netbeans.modules.bpel.design.model.patterns.FlowPattern;
import org.netbeans.modules.bpel.design.model.patterns.ForEachPattern;
import org.netbeans.modules.bpel.design.model.patterns.IfPattern;
import org.netbeans.modules.bpel.design.model.patterns.ImportPattern;
import org.netbeans.modules.bpel.design.model.patterns.InvokePattern;
import org.netbeans.modules.bpel.design.model.patterns.OnAlarmEventPattern;
import org.netbeans.modules.bpel.design.model.patterns.OnAlarmPickPattern;
import org.netbeans.modules.bpel.design.model.patterns.OnEventPattern;
import org.netbeans.modules.bpel.design.model.patterns.OnMessagePattern;
import org.netbeans.modules.bpel.design.model.patterns.PartnerLinksPattern;
import org.netbeans.modules.bpel.design.model.patterns.PartnerlinkPattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.model.patterns.PickPattern;
import org.netbeans.modules.bpel.design.model.patterns.ProcessPattern;
import org.netbeans.modules.bpel.design.model.patterns.ReThrowPattern;
import org.netbeans.modules.bpel.design.model.patterns.ReceivePattern;
import org.netbeans.modules.bpel.design.model.patterns.RepeatUntilPattern;
import org.netbeans.modules.bpel.design.model.patterns.ReplyPattern;
import org.netbeans.modules.bpel.design.model.patterns.ScopePattern;
import org.netbeans.modules.bpel.design.model.patterns.SequencePattern;
import org.netbeans.modules.bpel.design.model.patterns.TerminationHandlerPattern;
import org.netbeans.modules.bpel.design.model.patterns.ThrowPattern;
import org.netbeans.modules.bpel.design.model.patterns.UnsupportedPattern;
import org.netbeans.modules.bpel.design.model.patterns.WaitPattern;
import org.netbeans.modules.bpel.design.model.patterns.WhilePattern;
import org.netbeans.modules.bpel.model.api.Activity;
import org.netbeans.modules.bpel.model.api.Assign;
import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Catch;
import org.netbeans.modules.bpel.model.api.CompensatableActivityHolder;
import org.netbeans.modules.bpel.model.api.Compensate;
import org.netbeans.modules.bpel.model.api.CompensateScope;
import org.netbeans.modules.bpel.model.api.CompensationHandler;
import org.netbeans.modules.bpel.model.api.Else;
import org.netbeans.modules.bpel.model.api.ElseIf;
import org.netbeans.modules.bpel.model.api.Empty;
import org.netbeans.modules.bpel.model.api.EventHandlers;
import org.netbeans.modules.bpel.model.api.Exit;
import org.netbeans.modules.bpel.model.api.FaultHandlers;
import org.netbeans.modules.bpel.model.api.Flow;
import org.netbeans.modules.bpel.model.api.ForEach;
import org.netbeans.modules.bpel.model.api.If;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.Invoke;
import org.netbeans.modules.bpel.model.api.OnAlarmEvent;
import org.netbeans.modules.bpel.model.api.OnAlarmPick;
import org.netbeans.modules.bpel.model.api.OnEvent;
import org.netbeans.modules.bpel.model.api.OnMessage;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.PartnerLinkContainer;
import org.netbeans.modules.bpel.model.api.Pick;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.ReThrow;
import org.netbeans.modules.bpel.model.api.Receive;
import org.netbeans.modules.bpel.model.api.RepeatUntil;
import org.netbeans.modules.bpel.model.api.Reply;
import org.netbeans.modules.bpel.model.api.Scope;
import org.netbeans.modules.bpel.model.api.Sequence;
import org.netbeans.modules.bpel.model.api.TerminationHandler;
import org.netbeans.modules.bpel.model.api.Throw;
import org.netbeans.modules.bpel.model.api.Wait;
import org.netbeans.modules.bpel.model.api.While;
import org.netbeans.modules.bpel.model.api.events.ChangeEventListener;
import org.netbeans.modules.bpel.model.api.support.UniqueId;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ui.XAMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramModel {
    private DesignView view;
    private Pattern rootPattern;
    private ModelChangeHandler changeHandler;
    private Object patternKey = new Object();
    private Object collapsedKey = new Object();
    private ViewFilters filters = new ViewFilters();
    private BpelModel bpelModel;
    private static final Object VALUE_COLLAPSED = new Object();
    private static Object LAST_USED_COLLAPSED_KEY = null;

    public DiagramModel(DesignView designView) {
        this.view = designView;
        this.changeHandler = new ModelChangeHandler(this);
        this.bpelModel = designView.getBPELModel();
        if (LAST_USED_COLLAPSED_KEY != null) {
            DiagramModel.copyCollapsedState((BpelEntity)this.bpelModel.getProcess(), LAST_USED_COLLAPSED_KEY, this.collapsedKey);
        }
        BpelModel bpelModel = designView.getBPELModel();
        bpelModel.addEntityChangeListener((ChangeEventListener)this.changeHandler);
    }

    public Pattern getRootPattern() {
        return this.rootPattern;
    }

    public void setActivated() {
        LAST_USED_COLLAPSED_KEY = this.collapsedKey;
    }

    public static boolean isVisualizable(BpelEntity bpelEntity) {
        return bpelEntity instanceof Process || bpelEntity instanceof Sequence || bpelEntity instanceof If || bpelEntity instanceof ElseIf || bpelEntity instanceof Else || bpelEntity instanceof ForEach || bpelEntity instanceof Assign || bpelEntity instanceof Receive || bpelEntity instanceof Reply || bpelEntity instanceof Invoke || bpelEntity instanceof Flow || bpelEntity instanceof While || bpelEntity instanceof RepeatUntil || bpelEntity instanceof Wait || bpelEntity instanceof Exit || bpelEntity instanceof Throw || bpelEntity instanceof Scope || bpelEntity instanceof Pick || bpelEntity instanceof OnMessage || bpelEntity instanceof OnEvent || bpelEntity instanceof OnAlarmPick || bpelEntity instanceof Empty || bpelEntity instanceof OnAlarmEvent || bpelEntity instanceof CompensationHandler || bpelEntity instanceof TerminationHandler || bpelEntity instanceof Compensate || bpelEntity instanceof EventHandlers || bpelEntity instanceof FaultHandlers || bpelEntity instanceof Catch || bpelEntity instanceof CompensatableActivityHolder || bpelEntity instanceof Activity || bpelEntity instanceof PartnerLink || bpelEntity instanceof Import || bpelEntity instanceof PartnerLinkContainer;
    }

    public Pattern createPattern(BpelEntity bpelEntity) {
        Pattern pattern = null;
        if (this.isCollapsed(bpelEntity)) {
            pattern = bpelEntity instanceof PartnerLink ? new PartnerlinkPattern(this, true) : new CollapsedPattern(this);
        } else if (bpelEntity instanceof Process) {
            pattern = new ProcessPattern(this);
        } else if (bpelEntity instanceof Sequence) {
            pattern = new SequencePattern(this);
        } else if (bpelEntity instanceof If) {
            pattern = new IfPattern(this);
        } else if (bpelEntity instanceof ElseIf) {
            pattern = new ElseIfPattern(this);
        } else if (bpelEntity instanceof Else) {
            pattern = new ElsePattern(this);
        } else if (bpelEntity instanceof ForEach) {
            pattern = new ForEachPattern(this);
        } else if (bpelEntity instanceof Assign) {
            pattern = new AssignPattern(this);
        } else if (bpelEntity instanceof Receive) {
            pattern = new ReceivePattern(this);
        } else if (bpelEntity instanceof Reply) {
            pattern = new ReplyPattern(this);
        } else if (bpelEntity instanceof Invoke) {
            pattern = new InvokePattern(this);
        } else if (bpelEntity instanceof Flow) {
            pattern = new FlowPattern(this);
        } else if (bpelEntity instanceof While) {
            pattern = new WhilePattern(this);
        } else if (bpelEntity instanceof RepeatUntil) {
            pattern = new RepeatUntilPattern(this);
        } else if (bpelEntity instanceof Wait) {
            pattern = new WaitPattern(this);
        } else if (bpelEntity instanceof Exit) {
            pattern = new ExitPattern(this);
        } else if (bpelEntity instanceof Throw) {
            pattern = new ThrowPattern(this);
        } else if (bpelEntity instanceof ReThrow) {
            pattern = new ReThrowPattern(this);
        } else if (bpelEntity instanceof Scope) {
            pattern = new ScopePattern(this);
        } else if (bpelEntity instanceof Pick) {
            pattern = new PickPattern(this);
        } else if (bpelEntity instanceof OnMessage) {
            pattern = new OnMessagePattern(this);
        } else if (bpelEntity instanceof OnEvent) {
            pattern = new OnEventPattern(this);
        } else if (bpelEntity instanceof OnAlarmPick) {
            pattern = new OnAlarmPickPattern(this);
        } else if (bpelEntity instanceof Empty) {
            pattern = new EmptyPattern(this);
        } else if (bpelEntity instanceof OnAlarmEvent) {
            pattern = new OnAlarmEventPattern(this);
        } else if (bpelEntity instanceof CompensationHandler) {
            pattern = new CompensationHandlerPattern(this);
        } else if (bpelEntity instanceof TerminationHandler) {
            pattern = new TerminationHandlerPattern(this);
        } else if (bpelEntity instanceof Compensate) {
            pattern = new CompensatePattern(this);
        } else if (bpelEntity instanceof CompensateScope) {
            pattern = new CompensateScopePattern(this);
        } else if (bpelEntity instanceof EventHandlers) {
            pattern = new EventHandlersPattern(this);
        } else if (bpelEntity instanceof FaultHandlers) {
            pattern = new FaultHandlersPattern(this);
        } else if (bpelEntity instanceof Catch) {
            pattern = new CatchPattern(this);
        } else if (bpelEntity instanceof CompensatableActivityHolder) {
            pattern = new CatchAllPattern(this);
        } else if (bpelEntity instanceof Activity) {
            pattern = new UnsupportedPattern(this);
        } else if (bpelEntity instanceof PartnerLink) {
            pattern = new PartnerlinkPattern(this);
        } else if (bpelEntity instanceof Import) {
            pattern = new ImportPattern(this);
        } else if (bpelEntity instanceof PartnerLinkContainer) {
            pattern = new PartnerLinksPattern(this);
        } else {
            return null;
        }
        bpelEntity.setCookie(this.patternKey, (Object)pattern);
        pattern.initPattern(bpelEntity);
        assert (pattern != null);
        return pattern;
    }

    public DesignView getView() {
        return this.view;
    }

    public List<Pattern> getPartnerLinks(PartnerRole partnerRole) {
        PartnerLinksPattern partnerLinksPattern;
        PartnerLinkContainer partnerLinkContainer;
        Process process = this.view.getBPELModel().getProcess();
        if (process != null && (partnerLinkContainer = process.getPartnerLinkContainer()) != null && (partnerLinksPattern = (PartnerLinksPattern)this.getPattern((BpelEntity)partnerLinkContainer)) != null) {
            return partnerRole == PartnerRole.CONSUMER ? partnerLinksPattern.getConsumers() : partnerLinksPattern.getProviders();
        }
        return new ArrayList<Pattern>();
    }

    public void expandToBeVisible(BpelEntity bpelEntity) {
        while (bpelEntity != null && !DiagramModel.isVisualizable(bpelEntity)) {
            bpelEntity = bpelEntity.getParent();
        }
        if (bpelEntity == null) {
            return;
        }
        boolean bl = false;
        for (BpelContainer bpelContainer = bpelEntity.getParent(); bpelContainer != null; bpelContainer = bpelContainer.getParent()) {
            if (bpelContainer.getCookie(this.collapsedKey) == null) continue;
            bpelContainer.removeCookie(this.collapsedKey);
            bl = true;
        }
        if (bl) {
            this.view.reloadModel();
            this.view.diagramChanged();
            this.view.getDecorationManager().decorationChanged();
            this.view.getValidationDecorationProvider().updateDecorations();
        }
    }

    public void expandAll() {
        this.expandAll((BpelEntity)this.bpelModel.getProcess());
    }

    public void expandAll(BpelEntity bpelEntity) {
        if (this.expandRecursively(bpelEntity)) {
            this.view.reloadModel();
            this.view.diagramChanged();
            this.view.getDecorationManager().decorationChanged();
            this.view.getValidationDecorationProvider().updateDecorations();
        }
    }

    private boolean expandRecursively(BpelEntity bpelEntity) {
        if (bpelEntity == null) {
            return false;
        }
        boolean bl = false;
        List list = bpelEntity.getChildren();
        if (list != null) {
            for (BpelEntity bpelEntity2 : list) {
                bl = this.expandRecursively(bpelEntity2) || bl;
            }
        }
        if (bpelEntity.getCookie(this.collapsedKey) != null) {
            bpelEntity.removeCookie(this.collapsedKey);
            bl = true;
        }
        return bl;
    }

    public void setCollapsed(BpelEntity bpelEntity, boolean bl) {
        if (bl) {
            bpelEntity.setCookie(this.collapsedKey, VALUE_COLLAPSED);
        } else if (bpelEntity.getCookie(this.collapsedKey) != null) {
            bpelEntity.removeCookie(this.collapsedKey);
        }
        this.view.reloadModel();
        this.view.diagramChanged();
        this.view.getDecorationManager().decorationChanged();
        this.view.getValidationDecorationProvider().updateDecorations();
    }

    public boolean isCollapsed(BpelEntity bpelEntity) {
        Object object = bpelEntity.getCookie(this.collapsedKey);
        return object != null;
    }

    public Pattern getPattern(BpelEntity bpelEntity) {
        assert (bpelEntity != null);
        return (Pattern)bpelEntity.getCookie(this.patternKey);
    }

    public ViewFilters getFilters() {
        return this.filters;
    }

    public void release() {
        this.bpelModel.removeEntityChangeListener((ChangeEventListener)this.changeHandler);
        this.patternKey = null;
        this.collapsedKey = null;
        this.view = null;
        this.rootPattern = null;
    }

    public boolean isReadOnly() {
        return !XAMUtils.isWritable((Model)this.bpelModel);
    }

    public void setRootPattern(Pattern pattern) {
        this.rootPattern = pattern;
    }

    public BpelEntity getEntity(UniqueId uniqueId) {
        return uniqueId != null ? this.bpelModel.getEntity(uniqueId) : null;
    }

    private static void copyCollapsedState(BpelEntity bpelEntity, Object object, Object object2) {
        List list;
        if (bpelEntity == null) {
            return;
        }
        Object object3 = bpelEntity.getCookie(object);
        if (object3 != null) {
            bpelEntity.setCookie(object2, object3);
        }
        if ((list = bpelEntity.getChildren()) != null) {
            for (BpelEntity bpelEntity2 : list) {
                DiagramModel.copyCollapsedState(bpelEntity2, object, object2);
            }
        }
    }
}

