/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.model;

import java.util.List;
import org.netbeans.modules.bpel.design.model.DiagramModel;
import org.netbeans.modules.bpel.design.model.DiagramModelIterator;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.selection.EntitySelectionModel;

public class DiagramModelHierarchyIterator
implements DiagramModelIterator {
    private DiagramModel model;
    private EntitySelectionModel selectionModel;

    public DiagramModelHierarchyIterator(DiagramModel diagramModel, EntitySelectionModel entitySelectionModel) {
        assert (diagramModel != null && entitySelectionModel != null);
        this.model = diagramModel;
        this.selectionModel = entitySelectionModel;
    }

    public Pattern next() {
        Pattern pattern = this.selectionModel.getSelectedPattern();
        if (pattern == null) {
            return null;
        }
        Pattern pattern2 = null;
        if (pattern instanceof CompositePattern && !this.model.isCollapsed(pattern.getOMReference())) {
            pattern2 = this.getNextNestedPattern((CompositePattern)pattern);
        }
        if (pattern2 == null) {
            pattern2 = this.getNextParentPattern(pattern);
        }
        return pattern2;
    }

    public Pattern previous() {
        Pattern pattern = this.selectionModel.getSelectedPattern();
        if (pattern == null) {
            return null;
        }
        return this.getPrevParentPattern(pattern);
    }

    private Pattern getPrevNestedPattern(CompositePattern compositePattern) {
        if (compositePattern == null) {
            return null;
        }
        Pattern pattern = null;
        List<Pattern> list = compositePattern.getNestedPatterns();
        if (list == null) {
            return compositePattern;
        }
        int n = list.size();
        for (int i = n - 1; i >= 0; --i) {
            Pattern pattern2 = list.get(i);
            if (pattern2.isSelectable()) {
                pattern = pattern2;
            }
            if (pattern2 instanceof CompositePattern && (pattern2 = this.getPrevNestedPattern((CompositePattern)pattern2)) != null && pattern2.isSelectable()) {
                pattern = pattern2;
            }
            if (pattern != null) break;
        }
        return pattern == null ? compositePattern : pattern;
    }

    private Pattern getNextNestedPattern(CompositePattern compositePattern) {
        if (compositePattern == null) {
            return null;
        }
        Pattern pattern = null;
        List<Pattern> list = compositePattern.getNestedPatterns();
        for (Pattern pattern2 : list) {
            if (!pattern2.isSelectable()) continue;
            pattern = pattern2;
            break;
        }
        return pattern;
    }

    private Pattern getPrevParentPattern(Pattern pattern) {
        if (pattern == null) {
            return pattern;
        }
        Pattern pattern2 = null;
        CompositePattern compositePattern = pattern.getParent();
        if (compositePattern == null) {
            Pattern pattern3 = pattern.getModel().getRootPattern();
            return pattern3 instanceof CompositePattern ? this.getPrevNestedPattern((CompositePattern)pattern3) : pattern3;
        }
        List<Pattern> list = compositePattern.getNestedPatterns();
        int n = list.indexOf(pattern);
        assert (n > -1);
        for (int i = n - 1; i >= 0; --i) {
            Pattern pattern4 = list.get(i);
            if (pattern4.isSelectable()) {
                pattern2 = pattern4;
            }
            if (pattern4 instanceof CompositePattern && (pattern4 = this.getPrevNestedPattern((CompositePattern)pattern4)) != null && pattern4.isSelectable()) {
                pattern2 = pattern4;
            }
            if (pattern2 != null) break;
        }
        if (pattern2 == null && !compositePattern.isSelectable()) {
            pattern2 = this.getPrevParentPattern(compositePattern);
        }
        return pattern2 == null ? compositePattern : pattern2;
    }

    private Pattern getNextParentPattern(Pattern pattern) {
        if (pattern == null) {
            return pattern;
        }
        Pattern pattern2 = null;
        CompositePattern compositePattern = pattern.getParent();
        if (compositePattern == null) {
            return pattern.getModel().getRootPattern();
        }
        List<Pattern> list = compositePattern.getNestedPatterns();
        int n = list.indexOf(pattern);
        assert (n > -1);
        for (int i = n + 1; i < list.size(); ++i) {
            Pattern pattern3 = list.get(i);
            if (pattern3.isSelectable()) {
                pattern2 = pattern3;
            } else if (!pattern3.isSelectable() && pattern3 instanceof CompositePattern) {
                pattern2 = this.getNextNestedPattern((CompositePattern)pattern3);
            }
            if (pattern2 != null) break;
        }
        return pattern2 == null ? this.getNextParentPattern(compositePattern) : pattern2;
    }
}

