/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.model;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.netbeans.modules.bpel.design.model.DiagramModel;
import org.netbeans.modules.bpel.design.model.PartnerRole;
import org.netbeans.modules.bpel.design.model.connections.Connection;
import org.netbeans.modules.bpel.design.model.connections.Direction;
import org.netbeans.modules.bpel.design.model.connections.MessageConnection;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.CollapsedPattern;
import org.netbeans.modules.bpel.design.model.patterns.PartnerlinkPattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.OnEvent;
import org.netbeans.modules.bpel.model.api.OnMessage;
import org.netbeans.modules.bpel.model.api.OperationReference;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.PartnerLinkReference;
import org.netbeans.modules.bpel.model.api.Receive;
import org.netbeans.modules.bpel.model.api.references.BpelReference;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.xml.retriever.Retriever;
import org.netbeans.modules.xml.retriever.catalog.CatalogEntry;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModel;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModelFactory;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.Types;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPAddress;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.Referenceable;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public class PartnerLinkHelper {
    private DiagramModel model;
    private static final String PARTNERS_FOLDER = "Partners";

    public PartnerLinkHelper(DiagramModel diagramModel) {
        this.model = diagramModel;
    }

    public void updateMessageFlowLinks(CollapsedPattern collapsedPattern) {
        VisualElement visualElement = collapsedPattern.getFirstElement();
        List<Connection> list = visualElement.getAllConnections();
        for (Connection connection : list) {
            if (!(connection instanceof MessageConnection)) continue;
            connection.remove();
        }
        this.updateMessageFlowLinks(collapsedPattern.getOMReference(), visualElement);
    }

    private void updateMessageFlowLinks(BpelEntity bpelEntity, VisualElement visualElement) {
        if (bpelEntity instanceof OperationReference && bpelEntity instanceof PartnerLinkReference) {
            List<Connection> list = visualElement.getAllConnections();
            VisualElement visualElement2 = this.getOperation(bpelEntity);
            if (visualElement2 != null) {
                MessageConnection messageConnection = new MessageConnection(visualElement.getPattern());
                this.connect(messageConnection, visualElement, visualElement2);
            }
        } else {
            List list = bpelEntity.getChildren();
            if (list != null) {
                for (BpelEntity bpelEntity2 : list) {
                    this.updateMessageFlowLinks(bpelEntity2, visualElement);
                }
            }
        }
    }

    private void connect(Connection connection, VisualElement visualElement, VisualElement visualElement2) {
        boolean bl;
        Pattern pattern = visualElement2.getPattern();
        boolean bl2 = ((PartnerlinkPattern)pattern).getType() == PartnerRole.CONSUMER;
        BpelEntity bpelEntity = visualElement.getPattern().getOMReference();
        boolean bl3 = bl = bpelEntity instanceof OnMessage || bpelEntity instanceof OnEvent || bpelEntity instanceof Receive;
        if (bl2) {
            connection.connect(bl ? visualElement2 : visualElement, bl ? Direction.RIGHT : Direction.LEFT, bl ? visualElement : visualElement2, bl ? Direction.LEFT : Direction.RIGHT);
        } else {
            connection.connect(bl ? visualElement2 : visualElement, bl ? Direction.LEFT : Direction.RIGHT, bl ? visualElement : visualElement2, bl ? Direction.RIGHT : Direction.LEFT);
        }
    }

    public void updateMessageFlowLinks(Pattern pattern) {
        BpelEntity bpelEntity = pattern.getOMReference();
        if (bpelEntity instanceof OperationReference && bpelEntity instanceof PartnerLinkReference) {
            VisualElement visualElement = pattern.getFirstElement();
            List<Connection> list = visualElement.getAllConnections();
            for (Connection connection : list) {
                if (!(connection instanceof MessageConnection)) continue;
                connection.remove();
            }
            VisualElement visualElement2 = this.getOperation(bpelEntity);
            if (visualElement2 != null) {
                Connection connection;
                connection = new MessageConnection(pattern);
                this.connect(connection, pattern.getFirstElement(), visualElement2);
            }
        }
    }

    private VisualElement getOperation(BpelEntity bpelEntity) {
        assert (bpelEntity instanceof OperationReference);
        assert (bpelEntity instanceof PartnerLinkReference);
        WSDLReference wSDLReference = ((OperationReference)bpelEntity).getOperation();
        if (wSDLReference == null) {
            return null;
        }
        BpelReference bpelReference = ((PartnerLinkReference)bpelEntity).getPartnerLink();
        if (bpelReference == null) {
            return null;
        }
        PartnerLink partnerLink = (PartnerLink)bpelReference.get();
        if (partnerLink == null) {
            return null;
        }
        Pattern pattern = this.model.getPattern((BpelEntity)partnerLink);
        if (pattern == null) {
            return null;
        }
        if (this.model.isCollapsed(pattern.getOMReference())) {
            return pattern.getFirstElement();
        }
        return ((PartnerlinkPattern)pattern).getElement((WSDLReference<Operation>)wSDLReference);
    }

    public PartnerLink createPartnerLink(DataObject dataObject) {
        try {
            FileObject fileObject = dataObject.getPrimaryFile();
            if (fileObject == null) {
                return null;
            }
            URI uRI = fileObject.getURL().toURI();
            final String string = fileObject.getName();
            WSDLModel wSDLModel = this.model.getView().getProcessHelper().getWSDLModelFromUri(uRI);
            if (wSDLModel == null) {
                return null;
            }
            final List list = wSDLModel.getDefinitions().getExtensibilityElements(PartnerLinkType.class);
            if (list == null || list.size() == 0) {
                return null;
            }
            final BpelModel bpelModel = this.model.getView().getBPELModel();
            assert (bpelModel != null) : "Broken WSDL model";
            Callable<PartnerLink> callable = new Callable<PartnerLink>(){

                @Override
                public PartnerLink call() throws Exception {
                    PartnerLink partnerLink = bpelModel.getBuilder().createPartnerLink();
                    partnerLink.setName(string);
                    partnerLink.setPartnerLinkType(partnerLink.createWSDLReference((ReferenceableWSDLComponent)list.get(0), PartnerLinkType.class));
                    return partnerLink;
                }
            };
            return (PartnerLink)bpelModel.invoke((Callable)callable, (Object)this);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
            return null;
        }
    }

    public PartnerLink createPartnerLink() {
        return this.model.getView().getBPELModel().getBuilder().createPartnerLink();
    }

    private boolean isServiceRole(Role role) {
        if (role == null || role.getPortType() == null) {
            return false;
        }
        PortType portType = (PortType)role.getPortType().get();
        if (portType == null) {
            return false;
        }
        WSDLModel wSDLModel = portType.getModel();
        Collection collection = wSDLModel.getDefinitions().getServices();
        if (collection == null) {
            return false;
        }
        for (Service service : collection) {
            for (Port port : service.getPorts()) {
                PortType portType2;
                Binding binding = (Binding)port.getBinding().get();
                if (binding == null || (portType2 = (PortType)binding.getType().get()) == null || !portType.equals(portType2)) continue;
                return true;
            }
        }
        return false;
    }

    public static void saveModel(Model model) {
        SaveCookie saveCookie;
        DataObject dataObject = (DataObject)model.getModelSource().getLookup().lookup(DataObject.class);
        if (dataObject != null && (saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) != null) {
            try {
                saveCookie.save();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
    }

    public FileObject retrieveWSDL(URL uRL, String string, boolean bl) {
        FileObject fileObject;
        FileObject fileObject2 = (FileObject)this.model.getView().getBPELModel().getModelSource().getLookup().lookup(FileObject.class);
        if (fileObject2 == null) {
            return null;
        }
        FileObject fileObject3 = fileObject2.getParent();
        FileObject fileObject4 = fileObject3.getFileObject(PARTNERS_FOLDER);
        if (fileObject4 == null) {
            try {
                fileObject4 = fileObject3.createFolder(PARTNERS_FOLDER);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if ((fileObject = fileObject4.getFileObject(string)) == null) {
            try {
                fileObject = fileObject4.createFolder(string);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        FileObject fileObject5 = null;
        try {
            Retriever retriever = Retriever.getDefault();
            retriever.setOverwriteFilesWithSameName(true);
            FileObject fileObject6 = fileObject5 = bl ? retriever.retrieveResourceClosureIntoSingleDirectory(fileObject, uRL.toURI()) : retriever.retrieveResource(fileObject, uRL.toURI());
            if (fileObject5 == null) {
                return null;
            }
            WSDLModel wSDLModel = PartnerLinkHelper.getWSDLModel(fileObject5);
            wSDLModel.sync();
            if (wSDLModel != null) {
                this.fixSoapAddress(wSDLModel, bl);
            }
        }
        catch (UnknownHostException unknownHostException) {
            ErrorManager.getDefault().notify(1, (Throwable)unknownHostException);
        }
        catch (URISyntaxException uRISyntaxException) {
            ErrorManager.getDefault().notify(1, (Throwable)uRISyntaxException);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        return fileObject5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixSoapAddress(WSDLModel wSDLModel, boolean bl) {
        Object object;
        Object object2;
        Collection collection;
        Definitions definitions = wSDLModel.getDefinitions();
        if (definitions == null) {
            return;
        }
        wSDLModel.startTransaction();
        try {
            Object object3;
            Object object4;
            org.netbeans.modules.xml.schema.model.Import import_;
            Object object5;
            collection = definitions.getServices();
            if (collection == null) {
                return;
            }
            for (Object object6 : collection) {
                object2 = object6.getPorts();
                if (object2 == null) continue;
                for (Object object7 : object2) {
                    object5 = object7.getExtensibilityElements(SOAPAddress.class);
                    import_ = object5.iterator();
                    while (import_.hasNext()) {
                        object4 = (SOAPAddress)import_.next();
                        try {
                            object3 = new URL(object4.getLocation());
                            if (PartnerLinkHelper.isExternalResource((URL)object3)) continue;
                            object3 = new URL(((URL)object3).getProtocol(), "localhost", ((URL)object3).getPort(), ((URL)object3).getFile());
                            object4.setLocation(((URL)object3).toString());
                        }
                        catch (MalformedURLException malformedURLException) {
                            malformedURLException.printStackTrace();
                        }
                    }
                }
            }
            if (bl) {
                Object object7;
                Object object6;
                Types types = definitions.getTypes();
                if (types != null && (object6 = types.getSchemas()) != null) {
                    object2 = object6.iterator();
                    while (object2.hasNext()) {
                        object = (Schema)object2.next();
                        object7 = object.getImports();
                        object5 = object7.iterator();
                        while (object5.hasNext()) {
                            import_ = (org.netbeans.modules.xml.schema.model.Import)object5.next();
                            object4 = import_.getSchemaLocation();
                            if (object4 == null || PartnerLinkHelper.isExternalResource((String)object4) || (object3 = this.fixLocation(wSDLModel, (String)object4)) == null) continue;
                            import_.setSchemaLocation((String)object3);
                        }
                    }
                }
                object6 = definitions.getImports();
                object2 = object6.iterator();
                while (object2.hasNext()) {
                    object = (Import)object2.next();
                    object7 = object.getLocation();
                    if (object7 == null || PartnerLinkHelper.isExternalResource((String)object7) || (object5 = PartnerLinkHelper.getFileName((String)object7)) == null) continue;
                    object.setLocation((String)object5);
                }
            }
        }
        finally {
            wSDLModel.endTransaction();
        }
        PartnerLinkHelper.saveModel((Model)wSDLModel);
        collection = definitions.getImports();
        for (Object object6 : collection) {
            object2 = null;
            try {
                object = object6.getLocation();
                if (object != null && !PartnerLinkHelper.isExternalResource((String)object)) {
                    object2 = object6.getImportedWSDLModel();
                }
            }
            catch (CatalogModelException catalogModelException) {
                // empty catch block
            }
            if (object2 == null) continue;
            this.fixSoapAddress((WSDLModel)object2, bl);
        }
    }

    private String fixLocation(WSDLModel wSDLModel, String string) {
        CatalogWriteModel catalogWriteModel;
        FileObject fileObject = (FileObject)wSDLModel.getModelSource().getLookup().lookup(FileObject.class);
        try {
            catalogWriteModel = CatalogWriteModelFactory.getInstance().getCatalogWriteModelForProject(fileObject);
        }
        catch (CatalogModelException catalogModelException) {
            return null;
        }
        Collection collection = catalogWriteModel.getCatalogEntries();
        for (CatalogEntry catalogEntry : collection) {
            if (!string.equals(catalogEntry.getSource())) continue;
            String string2 = catalogEntry.getTarget();
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            return string2;
        }
        return null;
    }

    public static String getFileName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        if ((n = string.indexOf(63)) >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static boolean isExternalResource(String string) {
        try {
            return PartnerLinkHelper.isExternalResource(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public static boolean isExternalResource(URL uRL) {
        if (uRL == null || uRL.getHost() == null) {
            return false;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(uRL.getHost());
            if (inetAddress == null) {
                return false;
            }
            return NetworkInterface.getByInetAddress(inetAddress) == null;
        }
        catch (SocketException socketException) {
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    public static PartnerRole getPartnerlinkRole(PartnerLink partnerLink) {
        if (partnerLink == null) {
            return null;
        }
        WSDLReference wSDLReference = partnerLink.getMyRole();
        WSDLReference wSDLReference2 = partnerLink.getPartnerRole();
        WSDLReference wSDLReference3 = partnerLink.getPartnerLinkType();
        if (wSDLReference3 != null && wSDLReference3.get() != null) {
            PartnerLinkType partnerLinkType = (PartnerLinkType)wSDLReference3.get();
            if (wSDLReference != null && wSDLReference.get() != null) {
                return partnerLinkType.getRole1() != null && wSDLReference.references((Referenceable)partnerLinkType.getRole1()) ? PartnerRole.CONSUMER : PartnerRole.PROVIDER;
            }
            if (wSDLReference2 != null && wSDLReference2.get() != null) {
                return partnerLinkType.getRole1() != null && wSDLReference2.references((Referenceable)partnerLinkType.getRole1()) ? PartnerRole.PROVIDER : PartnerRole.CONSUMER;
            }
        }
        return null;
    }

    public static void setPartnerlinkRole(PartnerLink partnerLink, PartnerRole partnerRole) {
        WSDLReference wSDLReference = partnerLink.getPartnerLinkType();
        if (wSDLReference != null && wSDLReference.get() != null) {
            PartnerLinkType partnerLinkType = (PartnerLinkType)wSDLReference.get();
            Role role = partnerLinkType.getRole1();
            WSDLReference wSDLReference2 = partnerLink.createWSDLReference((ReferenceableWSDLComponent)role, Role.class);
            if (partnerRole == PartnerRole.CONSUMER) {
                partnerLink.setMyRole(wSDLReference2);
                partnerLink.removePartnerRole();
            } else {
                partnerLink.removeMyRole();
                partnerLink.setPartnerRole(wSDLReference2);
            }
        }
    }

    public static WSDLModel getWSDLModel(FileObject fileObject) {
        WSDLModel wSDLModel = null;
        try {
            File file = new File(fileObject.getURL().toURI());
            ModelSource modelSource = Utilities.getModelSource((FileObject)FileUtil.toFileObject((File)file), (boolean)true);
            wSDLModel = WSDLModelFactory.getDefault().getModel(modelSource);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        return wSDLModel;
    }
}

