/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.selection.placeholders;

import java.awt.Cursor;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.DiagramView;
import org.netbeans.modules.bpel.design.DnDHandler;
import org.netbeans.modules.bpel.design.PartnerlinksView;
import org.netbeans.modules.bpel.design.model.PartnerLinkHelper;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.model.patterns.ProcessPattern;
import org.netbeans.modules.bpel.design.selection.PlaceHolder;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.PartnerLinkContainer;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.properties.ImportRegistrationHelper;
import org.netbeans.modules.soa.ui.UserNotification;
import org.netbeans.modules.soa.ui.form.CustomNodeEditor;
import org.netbeans.modules.websvc.core.WebServiceReference;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.xam.Model;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PartnerlinkPlaceholder
extends PlaceHolder {
    private DiagramView diagramView;
    private BpelEntity insertAfter;
    private RequestProcessor wsdlDnDRequestProcessor;

    public PartnerlinkPlaceholder(DiagramView diagramView, BpelEntity bpelEntity, Pattern pattern, double d, double d2) {
        super(null, pattern, d, d2);
        this.diagramView = diagramView;
        this.insertAfter = bpelEntity;
    }

    public void drop() {
        Pattern pattern = this.getDraggedPattern();
        PartnerLink partnerLink = (PartnerLink)pattern.getOMReference();
        Object object = partnerLink.getCookie(DnDHandler.class);
        RequestProcessor requestProcessor = this.getRequestProcessor();
        if (object instanceof FileObject) {
            FileObject fileObject = (FileObject)object;
            if (!this.isInOurProject(fileObject)) {
                try {
                    URL uRL = fileObject.getURL();
                    String string = fileObject.getName();
                    requestProcessor.post((Runnable)new RetrieveWSDLTask(uRL, string, partnerLink, false));
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    assert (false);
                }
            } else {
                partnerLink.setCookie(DnDHandler.class, (Object)fileObject);
            }
            requestProcessor.post((Runnable)new AddPartnerLinkTask(partnerLink, pattern));
        } else if (object instanceof WebServiceReference) {
            URL uRL = ((WebServiceReference)object).getWsdlURL();
            String string = ((WebServiceReference)object).getWebServiceName();
            if (uRL != null) {
                requestProcessor.post((Runnable)new RetrieveWSDLTask(uRL, string, partnerLink, true));
                requestProcessor.post((Runnable)new AddPartnerLinkTask(partnerLink, pattern));
            } else {
                String string2 = NbBundle.getMessage(ProcessPattern.class, (String)"LBL_J2EEWS_NOT_DEPLOYED", (Object)"");
                UserNotification.showMessageAsinc((String)string2);
            }
        } else {
            requestProcessor.post((Runnable)new AddPartnerLinkTask(partnerLink, pattern));
        }
    }

    private boolean isInOurProject(FileObject fileObject) {
        FileObject fileObject2 = (FileObject)this.diagramView.getDesignView().getBPELModel().getModelSource().getLookup().lookup(FileObject.class);
        if (fileObject2 == null) {
            return false;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject2);
        Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
        return project != null && project.equals(project2);
    }

    private synchronized RequestProcessor getRequestProcessor() {
        if (this.wsdlDnDRequestProcessor == null) {
            this.wsdlDnDRequestProcessor = new RequestProcessor(this.getClass().getName());
        }
        return this.wsdlDnDRequestProcessor;
    }

    class AddPartnerLinkTask
    implements Runnable {
        private PartnerLink pLink;
        private Pattern pattern;

        public AddPartnerLinkTask(PartnerLink partnerLink, Pattern pattern) {
            this.pLink = partnerLink;
            this.pattern = pattern;
        }

        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    final BpelModel bpelModel = PartnerlinkPlaceholder.this.diagramView.getDesignView().getBPELModel();
                    try {
                        bpelModel.invoke(new Callable(){

                            public Object call() throws Exception {
                                Process process = bpelModel.getProcess();
                                PartnerLinkContainer partnerLinkContainer = process.getPartnerLinkContainer();
                                boolean bl = false;
                                if (partnerLinkContainer == null) {
                                    partnerLinkContainer = bpelModel.getBuilder().createPartnerLinkContainer();
                                    process.setPartnerLinkContainer(partnerLinkContainer);
                                    bl = true;
                                }
                                partnerLinkContainer.insertPartnerLink(AddPartnerLinkTask.this.pLink, this.getIndex(partnerLinkContainer));
                                PartnerLinkType partnerLinkType = this.getFirstPLT();
                                if (partnerLinkType != null) {
                                    WSDLReference wSDLReference = AddPartnerLinkTask.this.pLink.createWSDLReference((ReferenceableWSDLComponent)partnerLinkType, PartnerLinkType.class);
                                    AddPartnerLinkTask.this.pLink.setPartnerLinkType(wSDLReference);
                                    new ImportRegistrationHelper(AddPartnerLinkTask.this.pLink.getBpelModel()).addImport((Model)partnerLinkType.getModel());
                                }
                                PartnerLinkHelper.setPartnerlinkRole(AddPartnerLinkTask.this.pLink, ((PartnerlinksView)PartnerlinkPlaceholder.this.diagramView).getMode());
                                if (AddPartnerLinkTask.this.pLink.getPartnerLinkType() == null && !PartnerlinkPlaceholder.this.diagramView.getDesignView().showCustomEditor(AddPartnerLinkTask.this.pattern, CustomNodeEditor.EditingMode.CREATE_NEW_INSTANCE)) {
                                    partnerLinkContainer.remove((BpelEntity)AddPartnerLinkTask.this.pLink);
                                    if (bl) {
                                        process.removePartnerLinkContainer();
                                    }
                                }
                                return null;
                            }

                            private PartnerLinkType getFirstPLT() {
                                FileObject fileObject = (FileObject)AddPartnerLinkTask.this.pLink.getCookie(DnDHandler.class);
                                if (fileObject == null) {
                                    return null;
                                }
                                WSDLModel wSDLModel = PartnerLinkHelper.getWSDLModel(fileObject);
                                if (wSDLModel == null || wSDLModel.getDefinitions() == null) {
                                    return null;
                                }
                                List list = wSDLModel.getDefinitions().getExtensibilityElements(PartnerLinkType.class);
                                if (list == null || list.size() != 1) {
                                    return null;
                                }
                                return (PartnerLinkType)list.get(0);
                            }

                            private int getIndex(PartnerLinkContainer partnerLinkContainer) {
                                if (PartnerlinkPlaceholder.this.insertAfter != null) {
                                    PartnerLink[] partnerLinkArray = partnerLinkContainer.getPartnerLinks();
                                    for (int i = 0; i < partnerLinkArray.length; ++i) {
                                        if (partnerLinkArray[i] != PartnerlinkPlaceholder.this.insertAfter) continue;
                                        return i + 1;
                                    }
                                }
                                return 0;
                            }
                        }, (Object)this);
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify(1, (Throwable)exception);
                    }
                }
            });
        }
    }

    class RetrieveWSDLTask
    implements Runnable {
        private URL url;
        private String name;
        private PartnerLink pl;
        private boolean retrieveToFlat;

        public RetrieveWSDLTask(URL uRL, String string, PartnerLink partnerLink, boolean bl) {
            this.url = uRL;
            this.name = string;
            this.pl = partnerLink;
            this.retrieveToFlat = bl;
        }

        public void run() {
            DesignView designView = PartnerlinkPlaceholder.this.diagramView.getDesignView();
            Cursor cursor = designView.getCursor();
            designView.setCursor(Cursor.getPredefinedCursor(3));
            FileObject fileObject = new PartnerLinkHelper(designView.getModel()).retrieveWSDL(this.url, this.name, this.retrieveToFlat);
            this.pl.setCookie(DnDHandler.class, (Object)fileObject);
            designView.setCursor(cursor);
        }
    }
}

