/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.documentation;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.editors.api.EditorUtil;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.ContentElement;
import org.netbeans.modules.bpel.model.api.CorrelationContainer;
import org.netbeans.modules.bpel.model.api.CorrelationSet;
import org.netbeans.modules.bpel.model.api.CorrelationSetContainer;
import org.netbeans.modules.bpel.model.api.Documentation;
import org.netbeans.modules.bpel.model.api.ExtensibleElements;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.PartnerLinkContainer;
import org.netbeans.modules.bpel.model.api.PatternedCorrelationContainer;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.VariableContainer;
import org.netbeans.modules.reportgenerator.api.Report;
import org.netbeans.modules.reportgenerator.api.ReportAttribute;
import org.netbeans.modules.reportgenerator.api.ReportBody;
import org.netbeans.modules.reportgenerator.api.ReportElement;
import org.netbeans.modules.reportgenerator.api.ReportElementFactory;
import org.netbeans.modules.reportgenerator.api.ReportException;
import org.netbeans.modules.reportgenerator.api.ReportSection;
import org.netbeans.modules.reportgenerator.spi.ReportCookie;
import org.netbeans.modules.xml.ui.UI;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public class DocumentationGenerator
implements ReportCookie {
    private JComponent myCanvas;
    private DataObject myDataObject;
    private ReportElementFactory myFactory;

    public DocumentationGenerator(DataObject dataObject, JComponent jComponent) {
        this.myDataObject = dataObject;
        this.myCanvas = jComponent;
    }

    public Report generateReport() {
        try {
            this.myFactory = ReportElementFactory.getDefault();
            if (this.myFactory == null) {
                return null;
            }
            return this.createReport(EditorUtil.getBpelModel((DataObject)this.myDataObject).getProcess(), this.myFactory.createReport());
        }
        catch (ReportException reportException) {
            ErrorManager.getDefault().notify((Throwable)reportException);
            return null;
        }
    }

    private Report createReport(Process process, Report report) throws ReportException {
        if (process == null) {
            return report;
        }
        report.setName(this.i18n("LBL_Report_of", process.getName()));
        String string = process.getDocumentation();
        if (string == null) {
            string = this.i18n("LBL_Report_for", this.myDataObject.getPrimaryFile().getNameExt());
        }
        report.setDescription(string);
        report.setOverViewImage(this.createImage());
        File file = FileUtil.toFile((FileObject)this.myDataObject.getPrimaryFile());
        ReportAttribute reportAttribute = this.myFactory.createReportAttribute();
        reportAttribute.setName(this.i18n("LBL_Name"));
        reportAttribute.setValue((Object)this.myDataObject.getName());
        report.addAttribute(reportAttribute);
        reportAttribute = this.myFactory.createReportAttribute();
        reportAttribute.setName(this.i18n("LBL_Location"));
        reportAttribute.setValue((Object)file.getAbsolutePath());
        report.addAttribute(reportAttribute);
        reportAttribute = this.myFactory.createReportAttribute();
        reportAttribute.setName(this.i18n("LBL_Size"));
        reportAttribute.setValue((Object)this.i18n("LBL_Bytes", Long.toString(file.length())));
        report.addAttribute(reportAttribute);
        reportAttribute = this.myFactory.createReportAttribute();
        reportAttribute.setName(this.i18n("LBL_Created"));
        reportAttribute.setValue((Object)new Date(System.currentTimeMillis()));
        report.addAttribute(reportAttribute);
        reportAttribute = this.myFactory.createReportAttribute();
        reportAttribute.setName(this.i18n("LBL_Last_Modified"));
        reportAttribute.setValue((Object)new Date(file.lastModified()));
        report.addAttribute(reportAttribute);
        ReportBody reportBody = this.myFactory.createReportBody();
        report.setBody(reportBody);
        ReportSection reportSection = this.createSection("LBL_Import", "LBL_Section_Import");
        this.fillImport(process, reportBody, reportSection);
        reportSection = this.createSection("LBL_Partner_Link", "LBL_Section_Partner_Link");
        this.fillPartnerLink(process, reportBody, reportSection);
        reportSection = this.createSection("LBL_Variable", "LBL_Section_Variable");
        this.fillVariable(process, reportBody, reportSection);
        reportSection = this.createSection("LBL_Correlation_Set", "LBL_Section_Correlation_Set");
        this.fillCorrelationSet(process, reportBody, reportSection);
        reportSection = this.createSection("LBL_Element", "LBL_Section_Element");
        reportBody.addReportSection(reportSection);
        this.travelElement(process, reportSection);
        return report;
    }

    private ReportSection createSection(String string, String string2) {
        ReportSection reportSection = this.myFactory.createReportSection();
        reportSection.setName(this.i18n(string));
        reportSection.setDescription(this.i18n(string2));
        return reportSection;
    }

    private void fillImport(Process process, ReportBody reportBody, ReportSection reportSection) {
        Import[] importArray = process.getImports();
        if (importArray == null || importArray.length == 0) {
            return;
        }
        for (Import import_ : importArray) {
            this.fillElement((BpelEntity)import_, reportSection);
        }
        reportBody.addReportSection(reportSection);
    }

    private void fillPartnerLink(Process process, ReportBody reportBody, ReportSection reportSection) {
        PartnerLinkContainer partnerLinkContainer = process.getPartnerLinkContainer();
        if (partnerLinkContainer == null) {
            return;
        }
        PartnerLink[] partnerLinkArray = partnerLinkContainer.getPartnerLinks();
        if (partnerLinkArray == null || partnerLinkArray.length == 0) {
            return;
        }
        for (PartnerLink partnerLink : partnerLinkArray) {
            this.fillElement((BpelEntity)partnerLink, reportSection);
        }
        reportBody.addReportSection(reportSection);
    }

    private void fillVariable(Process process, ReportBody reportBody, ReportSection reportSection) {
        VariableContainer variableContainer = process.getVariableContainer();
        if (variableContainer == null) {
            return;
        }
        Variable[] variableArray = variableContainer.getVariables();
        if (variableArray == null || variableArray.length == 0) {
            return;
        }
        for (Variable variable : variableArray) {
            this.fillElement((BpelEntity)variable, reportSection);
        }
        reportBody.addReportSection(reportSection);
    }

    private void fillCorrelationSet(Process process, ReportBody reportBody, ReportSection reportSection) {
        CorrelationSetContainer correlationSetContainer = process.getCorrelationSetContainer();
        if (correlationSetContainer == null) {
            return;
        }
        CorrelationSet[] correlationSetArray = correlationSetContainer.getCorrelationSets();
        if (correlationSetArray == null || correlationSetArray.length == 0) {
            return;
        }
        for (CorrelationSet correlationSet : correlationSetArray) {
            this.fillElement((BpelEntity)correlationSet, reportSection);
        }
        reportBody.addReportSection(reportSection);
    }

    private void travelElement(Object object, ReportSection reportSection) {
        if (!(object instanceof BpelEntity)) {
            return;
        }
        BpelEntity bpelEntity = (BpelEntity)object;
        if (this.skipElement(bpelEntity)) {
            return;
        }
        if (!(object instanceof Process)) {
            this.fillElement(bpelEntity, reportSection);
        }
        List list = bpelEntity.getChildren();
        for (Object e : list) {
            this.travelElement(e, reportSection);
        }
    }

    private boolean skipElement(BpelEntity bpelEntity) {
        return bpelEntity instanceof Import || bpelEntity instanceof CorrelationSet || bpelEntity instanceof CorrelationSetContainer || bpelEntity instanceof CorrelationContainer || bpelEntity instanceof PartnerLink || bpelEntity instanceof PartnerLinkContainer || bpelEntity instanceof Variable || bpelEntity instanceof VariableContainer || bpelEntity instanceof Documentation || bpelEntity instanceof PatternedCorrelationContainer;
    }

    private void fillElement(BpelEntity bpelEntity, ReportSection reportSection) {
        String string;
        ReportElement reportElement = this.myFactory.createReportElement();
        Icon icon = EditorUtil.getIcon((Component)bpelEntity);
        if (icon instanceof ImageIcon) {
            reportElement.setImage(((ImageIcon)icon).getImage());
        }
        reportElement.setName(this.getInfo(bpelEntity));
        if (bpelEntity instanceof ExtensibleElements && (string = ((ExtensibleElements)bpelEntity).getDocumentation()) != null) {
            reportElement.setDescription(string);
        }
        this.fillAttributes(bpelEntity, reportElement);
        reportSection.addReportElement(reportElement);
    }

    private void fillAttributes(BpelEntity bpelEntity, ReportElement reportElement) {
        AbstractDocumentComponent abstractDocumentComponent = (AbstractDocumentComponent)bpelEntity;
        Map map = abstractDocumentComponent.getAttributeMap();
        for (QName qName : map.keySet()) {
            String string = (String)map.get(qName);
            if (string == null || string.length() == 0) continue;
            ReportAttribute reportAttribute = this.myFactory.createReportAttribute();
            reportAttribute.setName(qName.toString());
            reportAttribute.setValue((Object)string);
            reportElement.addAttribute(reportAttribute);
        }
    }

    private Image createImage() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(this.myCanvas.getWidth(), this.myCanvas.getHeight(), 2);
        this.myCanvas.print(bufferedImage.createGraphics());
        return bufferedImage;
    }

    private String getInfo(BpelEntity bpelEntity) {
        String string;
        String string2 = this.getType(bpelEntity);
        String string3 = this.getName(bpelEntity);
        if (string3 != null) {
            string2 = string2 + " '" + ((Named)bpelEntity).getName() + "'";
        } else if (bpelEntity instanceof ContentElement && (string = ((ContentElement)bpelEntity).getContent()) != null && string.length() > 0) {
            string2 = string2 + ": " + string;
        }
        return string2;
    }

    private String getType(BpelEntity bpelEntity) {
        String string = bpelEntity.getElementType().getName();
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    private String getName(BpelEntity bpelEntity) {
        if (!(bpelEntity instanceof Named)) {
            return null;
        }
        return ((Named)bpelEntity).getName();
    }

    private String i18n(String string) {
        return UI.i18n(DocumentationGenerator.class, (String)string);
    }

    private String i18n(String string, String string2) {
        return UI.i18n(DocumentationGenerator.class, (String)string, (String)string2);
    }
}

