/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.editors.multiview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.text.JTextComponent;
import org.netbeans.api.print.PrintManager;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.bpel.core.BPELDataEditorSupport;
import org.netbeans.modules.bpel.core.BPELDataObject;
import org.netbeans.modules.bpel.core.SelectBpelElement;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.NavigationTools;
import org.netbeans.modules.bpel.design.PartnerLinkFilterButton;
import org.netbeans.modules.bpel.design.SequenceFilterButton;
import org.netbeans.modules.bpel.design.ZoomManager;
import org.netbeans.modules.bpel.design.actions.BreakpointsDeleteAction;
import org.netbeans.modules.bpel.design.actions.BreakpointsDisableAction;
import org.netbeans.modules.bpel.design.actions.BreakpointsEnableAction;
import org.netbeans.modules.bpel.documentation.DocumentationGenerator;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.model.api.Assign;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Catch;
import org.netbeans.modules.bpel.model.api.CatchAll;
import org.netbeans.modules.bpel.model.api.CompensatableActivityHolder;
import org.netbeans.modules.bpel.model.api.Compensate;
import org.netbeans.modules.bpel.model.api.CompensateScope;
import org.netbeans.modules.bpel.model.api.CompensationHandler;
import org.netbeans.modules.bpel.model.api.Copy;
import org.netbeans.modules.bpel.model.api.Correlation;
import org.netbeans.modules.bpel.model.api.CorrelationSet;
import org.netbeans.modules.bpel.model.api.Else;
import org.netbeans.modules.bpel.model.api.ElseIf;
import org.netbeans.modules.bpel.model.api.Empty;
import org.netbeans.modules.bpel.model.api.EventHandlers;
import org.netbeans.modules.bpel.model.api.Exit;
import org.netbeans.modules.bpel.model.api.FaultHandlers;
import org.netbeans.modules.bpel.model.api.Flow;
import org.netbeans.modules.bpel.model.api.ForEach;
import org.netbeans.modules.bpel.model.api.FromPart;
import org.netbeans.modules.bpel.model.api.If;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.Invoke;
import org.netbeans.modules.bpel.model.api.MessageExchange;
import org.netbeans.modules.bpel.model.api.OnAlarmEvent;
import org.netbeans.modules.bpel.model.api.OnAlarmPick;
import org.netbeans.modules.bpel.model.api.OnEvent;
import org.netbeans.modules.bpel.model.api.OnMessage;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.PatternedCorrelation;
import org.netbeans.modules.bpel.model.api.Pick;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.Receive;
import org.netbeans.modules.bpel.model.api.RepeatUntil;
import org.netbeans.modules.bpel.model.api.Reply;
import org.netbeans.modules.bpel.model.api.Scope;
import org.netbeans.modules.bpel.model.api.Sequence;
import org.netbeans.modules.bpel.model.api.TerminationHandler;
import org.netbeans.modules.bpel.model.api.Throw;
import org.netbeans.modules.bpel.model.api.ToPart;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.VariableContainer;
import org.netbeans.modules.bpel.model.api.VariableDeclarationScope;
import org.netbeans.modules.bpel.model.api.Wait;
import org.netbeans.modules.bpel.model.api.While;
import org.netbeans.modules.bpel.model.api.events.ChangeEventListenerAdapter;
import org.netbeans.modules.bpel.model.api.events.PropertyUpdateEvent;
import org.netbeans.modules.bpel.palette.SoaPaletteFactory;
import org.netbeans.modules.bpel.properties.PropertyNodeFactory;
import org.netbeans.modules.bpel.search.Diagram;
import org.netbeans.modules.reportgenerator.api.CustomizeReportAction;
import org.netbeans.modules.reportgenerator.api.GenerateReportAction;
import org.netbeans.modules.reportgenerator.spi.ReportCookie;
import org.netbeans.modules.soa.validation.action.ValidationAction;
import org.netbeans.modules.soa.validation.core.Controller;
import org.netbeans.modules.xml.search.api.SearchManager;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ui.multiview.ActivatedNodesMediator;
import org.netbeans.modules.xml.xam.ui.multiview.CookieProxyLookup;
import org.netbeans.modules.xml.xam.ui.undo.QuietUndoManager;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

public class DesignerMultiViewElement
extends TopComponent
implements MultiViewElement,
ExplorerManager.Provider,
Serializable,
SelectBpelElement {
    private static final long serialVersionUID = 1L;
    private Component myFind;
    protected static Map<Class<? extends BpelEntity>, NodeType> BPELENTITY_NODETYPE_MAP = new HashMap<Class<? extends BpelEntity>, NodeType>();
    private static final String ACTIVATED_NODES = "activatedNodes";
    private transient MultiViewElementCallback myMultiViewObserver;
    private transient DesignView myDesignView;
    private transient UndoRedo.Manager myUndoManager;
    private transient InstanceContent nodesHack;
    private BPELDataObject myDataObject;
    private transient JComponent myToolBarPanel;
    private static Boolean groupVisible;
    private PropertyChangeListener myActiveNodeChangeListener;
    private ExplorerManager myExplorerManager;
    private ActivatedNodesMediator myNodesMediator;
    private CookieProxyLookup myCookieProxyLookup;

    private DesignerMultiViewElement() {
    }

    public DesignerMultiViewElement(BPELDataObject bPELDataObject) {
        this.myDataObject = bPELDataObject;
        this.initialize();
        this.initializeUI();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.myDataObject);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.myDataObject = (BPELDataObject)objectInput.readObject();
        this.initialize();
        this.initializeUI();
    }

    public DesignView getDesignView() {
        return this.myDesignView;
    }

    private GridBagConstraints createGBConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        return gridBagConstraints;
    }

    public int getPersistenceType() {
        return 2;
    }

    public CloseOperationState canCloseElement() {
        boolean bl = this.isLastView();
        if (!bl) {
            return CloseOperationState.STATE_OK;
        }
        BPELDataEditorSupport bPELDataEditorSupport = this.myDataObject.getEditorSupport();
        boolean bl2 = bPELDataEditorSupport.isModified();
        if (!bl2) {
            return CloseOperationState.STATE_OK;
        }
        return MultiViewFactory.createUnsafeCloseState((String)"Data Object Modified", null, null);
    }

    public void componentActivated() {
        super.componentActivated();
        ExplorerUtils.activateActions((ExplorerManager)this.myExplorerManager, (boolean)true);
        this.addUndoManager();
        this.myDesignView.requestFocusInWindow();
        this.myDesignView.getModel().setActivated();
        Node[] nodeArray = this.getActivatedNodes();
        this.setActivatedNodes(new Node[0]);
        this.setActivatedNodes(nodeArray);
    }

    private Controller getValidationController() {
        return (Controller)this.getDataObject().getLookup().lookup(Controller.class);
    }

    public void componentClosed() {
        super.componentClosed();
        this.cleanup();
    }

    public void componentDeactivated() {
        super.componentDeactivated();
        ExplorerUtils.activateActions((ExplorerManager)this.myExplorerManager, (boolean)false);
    }

    public void componentHidden() {
        super.componentHidden();
        if (this.myDesignView != null) {
            this.myDesignView.setVisible(false);
        }
        DesignerMultiViewElement.updateBpelTcGroupVisibility(false);
    }

    public void componentOpened() {
        super.componentOpened();
    }

    public void componentShowing() {
        super.componentShowing();
        Node[] nodeArray = this.getActivatedNodes();
        if (nodeArray != null) {
            nodeArray = (Node[])nodeArray.clone();
        }
        if (this.myDesignView != null) {
            this.myDesignView.setVisible(true);
        }
        this.addUndoManager();
        DesignerMultiViewElement.updateBpelTcGroupVisibility(true);
    }

    public JComponent getToolbarRepresentation() {
        if (this.myToolBarPanel == null) {
            int n;
            JToolBar jToolBar = new JToolBar();
            jToolBar.setFloatable(false);
            jToolBar.setFocusable(false);
            jToolBar.addSeparator();
            jToolBar.add(new PartnerLinkFilterButton(this.myDesignView));
            jToolBar.add(Box.createHorizontalStrut(1));
            jToolBar.add(new SequenceFilterButton(this.myDesignView));
            jToolBar.addSeparator();
            NavigationTools navigationTools = this.myDesignView.getNavigationTools();
            for (int i = 0; i < navigationTools.getControllersCount(); ++i) {
                jToolBar.add(navigationTools.getController(i));
                if (i + 1 >= navigationTools.getControllersCount()) continue;
                jToolBar.add(Box.createHorizontalStrut(1));
            }
            jToolBar.addSeparator();
            jToolBar.add((Action)new GenerateReportAction((DataObject)this.myDataObject, (ReportCookie)new DocumentationGenerator((DataObject)this.myDataObject, this.getDesignView().getProcessView())));
            jToolBar.add((Action)new CustomizeReportAction((DataObject)this.myDataObject));
            jToolBar.addSeparator();
            ZoomManager zoomManager = this.myDesignView.getZoomManager();
            for (n = 0; n < zoomManager.getComponentCount(); ++n) {
                jToolBar.add(zoomManager.getComponent(n));
                if (n + 1 >= zoomManager.getComponentCount()) continue;
                jToolBar.add(Box.createHorizontalStrut(1));
            }
            jToolBar.addSeparator();
            jToolBar.add(PrintManager.printAction((JComponent)((Object)this)));
            jToolBar.addSeparator();
            jToolBar.add(SearchManager.getDefault().getSearchAction());
            jToolBar.addSeparator();
            jToolBar.add((Action)new ValidationAction(this.getValidationController()));
            jToolBar.addSeparator();
            jToolBar.add(new BreakpointsEnableAction(this.myDesignView));
            jToolBar.add(new BreakpointsDisableAction(this.myDesignView));
            jToolBar.add(new BreakpointsDeleteAction(this.myDesignView));
            n = 0;
            for (Component component : jToolBar.getComponents()) {
                if (!(component instanceof JButton) && !(component instanceof JToggleButton)) continue;
                n = Math.max(component.getPreferredSize().height, n);
            }
            for (Component component : jToolBar.getComponents()) {
                if (component instanceof JButton || component instanceof JToggleButton) {
                    Dimension dimension = component.getMaximumSize();
                    dimension.height = n;
                    component.setMaximumSize(dimension);
                    component.setMinimumSize(component.getPreferredSize());
                    component.setFocusable(false);
                    continue;
                }
                if (component instanceof JTextComponent || component instanceof JComboBox) {
                    component.setMaximumSize(component.getPreferredSize());
                    component.setMinimumSize(component.getPreferredSize());
                    continue;
                }
                component.setMinimumSize(component.getPreferredSize());
                component.setFocusable(false);
            }
            this.myToolBarPanel = jToolBar;
        }
        return this.myToolBarPanel;
    }

    public UndoRedo getUndoRedo() {
        return this.getDataObject().getEditorSupport().getUndoManager();
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this.myMultiViewObserver = multiViewElementCallback;
    }

    public void requestVisible() {
        if (this.myMultiViewObserver != null) {
            this.myMultiViewObserver.requestVisible();
        } else {
            super.requestVisible();
        }
    }

    public void requestActive() {
        if (this.myMultiViewObserver != null) {
            this.myMultiViewObserver.requestActive();
        } else {
            super.requestActive();
        }
    }

    protected boolean closeLast() {
        return true;
    }

    private JButton createExpandAllPatternsToolBarButton() {
        return null;
    }

    private DesignView createDesignView() {
        return new DesignView(this.getLookup());
    }

    private void initializeUI() {
        this.setLayout(new BorderLayout());
        this.myDesignView = this.createDesignView();
        this.add(this.myDesignView, "Center");
        ActionMap actionMap = this.getActionMap();
        ActionMap actionMap2 = this.myDesignView.getActionMap();
        actionMap.setParent(actionMap2);
        actionMap2.put("copy-to-clipboard", actionMap2.get("copy-pattern"));
        actionMap2.put("cut-to-clipboard", actionMap2.get("cut-pattern"));
        actionMap2.put("paste-from-clipboard", actionMap2.get("paste-pattern"));
        actionMap.put("delete", actionMap2.get("delete-something"));
        this.add(this.myDesignView.getRightStripe(), "East");
        this.myFind = SearchManager.getDefault().createFind((Object)new Diagram(this.getDesignView()), (JComponent)this.getDesignView());
        this.myFind.setVisible(false);
        this.add(this.myFind, "South");
        this.initActiveNodeContext();
        this.setVisible(true);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DesignerMultiViewElement.class, (String)"ACSN_DesignerMultiviewElement", (Object)this.getName()));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DesignerMultiViewElement.class, (String)"ACSD_DesignerMultiviewElement", (Object)this.getName()));
    }

    private void initActiveNodeContext() {
        Node[] nodeArray = this.getActivatedNodes();
        if (nodeArray == null || nodeArray.length == 0 || nodeArray[0] instanceof DataNode) {
            Node node = null;
            Node node2 = node != null ? node : (node = this.myDesignView != null ? this.myDesignView.getNodeForPattern(this.myDesignView.getRootPattern()) : null);
            if (node != null) {
                nodeArray = new Node[]{node};
            }
        }
        if (nodeArray != null && nodeArray.length > 0) {
            this.setActivatedNodes(nodeArray);
        }
    }

    private static void updateBpelTcGroupVisibility(boolean bl) {
        WindowManager windowManager = WindowManager.getDefault();
        TopComponentGroup topComponentGroup = windowManager.findTopComponentGroup("bpel_designer");
        if (topComponentGroup == null) {
            return;
        }
        boolean bl2 = false;
        for (Mode mode : windowManager.getModes()) {
            String string;
            MultiViewPerspective multiViewPerspective;
            MultiViewHandler multiViewHandler;
            TopComponent topComponent = mode.getSelectedTopComponent();
            if (topComponent == null || (multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent)) == null || (multiViewPerspective = multiViewHandler.getSelectedPerspective()) == null || !"orch-designer".equals(string = multiViewPerspective.preferredID())) continue;
            bl2 = true;
            break;
        }
        if (bl2 && !Boolean.TRUE.equals(groupVisible)) {
            topComponentGroup.open();
        } else if (!bl2 && !Boolean.FALSE.equals(groupVisible)) {
            topComponentGroup.close();
        }
        groupVisible = bl2 ? Boolean.TRUE : Boolean.FALSE;
    }

    public static String getMVEditorActivePanelPrefferedId() {
        TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
        MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
        if (multiViewHandler == null) {
            return null;
        }
        MultiViewPerspective multiViewPerspective = multiViewHandler.getSelectedPerspective();
        if (multiViewPerspective != null) {
            return multiViewPerspective.preferredID();
        }
        return null;
    }

    private boolean isLastView() {
        boolean bl = true;
        Enumeration enumeration = ((CloneableTopComponent)this.myMultiViewObserver.getTopComponent()).getReference().getComponents();
        if (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                bl = false;
            }
        }
        return bl;
    }

    private BPELDataObject getDataObject() {
        return this.myDataObject;
    }

    private boolean isModelValid() {
        if (this.getDataObject().getEditorSupport().getBpelModel() != null) {
            Model.State state = this.getDataObject().getEditorSupport().getBpelModel().getState();
            return Model.State.VALID.equals((Object)state);
        }
        return false;
    }

    private void initialize() {
        this.myExplorerManager = new ExplorerManager();
        ActionMap actionMap = this.getActionMap();
        Node node = this.myDataObject.getNodeDelegate();
        this.myNodesMediator = new ActivatedNodesMediator(node);
        this.myNodesMediator.setExplorerManager((ExplorerManager.Provider)this);
        this.myCookieProxyLookup = new CookieProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{actionMap, this.myDataObject}), this.myDataObject.getLookup(), Lookups.singleton((Object)this), Lookups.singleton((Object)SoaPaletteFactory.getPalette()), this.myNodesMediator.getLookup(), node.getLookup()}, node);
        this.associateLookup((Lookup)this.myCookieProxyLookup);
        this.addPropertyChangeListener(ACTIVATED_NODES, (PropertyChangeListener)this.myNodesMediator);
        this.addPropertyChangeListener(ACTIVATED_NODES, (PropertyChangeListener)this.myCookieProxyLookup);
        this.setLayout(new BorderLayout());
    }

    private void cleanup() {
        try {
            this.myExplorerManager.setSelectedNodes(new Node[0]);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.removePropertyChangeListener(ACTIVATED_NODES, (PropertyChangeListener)this.myNodesMediator);
        this.removePropertyChangeListener(ACTIVATED_NODES, (PropertyChangeListener)this.myCookieProxyLookup);
        this.myNodesMediator = null;
        this.myCookieProxyLookup = null;
        this.myDesignView.closeView();
        this.myDesignView = null;
        if (this.myFind != null) {
            this.myFind.setEnabled(false);
            this.myFind = null;
        }
        this.removeAll();
    }

    private Lookup createAssociateLookup() {
        this.nodesHack = new InstanceContent();
        return new ProxyLookup(new Lookup[]{this.myDataObject.getLookup(), Lookups.singleton((Object)this), new AbstractLookup((AbstractLookup.Content)this.nodesHack), Lookups.singleton((Object)SoaPaletteFactory.getPalette())});
    }

    public void select(BpelEntity bpelEntity) {
        while (BPELENTITY_NODETYPE_MAP.get(bpelEntity.getElementType()) == null) {
            bpelEntity = bpelEntity.getParent();
        }
        PropertyNodeFactory propertyNodeFactory = PropertyNodeFactory.getInstance();
        Node node = propertyNodeFactory.createNode(BPELENTITY_NODETYPE_MAP.get(bpelEntity.getElementType()), bpelEntity, this.getLookup());
        if (node != null) {
            this.setActivatedNodes(new Node[]{node});
        }
        this.requestVisible();
    }

    private void addUndoManager() {
        BPELDataEditorSupport bPELDataEditorSupport = this.myDataObject.getEditorSupport();
        if (bPELDataEditorSupport != null) {
            QuietUndoManager quietUndoManager = bPELDataEditorSupport.getUndoManager();
            bPELDataEditorSupport.addUndoManagerToModel(quietUndoManager);
        }
    }

    private BpelModel getBpelModel() {
        return this.getDataObject().getEditorSupport().getBpelModel();
    }

    public ExplorerManager getExplorerManager() {
        return this.myExplorerManager;
    }

    static {
        BPELENTITY_NODETYPE_MAP.put(Assign.class, NodeType.ASSIGN);
        BPELENTITY_NODETYPE_MAP.put(Catch.class, NodeType.CATCH);
        BPELENTITY_NODETYPE_MAP.put(CatchAll.class, NodeType.CATCH_ALL);
        BPELENTITY_NODETYPE_MAP.put(CompensatableActivityHolder.class, NodeType.CATCH_ALL);
        BPELENTITY_NODETYPE_MAP.put(Compensate.class, NodeType.COMPENSATE);
        BPELENTITY_NODETYPE_MAP.put(CompensateScope.class, NodeType.COMPENSATE_SCOPE);
        BPELENTITY_NODETYPE_MAP.put(CompensationHandler.class, NodeType.COMPENSATION_HANDLER);
        BPELENTITY_NODETYPE_MAP.put(Copy.class, NodeType.COPY);
        BPELENTITY_NODETYPE_MAP.put(Correlation.class, NodeType.CORRELATION);
        BPELENTITY_NODETYPE_MAP.put(CorrelationSet.class, NodeType.CORRELATION_SET);
        BPELENTITY_NODETYPE_MAP.put(Else.class, NodeType.ELSE);
        BPELENTITY_NODETYPE_MAP.put(ElseIf.class, NodeType.ELSE_IF);
        BPELENTITY_NODETYPE_MAP.put(Empty.class, NodeType.EMPTY);
        BPELENTITY_NODETYPE_MAP.put(EventHandlers.class, NodeType.EVENT_HANDLERS);
        BPELENTITY_NODETYPE_MAP.put(Exit.class, NodeType.EXIT);
        BPELENTITY_NODETYPE_MAP.put(FaultHandlers.class, NodeType.FAULT_HANDLERS);
        BPELENTITY_NODETYPE_MAP.put(Flow.class, NodeType.FLOW);
        BPELENTITY_NODETYPE_MAP.put(ForEach.class, NodeType.FOR_EACH);
        BPELENTITY_NODETYPE_MAP.put(FromPart.class, NodeType.FROM_PART);
        BPELENTITY_NODETYPE_MAP.put(If.class, NodeType.IF);
        BPELENTITY_NODETYPE_MAP.put(Import.class, NodeType.IMPORT);
        BPELENTITY_NODETYPE_MAP.put(Invoke.class, NodeType.INVOKE);
        BPELENTITY_NODETYPE_MAP.put(MessageExchange.class, NodeType.MESSAGE_EXCHANGE);
        BPELENTITY_NODETYPE_MAP.put(OnAlarmEvent.class, NodeType.ALARM_HANDLER);
        BPELENTITY_NODETYPE_MAP.put(OnAlarmPick.class, NodeType.ALARM_HANDLER);
        BPELENTITY_NODETYPE_MAP.put(OnEvent.class, NodeType.ON_EVENT);
        BPELENTITY_NODETYPE_MAP.put(OnMessage.class, NodeType.MESSAGE_HANDLER);
        BPELENTITY_NODETYPE_MAP.put(PartnerLink.class, NodeType.PARTNER_LINK);
        BPELENTITY_NODETYPE_MAP.put(PatternedCorrelation.class, NodeType.CORRELATION_P);
        BPELENTITY_NODETYPE_MAP.put(Pick.class, NodeType.PICK);
        BPELENTITY_NODETYPE_MAP.put(Process.class, NodeType.PROCESS);
        BPELENTITY_NODETYPE_MAP.put(Receive.class, NodeType.RECEIVE);
        BPELENTITY_NODETYPE_MAP.put(RepeatUntil.class, NodeType.REPEAT_UNTIL);
        BPELENTITY_NODETYPE_MAP.put(Reply.class, NodeType.REPLY);
        BPELENTITY_NODETYPE_MAP.put(Scope.class, NodeType.SCOPE);
        BPELENTITY_NODETYPE_MAP.put(Sequence.class, NodeType.SEQUENCE);
        BPELENTITY_NODETYPE_MAP.put(TerminationHandler.class, NodeType.TERMINATION_HANDLER);
        BPELENTITY_NODETYPE_MAP.put(Throw.class, NodeType.THROW);
        BPELENTITY_NODETYPE_MAP.put(ToPart.class, NodeType.TO_PART);
        BPELENTITY_NODETYPE_MAP.put(Variable.class, NodeType.VARIABLE);
        BPELENTITY_NODETYPE_MAP.put(VariableContainer.class, NodeType.VARIABLE_CONTAINER);
        BPELENTITY_NODETYPE_MAP.put(VariableDeclarationScope.class, NodeType.VARIABLE_SCOPE);
        BPELENTITY_NODETYPE_MAP.put(Wait.class, NodeType.WAIT);
        BPELENTITY_NODETYPE_MAP.put(While.class, NodeType.WHILE);
        groupVisible = null;
    }

    private class ProxyListener
    extends ChangeEventListenerAdapter {
        private ProxyListener() {
        }

        public void notifyPropertyUpdated(PropertyUpdateEvent propertyUpdateEvent) {
            if ("<state>".equals(propertyUpdateEvent.getName()) && Model.State.NOT_WELL_FORMED.equals(propertyUpdateEvent.getNewValue())) {
                DesignerMultiViewElement.this.setActivatedNodes(new Node[]{DesignerMultiViewElement.this.getDataObject().getNodeDelegate()});
            }
        }
    }
}

