/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.navigator;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bpel.core.BPELDataEditorSupport;
import org.netbeans.modules.bpel.editors.api.EditorUtil;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.events.ArrayUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.ChangeEventListener;
import org.netbeans.modules.bpel.model.api.events.EntityInsertEvent;
import org.netbeans.modules.bpel.model.api.events.EntityRemoveEvent;
import org.netbeans.modules.bpel.model.api.events.EntityUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyRemoveEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyUpdateEvent;
import org.netbeans.modules.bpel.navigator.BpelNavigatorController;
import org.netbeans.modules.bpel.navigator.BpelNavigatorVisualPanel;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.nodes.BpelProcessNode;
import org.netbeans.modules.bpel.nodes.navigator.Util;
import org.netbeans.modules.bpel.nodes.refactoring.UsageFilterNode;
import org.netbeans.modules.bpel.properties.NodeUtils;
import org.netbeans.modules.soa.ui.form.CustomNodeEditor;
import org.netbeans.modules.soa.validation.core.Controller;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ui.undo.QuietUndoManager;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class BpelModelLogicalBeanTree
implements PropertyChangeListener,
ChangeEventListener {
    private static final long serialVersionUID = 1L;
    private BpelModel myBpelModel;
    private Lookup myContextLookup;
    private BeanTreeView myBeanTreeView;
    private ExplorerManager myExplorerManager;

    public BpelModelLogicalBeanTree(ExplorerManager explorerManager, BpelModel bpelModel, Lookup lookup) {
        this.myBpelModel = bpelModel;
        this.myExplorerManager = explorerManager;
        this.myExplorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.myContextLookup = lookup;
        this.myBeanTreeView = this.createBeanTreeView();
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        this.myBpelModel.addEntityChangeListener((ChangeEventListener)this);
    }

    public void removeListeners() {
        if (this.myExplorerManager != null) {
            this.myExplorerManager.removePropertyChangeListener((PropertyChangeListener)this);
        }
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        if (this.myBpelModel != null) {
            this.myBpelModel.removeEntityChangeListener((ChangeEventListener)this);
        }
        this.myBpelModel = null;
        this.myExplorerManager = null;
    }

    private BeanTreeView createBeanTreeView() {
        BeanTreeView beanTreeView = new BeanTreeView();
        beanTreeView.setRootVisible(true);
        beanTreeView.setEnabled(true);
        beanTreeView.setSelectionMode(1);
        beanTreeView.setDefaultActionAllowed(true);
        this.doTreeNodeSelectionByActiveNode();
        return beanTreeView;
    }

    public BeanTreeView getBeanTreeView() {
        return this.myBeanTreeView;
    }

    private void doTreeNodeSelectionByActiveNode() {
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray == null || nodeArray.length == 0) {
            return;
        }
        for (Node node : nodeArray) {
            if (node instanceof UsageFilterNode) {
                node = ((UsageFilterNode)node).getOriginal();
            } else if (node instanceof BpelNode && ((BpelNode)node).getReference() instanceof BpelEntity && !EditorUtil.isNavigatorShowableNodeType((NodeType)((BpelNode)node).getNodeType())) {
                node = EditorUtil.getClosestNavigatorNode((BpelEntity)((BpelEntity)((BpelNode)node).getReference()), (Lookup)node.getLookup());
            }
            if (!(node instanceof BpelNode) || ((BpelNode)node).getNodeType().equals((Object)NodeType.SCHEMA_ELEMENT) || !(((BpelNode)node).getReference() instanceof BpelEntity)) continue;
            BpelEntity bpelEntity = (BpelEntity)BpelEntity.class.cast(((BpelNode)node).getReference());
            if (bpelEntity == null) break;
            this.doTreeNodeSelection((BpelNode)node);
            break;
        }
    }

    private void doTreeNodeSelection(BpelNode bpelNode) {
        try {
            BpelNode bpelNode2 = Util.findBpelNode(this.myExplorerManager.getRootContext(), bpelNode.getReference());
            if (bpelNode2 == null) {
                return;
            }
            this.myExplorerManager.setSelectedNodes(new Node[]{bpelNode2});
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().notify((Throwable)propertyVetoException);
            propertyVetoException.printStackTrace();
        }
    }

    private void openVisualBpelEditor(BpelNode bpelNode) {
        if (bpelNode == null) {
            return;
        }
        NodeUtils.showNodeCustomEditor((Node)bpelNode, CustomNodeEditor.EditingMode.EDIT_INSTANCE);
    }

    private Lookup getContextLookup() {
        return this.myContextLookup;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        TopComponent topComponent = BpelNavigatorController.getNavigatorTC();
        if (string.equals("activated")) {
            if (TopComponent.getRegistry().getActivated() == topComponent) {
                this.addUndoManager();
                this.triggerValidation();
            }
        } else {
            if (string.equals("activatedNodes")) {
                if (TopComponent.getRegistry().getActivated() != topComponent) {
                    this.doTreeNodeSelectionByActiveNode();
                }
                return;
            }
            if (string.equals("selectedNodes")) {
                if (topComponent == null) {
                    return;
                }
                topComponent.setActivatedNodes((Node[])propertyChangeEvent.getNewValue());
            } else if (string.equals("rootContext")) {
                this.doTreeNodeSelectionByActiveNode();
            } else if (string.equals("opened")) {
                BpelNavigatorController.switchNavigatorPanel();
            }
        }
    }

    public void notifyPropertyRemoved(PropertyRemoveEvent propertyRemoveEvent) {
    }

    public void notifyEntityInserted(final EntityInsertEvent entityInsertEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BpelModelLogicalBeanTree.this.selectEntity(entityInsertEvent.getValue());
            }
        });
    }

    public void notifyPropertyUpdated(final PropertyUpdateEvent propertyUpdateEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String string = propertyUpdateEvent.getName();
                if (string.equals("<state>")) {
                    if (!propertyUpdateEvent.getNewValue().equals(Model.State.VALID)) {
                        BpelModelLogicalBeanTree.this.myBeanTreeView.setEnabled(false);
                        DataObject dataObject = (DataObject)BpelModelLogicalBeanTree.this.myContextLookup.lookup(DataObject.class);
                        if (dataObject != null) {
                            Node node = dataObject.getNodeDelegate();
                            TopComponent topComponent = BpelNavigatorController.getNavigatorTC();
                            if (node != null && topComponent != null) {
                                topComponent.setActivatedNodes(new Node[]{node});
                            }
                        }
                    } else {
                        BpelModelLogicalBeanTree.this.myBeanTreeView.setEnabled(true);
                        ExplorerManager explorerManager = ExplorerManager.find((Component)BpelModelLogicalBeanTree.this.myBeanTreeView);
                        if (explorerManager != null && !(explorerManager.getRootContext() instanceof BpelProcessNode)) {
                            ((BpelNavigatorVisualPanel)BpelModelLogicalBeanTree.this.myBeanTreeView.getParent()).navigate(BpelModelLogicalBeanTree.this.myContextLookup, BpelModelLogicalBeanTree.this.myBpelModel);
                        }
                    }
                }
            }
        });
    }

    public void notifyEntityRemoved(EntityRemoveEvent entityRemoveEvent) {
    }

    public void notifyEntityUpdated(final EntityUpdateEvent entityUpdateEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BpelModelLogicalBeanTree.this.selectEntity(entityUpdateEvent.getNewValue());
            }
        });
    }

    public void notifyArrayUpdated(ArrayUpdateEvent arrayUpdateEvent) {
    }

    private void selectEntity(BpelEntity bpelEntity) {
        if (bpelEntity == null) {
            return;
        }
        BpelNode bpelNode = Util.findBpelNode(this.myExplorerManager.getRootContext(), bpelEntity);
        if (bpelNode == null) {
            return;
        }
        try {
            this.myExplorerManager.setSelectedNodes(new Node[]{bpelNode});
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void addUndoManager() {
        BPELDataEditorSupport bPELDataEditorSupport = (BPELDataEditorSupport)this.myContextLookup.lookup(BPELDataEditorSupport.class);
        if (bPELDataEditorSupport != null) {
            QuietUndoManager quietUndoManager = bPELDataEditorSupport.getUndoManager();
            bPELDataEditorSupport.addUndoManagerToModel(quietUndoManager);
        }
    }

    private void triggerValidation() {
        Controller controller = (Controller)this.myContextLookup.lookup(Controller.class);
        if (controller != null) {
            controller.triggerValidation();
        }
    }
}

