/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.navigator.BpelModelLogicalBeanTree;
import org.netbeans.modules.bpel.navigator.BpelNavigatorController;
import org.netbeans.modules.bpel.nodes.BpelProcessNode;
import org.netbeans.modules.bpel.nodes.actions.GoToAction;
import org.netbeans.modules.bpel.nodes.actions.GoToDiagrammAction;
import org.netbeans.modules.bpel.nodes.actions.GoToLoggingAction;
import org.netbeans.modules.bpel.nodes.actions.GoToSourceAction;
import org.netbeans.modules.bpel.nodes.actions.ShowBpelMapperAction;
import org.netbeans.modules.bpel.nodes.navigator.NavigatorNodeFactory;
import org.netbeans.modules.bpel.nodes.validation.ValidationProxyListener;
import org.netbeans.modules.soa.ui.ExtendedLookup;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class BpelNavigatorVisualPanel
extends JPanel
implements ExplorerManager.Provider,
Lookup.Provider,
HelpCtx.Provider {
    private static final long serialVersionUID = 1L;
    private static final String DELETE = "delete";
    private static final KeyStroke DELETE_KEYSTROKE = KeyStroke.getKeyStroke(127, 0);
    private static final String GOTOSOURCE = "gotosource";
    private static final String GOTODIAGRAMM = "gotodiagramm";
    private static final String GOTOMAPPER = "gotomapper";
    private static final String GOTOLOGGING = "gotologging";
    private JLabel myMsgLabel;
    private Lookup myContextLookup;
    private BpelModel myBpelModel;
    private Lookup myLookup;
    private ExplorerManager myExplorerManager;
    private ValidationProxyListener myVpl;
    private BpelModelLogicalBeanTree myBpelModelLogicalBeanTree;
    private boolean isRequireRepaint;

    public BpelNavigatorVisualPanel() {
        this.initComponent();
    }

    private void initComponent() {
        this.setLayout(new BorderLayout());
        this.myMsgLabel = new JLabel();
        this.add((Component)this.myMsgLabel, "Center");
    }

    private void initActionMap() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put(GOTOSOURCE, (Action)SystemAction.get(GoToSourceAction.class));
        actionMap.put(GOTODIAGRAMM, (Action)SystemAction.get(GoToDiagrammAction.class));
        actionMap.put(GOTOMAPPER, (Action)SystemAction.get(ShowBpelMapperAction.class));
        actionMap.put(GOTOLOGGING, (Action)SystemAction.get(GoToLoggingAction.class));
        actionMap.put(DELETE, ExplorerUtils.actionDelete((ExplorerManager)this.myExplorerManager, (boolean)true));
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(DELETE_KEYSTROKE, DELETE);
        KeyStroke keyStroke = GoToAction.getKeyStroke(GoToSourceAction.class);
        KeyStroke keyStroke2 = GoToAction.getKeyStroke(GoToDiagrammAction.class);
        KeyStroke keyStroke3 = GoToAction.getKeyStroke(ShowBpelMapperAction.class);
        KeyStroke keyStroke4 = GoToAction.getKeyStroke(GoToLoggingAction.class);
        if (keyStroke != null) {
            inputMap.put(keyStroke, GOTOSOURCE);
        }
        if (keyStroke2 != null) {
            inputMap.put(keyStroke2, GOTODIAGRAMM);
        }
        if (keyStroke3 != null) {
            inputMap.put(keyStroke3, GOTOMAPPER);
        }
        if (keyStroke4 != null) {
            inputMap.put(keyStroke4, GOTOLOGGING);
        }
        this.myLookup = ExplorerUtils.createLookup((ExplorerManager)this.myExplorerManager, (ActionMap)actionMap);
    }

    public void emptyPanel() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BpelNavigatorVisualPanel.this.removeAll();
                BpelNavigatorVisualPanel.this.repaint();
            }
        });
    }

    public void navigate(Lookup lookup, BpelModel bpelModel) {
        if (bpelModel == null) {
            return;
        }
        this.myBpelModel = bpelModel;
        this.myContextLookup = lookup;
        this.initValidation();
        this.showWaitMsg();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                BpelNavigatorVisualPanel.this.showNavTree();
            }
        });
        thread.start();
        BpelNavigatorController.switchNavigatorPanel();
    }

    private void initValidation() {
        this.myVpl = (ValidationProxyListener)this.myContextLookup.lookup(ValidationProxyListener.class);
        if (this.myVpl == null) {
            this.myVpl = ValidationProxyListener.getInstance(this.myContextLookup);
            if (this.myVpl != null) {
                this.myContextLookup = new ExtendedLookup(this.myContextLookup, new Object[]{this.myVpl});
            }
        }
    }

    private void showNavTree() {
        this.myExplorerManager = new ExplorerManager();
        this.initActionMap();
        Node node = NavigatorNodeFactory.getInstance().getProcessNode(this.myBpelModel, this.getContextLookup());
        if (node instanceof BpelProcessNode) {
            this.myExplorerManager.setRootContext(node);
        }
        if (this.myBpelModelLogicalBeanTree != null) {
            this.myBpelModelLogicalBeanTree.removeListeners();
        }
        this.myBpelModelLogicalBeanTree = new BpelModelLogicalBeanTree(this.myExplorerManager, this.myBpelModel, this.getContextLookup());
        final BeanTreeView beanTreeView = this.myBpelModelLogicalBeanTree.getBeanTreeView();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BpelNavigatorVisualPanel.this.removeAll();
                BpelNavigatorVisualPanel.this.add((Component)beanTreeView);
                BpelNavigatorVisualPanel.this.revalidate();
            }
        });
    }

    public void showWaitMsg() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BpelNavigatorVisualPanel.this.removeAll();
                BpelNavigatorVisualPanel.this.myMsgLabel.setText(NbBundle.getMessage(BpelNavigatorVisualPanel.class, (String)"LBL_Wait"));
                BpelNavigatorVisualPanel.this.add((Component)BpelNavigatorVisualPanel.this.myMsgLabel, "Center");
                BpelNavigatorVisualPanel.this.repaint();
            }
        });
    }

    public ExplorerManager getExplorerManager() {
        return this.myExplorerManager;
    }

    public Lookup getLookup() {
        return this.myLookup;
    }

    public void addNotify() {
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
    }

    private Lookup getContextLookup() {
        return this.myContextLookup;
    }

    public HelpCtx getHelpCtx() {
        HelpCtx helpCtx;
        Node[] nodeArray;
        if (this.myExplorerManager != null && (nodeArray = this.myExplorerManager.getSelectedNodes()) != null && nodeArray.length > 0 && (helpCtx = nodeArray[0].getHelpCtx()) != null) {
            return helpCtx;
        }
        return new HelpCtx(BpelNavigatorVisualPanel.class);
    }

    private JTree getJTree() {
        if (this.myBpelModelLogicalBeanTree == null) {
            return null;
        }
        return this.getJTree((Component)this.myBpelModelLogicalBeanTree.getBeanTreeView());
    }

    private JTree getJTree(Component component) {
        if (component instanceof JTree) {
            return (JTree)component;
        }
        if (!(component instanceof Container)) {
            return null;
        }
        Component[] componentArray = ((Container)component).getComponents();
        JTree jTree = null;
        for (Component component2 : componentArray) {
            jTree = this.getJTree(component2);
            if (jTree == null) continue;
            return jTree;
        }
        return null;
    }
}

