/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes.actions;

import javax.swing.SwingUtilities;
import org.netbeans.modules.bpel.editors.api.nodes.actions.ActionType;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.nodes.ImportNode;
import org.netbeans.modules.bpel.nodes.actions.BpelNodeAction;
import org.netbeans.modules.bpel.properties.ResolverUtility;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.ErrorManager;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public class OpenInEditorAction
extends BpelNodeAction {
    private static final long serialVersionUID = 1L;

    protected String getBundleName() {
        return NbBundle.getMessage(OpenInEditorAction.class, (String)"CTL_OpenInEditorAction");
    }

    public void performAction(Node[] nodeArray) {
        if (!this.enable(nodeArray)) {
            return;
        }
        Import import_ = (Import)((ImportNode)nodeArray[0]).getReference();
        if (import_ == null) {
            return;
        }
        ModelSource modelSource = ResolverUtility.getImportedModelSource(import_);
        if (modelSource == null) {
            return;
        }
        FileObject fileObject = (FileObject)modelSource.getLookup().lookup(FileObject.class);
        if (fileObject == null || !fileObject.isValid()) {
            return;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (lineCookie == null) {
                return;
            }
            final Line line = lineCookie.getLineSet().getOriginal(1);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    line.show(2);
                }
            });
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace();
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
        }
    }

    public boolean enable(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1 || !(nodeArray[0] instanceof ImportNode)) {
            return false;
        }
        Import import_ = (Import)((ImportNode)nodeArray[0]).getReference();
        if (import_ == null) {
            return false;
        }
        ModelSource modelSource = ResolverUtility.getImportedModelSource(import_);
        if (modelSource == null) {
            return false;
        }
        FileObject fileObject = (FileObject)modelSource.getLookup().lookup(FileObject.class);
        return fileObject != null && fileObject.isValid();
    }

    public ActionType getType() {
        return ActionType.OPEN_IN_EDITOR;
    }

    protected void performAction(BpelEntity[] bpelEntityArray) {
    }
}

