/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes.navigator;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.bpel.editors.api.EditorUtil;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.model.api.BaseScope;
import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Correlation;
import org.netbeans.modules.bpel.model.api.CorrelationContainer;
import org.netbeans.modules.bpel.model.api.CorrelationSet;
import org.netbeans.modules.bpel.model.api.CorrelationsHolder;
import org.netbeans.modules.bpel.model.api.EventHandlers;
import org.netbeans.modules.bpel.model.api.If;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.Pick;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.Scope;
import org.netbeans.modules.bpel.model.api.VariableContainer;
import org.netbeans.modules.bpel.nodes.CorrelationSetNode;
import org.netbeans.modules.bpel.nodes.VariableNode;
import org.netbeans.modules.bpel.nodes.children.ActivityNodeChildren;
import org.netbeans.modules.bpel.nodes.children.ChildrenType;
import org.netbeans.modules.bpel.nodes.children.EventHandlersChildren;
import org.netbeans.modules.bpel.nodes.children.IfChildren;
import org.netbeans.modules.bpel.nodes.children.ImportContainerChildren;
import org.netbeans.modules.bpel.nodes.children.ImportWsdlChildren;
import org.netbeans.modules.bpel.nodes.children.ImportWsdlPropertyChildren;
import org.netbeans.modules.bpel.nodes.children.PickChildren;
import org.netbeans.modules.bpel.nodes.children.ProcessChildren;
import org.netbeans.modules.bpel.nodes.children.ThenChildren;
import org.netbeans.modules.bpel.nodes.navigator.BaseScopeChildren;
import org.netbeans.modules.bpel.nodes.navigator.BaseScopeCorrelationChildren;
import org.netbeans.modules.bpel.nodes.navigator.BaseScopeMessageExchangeChildren;
import org.netbeans.modules.bpel.nodes.navigator.BaseScopeVariableChildren;
import org.netbeans.modules.bpel.properties.PropertyNodeFactory;
import org.netbeans.modules.soa.ui.ExtendedLookup;
import org.netbeans.modules.soa.ui.nodes.NodeFactory;
import org.netbeans.modules.soa.ui.nodes.NodesTreeParams;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.CorrelationProperty;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PropertyAlias;
import org.netbeans.modules.xml.xam.Component;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigatorNodeFactory
implements NodeFactory<NodeType> {
    private static NavigatorNodeFactory instance = new NavigatorNodeFactory();

    public static NavigatorNodeFactory getInstance() {
        return instance;
    }

    private NavigatorNodeFactory() {
    }

    public Node createNode(BpelEntity bpelEntity, Lookup lookup) {
        return this.createNode(EditorUtil.getBasicNodeType((Component)bpelEntity), (Object)bpelEntity, ChildrenType.DEFAULT_CHILD, lookup);
    }

    public Node createNode(NodeType nodeType, Object object, Lookup lookup) {
        return this.createNode(nodeType, object, ChildrenType.DEFAULT_CHILD, lookup);
    }

    public Node createNode(NodeType nodeType, Object object, Children children, Lookup lookup) {
        return Node.EMPTY;
    }

    public Node createNode(NodeType nodeType, Object object, ChildrenType childrenType, Lookup lookup) {
        if (nodeType == null || nodeType.equals((Object)NodeType.UNKNOWN_TYPE)) {
            return null;
        }
        NodeFactory nodeFactory = (NodeFactory)lookup.lookup(NodeFactory.class);
        if (nodeFactory == null || !nodeFactory.equals(this)) {
            lookup = new ExtendedLookup(lookup, new Object[]{this});
        }
        if (childrenType == null) {
            childrenType = ChildrenType.DEFAULT_CHILD;
        }
        Node node = null;
        switch (nodeType) {
            case PROCESS: {
                assert (object instanceof Process) : "reference should be Process type to create Process type Node";
                node = PropertyNodeFactory.getInstance().createNode(nodeType, object, (Children)new ProcessChildren((Process)object, lookup), lookup);
                break;
            }
            case IF: {
                assert (object instanceof If) : "reference should be If type to create If type Node";
                node = PropertyNodeFactory.getInstance().createNode(nodeType, object, (Children)new IfChildren((If)object, lookup), lookup);
                break;
            }
            case THEN: {
                assert (object instanceof If) : "reference should be If type to create Then type Node";
                node = PropertyNodeFactory.getInstance().createNode(nodeType, object, (Children)new ThenChildren((If)object, lookup), lookup);
                break;
            }
            case EVENT_HANDLERS: {
                assert (object instanceof EventHandlers) : "reference should be EventHandlers type to create EventHandlers type Node";
                node = PropertyNodeFactory.getInstance().createNode(nodeType, object, (Children)new EventHandlersChildren((EventHandlers)object, lookup), lookup);
                break;
            }
            case PICK: {
                assert (object instanceof Pick) : "reference should be Pick type to create Pick type Node";
                node = PropertyNodeFactory.getInstance().createNode(nodeType, object, (Children)new PickChildren((Pick)object, lookup), lookup);
                break;
            }
            case SCOPE: {
                assert (object instanceof Scope) : "reference should be Scope type to create Scope type Node";
                if (childrenType.equals((Object)ChildrenType.SCOPE_VARIABLES_CHILD)) {
                    node = PropertyNodeFactory.getInstance().createNode(nodeType, object, (Children)new BaseScopeVariableChildren((BaseScope)((Scope)object), lookup), lookup);
                    break;
                }
                if (childrenType.equals((Object)ChildrenType.SCOPE_CORRELATIONS_CHILD)) {
                    node = PropertyNodeFactory.getInstance().createNode(nodeType, object, (Children)new BaseScopeCorrelationChildren((BaseScope)((Scope)object), lookup), lookup);
                    break;
                }
                if (childrenType.equals((Object)ChildrenType.SCOPE_MESSAGE_EXCHANGES_CHILD)) {
                    node = PropertyNodeFactory.getInstance().createNode(nodeType, object, (Children)new BaseScopeMessageExchangeChildren((BaseScope)((Scope)object), lookup), lookup);
                    break;
                }
                node = PropertyNodeFactory.getInstance().createNode(nodeType, object, (Children)new BaseScopeChildren((BaseScope)((Scope)object), lookup), lookup);
                break;
            }
            case VARIABLE_CONTAINER: {
                assert (object instanceof BaseScope) : "reference should be BaseScope type to create VariableContainer type Node";
                node = this.createVariableContainerNode((BaseScope)object, lookup);
                break;
            }
            case MESSAGE_EXCHANGE_CONTAINER: {
                assert (object instanceof BaseScope) : "reference should be BaseScope type to create MessageExchangeContainer type Node";
                node = this.createMessageExchangeContainerNode((BaseScope)object, lookup);
                break;
            }
            case IMPORT_CONTAINER: {
                assert (object instanceof Process) : "reference should be Process type to create ImportContainer type Node";
                ImportContainerChildren importContainerChildren = new ImportContainerChildren((Process)object, lookup);
                node = PropertyNodeFactory.getInstance().createNode(nodeType, object, (Children)importContainerChildren, lookup);
                break;
            }
            case IMPORT_SCHEMA: {
                node = PropertyNodeFactory.getInstance().createNode(nodeType, object, lookup);
                break;
            }
            case IMPORT_WSDL: {
                assert (object instanceof Import) : "reference should be Import type to create Import_Wsdl type Node";
                ImportWsdlChildren importWsdlChildren = new ImportWsdlChildren((Import)object, lookup);
                node = PropertyNodeFactory.getInstance().createNode(nodeType, object, (Children)importWsdlChildren, lookup);
                break;
            }
            case PARTNER_LINK_TYPE: {
                assert (object instanceof PartnerLinkType) : "reference should be PartnerLinkType type to create PartnerLinkType type Node";
                node = PropertyNodeFactory.getInstance().createNode(nodeType, object, Children.LEAF, lookup);
                break;
            }
            case CORRELATION_SET_CONTAINER: {
                assert (object instanceof BaseScope) : "reference should be Scope type to create CorrelationSet type Node";
                node = this.createCorrelationSetNode((BaseScope)object, lookup);
                break;
            }
            case CORRELATION_PROPERTY: {
                assert (object instanceof CorrelationProperty) : "reference should be CorrelationProperty type to creaet CorrelationProperty type Node";
                CorrelationProperty correlationProperty = (CorrelationProperty)object;
                node = PropertyNodeFactory.getInstance().createNode(nodeType, object, (Children)new ImportWsdlPropertyChildren(correlationProperty.getModel(), correlationProperty, lookup), lookup);
                break;
            }
            case CORRELATION_PROPERTY_ALIAS: {
                assert (object instanceof PropertyAlias) : "reference should be Scope type to create CorrelationSet type Node";
                node = PropertyNodeFactory.getInstance().createNode(nodeType, object, lookup);
                break;
            }
            case VARIABLE: {
                NodesTreeParams nodesTreeParams = new NodesTreeParams();
                nodesTreeParams.setLeafNodeClasses(new Class[]{VariableNode.class});
                ExtendedLookup extendedLookup = new ExtendedLookup(lookup, new Object[]{nodesTreeParams});
                node = PropertyNodeFactory.getInstance().createNode(nodeType, object, (Lookup)extendedLookup);
                break;
            }
            case CORRELATION_SET: {
                CorrelationSetNode.MyChildren myChildren = new CorrelationSetNode.MyChildren((CorrelationSet)object, lookup);
                node = PropertyNodeFactory.getInstance().createNode(nodeType, object, (Children)myChildren, lookup);
                break;
            }
            case MESSAGE_EXCHANGE: {
                node = PropertyNodeFactory.getInstance().createNode(nodeType, object, lookup);
                break;
            }
            case ALARM_HANDLER: 
            case ALARM_EVENT_HANDLER: 
            case ASSIGN: 
            case CATCH: 
            case CATCH_ALL: 
            case ELSE_IF: 
            case ELSE: 
            case FLOW: 
            case FOR_EACH: 
            case MESSAGE_HANDLER: 
            case ON_EVENT: 
            case INVOKE: 
            case RECEIVE: 
            case FAULT_HANDLERS: 
            case COMPENSATION_HANDLER: 
            case TERMINATION_HANDLER: 
            case REPLY: 
            case SEQUENCE: 
            case WHILE: 
            case REPEAT_UNTIL: {
                ActivityNodeChildren activityNodeChildren = new ActivityNodeChildren((BpelContainer)object, lookup);
                node = PropertyNodeFactory.getInstance().createNode(nodeType, object, (Children)activityNodeChildren, (Lookup)new ExtendedLookup(lookup, new Object[]{activityNodeChildren.getIndex()}));
                break;
            }
            case COPY: 
            case COMPENSATE: 
            case COMPENSATE_SCOPE: 
            case CORRELATION: 
            case CORRELATION_P: 
            case EMPTY: 
            case EXIT: 
            case FROM_PART: 
            case TO_PART: 
            case WAIT: 
            case RETHROW: 
            case THROW: {
                node = PropertyNodeFactory.getInstance().createNode(nodeType, object, Children.LEAF, lookup);
                break;
            }
            case PARTNER_LINK: {
                assert (object instanceof PartnerLink);
                node = PropertyNodeFactory.getInstance().createNode(nodeType, object, lookup);
            }
        }
        return node;
    }

    public Node getProcessNode(BpelModel bpelModel, Lookup lookup) {
        if (bpelModel == null || lookup == null) {
            return Node.EMPTY;
        }
        Process process = bpelModel.getProcess();
        if (process == null) {
            return Node.EMPTY;
        }
        Node node = this.createNode(NodeType.PROCESS, (Object)process, lookup);
        return node == null ? Node.EMPTY : node;
    }

    private Node createVariableContainerNode(BaseScope baseScope, Lookup lookup) {
        Node node = Node.EMPTY;
        if (baseScope == null || lookup == null) {
            return node;
        }
        if (baseScope instanceof Process) {
            node = PropertyNodeFactory.getInstance().createNode(NodeType.VARIABLE_CONTAINER, baseScope, (Children)new BaseScopeVariableChildren(baseScope, lookup), lookup);
        } else {
            NodesTreeParams nodesTreeParams = new NodesTreeParams();
            nodesTreeParams.setLeafNodeClasses(new Class[]{VariableNode.class});
            ExtendedLookup extendedLookup = new ExtendedLookup(lookup, new Object[]{nodesTreeParams});
            VariableContainer variableContainer = baseScope.getVariableContainer();
            node = PropertyNodeFactory.getInstance().createNode(NodeType.VARIABLE_CONTAINER, baseScope, (Lookup)extendedLookup);
        }
        return node;
    }

    private Node createMessageExchangeContainerNode(BaseScope baseScope, Lookup lookup) {
        Node node = Node.EMPTY;
        if (baseScope == null || lookup == null) {
            return node;
        }
        node = baseScope instanceof Process ? PropertyNodeFactory.getInstance().createNode(NodeType.MESSAGE_EXCHANGE_CONTAINER, baseScope, (Children)new BaseScopeMessageExchangeChildren(baseScope, lookup), lookup) : PropertyNodeFactory.getInstance().createNode(NodeType.MESSAGE_EXCHANGE_CONTAINER, baseScope, lookup);
        return node;
    }

    private Node createCorrelationSetNode(BaseScope baseScope, Lookup lookup) {
        Node node = Node.EMPTY;
        if (baseScope == null || lookup == null) {
            return node;
        }
        node = baseScope instanceof Process ? PropertyNodeFactory.getInstance().createNode(NodeType.CORRELATION_SET_CONTAINER, baseScope, (Children)new BaseScopeCorrelationChildren(baseScope, lookup), lookup) : PropertyNodeFactory.getInstance().createNode(NodeType.CORRELATION_SET_CONTAINER, baseScope, lookup);
        return node;
    }

    private List<Node> createCorrelationNodes(CorrelationsHolder correlationsHolder, Lookup lookup) {
        Correlation[] correlationArray;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (correlationsHolder == null || lookup == null) {
            return arrayList;
        }
        CorrelationContainer correlationContainer = correlationsHolder.getCorrelationContainer();
        if (correlationContainer == null) {
            return arrayList;
        }
        for (Correlation correlation : correlationArray = correlationContainer.getCorrelations()) {
            if (correlation == null) continue;
            arrayList.add(this.createNode(NodeType.CORRELATION, (Object)correlation, Children.LEAF, lookup));
        }
        return arrayList;
    }
}

