/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes.synchronizer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bpel.nodes.synchronizer.SynchronisationListener;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.netbeans.modules.xml.xam.Model;
import org.openide.util.WeakListeners;

public class ModelSynchronizer
implements ComponentListener,
PropertyChangeListener {
    private PropertyChangeListener weakModelListener;
    private ComponentListener weakComponentListener;
    private Model currentModel;
    private SynchronisationListener listener;

    public ModelSynchronizer(SynchronisationListener synchronisationListener) {
        this.listener = synchronisationListener;
    }

    public void subscribe(Model model) {
        if (this.currentModel != model) {
            this.unsubscribe();
            if (model != null) {
                this.weakModelListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)model);
                model.addPropertyChangeListener(this.weakModelListener);
                this.weakComponentListener = (ComponentListener)WeakListeners.create(ComponentListener.class, (EventListener)this, (Object)model);
                model.addComponentListener(this.weakComponentListener);
            }
            this.currentModel = model;
        }
    }

    public void unsubscribe() {
        if (this.currentModel != null) {
            this.currentModel.removePropertyChangeListener(this.weakModelListener);
            this.currentModel.removeComponentListener(this.weakComponentListener);
        }
        this.currentModel = null;
    }

    public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (propertyChangeEvent.getSource() instanceof Component) {
                    ModelSynchronizer.this.listener.componentUpdated((Component)propertyChangeEvent.getSource());
                }
            }
        });
    }

    public void childrenAdded(final ComponentEvent componentEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (componentEvent.getSource() instanceof Component) {
                    ModelSynchronizer.this.listener.childrenUpdated((Component)componentEvent.getSource());
                }
            }
        });
    }

    public void childrenDeleted(final ComponentEvent componentEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (componentEvent.getSource() instanceof Component) {
                    ModelSynchronizer.this.listener.childrenUpdated((Component)componentEvent.getSource());
                }
            }
        });
    }

    public void valueChanged(final ComponentEvent componentEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (componentEvent.getSource() instanceof Component) {
                    ModelSynchronizer.this.listener.childrenUpdated((Component)componentEvent.getSource());
                }
            }
        });
    }
}

