/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.choosers;

import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bpel.editors.api.Constants;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.nodes.PrimitiveTypeNode;
import org.netbeans.modules.bpel.nodes.ReloadableChildren;
import org.netbeans.modules.bpel.nodes.SchemaComponentNode;
import org.netbeans.modules.bpel.properties.Constants;
import org.netbeans.modules.bpel.properties.NodeUtils;
import org.netbeans.modules.bpel.properties.PropertyNodeFactory;
import org.netbeans.modules.bpel.properties.ResolverUtility;
import org.netbeans.modules.bpel.properties.TypeContainer;
import org.netbeans.modules.bpel.properties.editors.FormBundle;
import org.netbeans.modules.bpel.properties.editors.controls.AbstractTreeChooserPanel;
import org.netbeans.modules.bpel.properties.editors.controls.filter.ChildTypeFilter;
import org.netbeans.modules.bpel.properties.editors.nodes.factory.TypeChooserNodeFactory;
import org.netbeans.modules.soa.ui.ExtendedLookup;
import org.netbeans.modules.soa.ui.UserNotification;
import org.netbeans.modules.soa.ui.form.Reusable;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.netbeans.modules.soa.ui.nodes.NodeFactory;
import org.netbeans.modules.soa.ui.nodes.NodesTreeParams;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelationPropertyTypeChooserPanel
extends AbstractTreeChooserPanel<TypeContainer>
implements Reusable {
    static final long serialVersionUID = 1L;
    private Constants.StereotypeFilter myStereotypeFilter;
    private JCheckBox chbShowImportedOnly;
    private JTextField fldTypeName;
    private JLabel lblType;
    private JPanel pnlLookupProvider;
    private JScrollPane treeView;

    public CorrelationPropertyTypeChooserPanel() {
    }

    public CorrelationPropertyTypeChooserPanel(Constants.StereotypeFilter stereotypeFilter, Lookup lookup) {
        super(lookup);
        assert (stereotypeFilter != null) : "you should specify a stereotype filter";
        this.myStereotypeFilter = stereotypeFilter;
        this.createContent();
        this.initControls();
    }

    public void init(Constants.StereotypeFilter stereotypeFilter, Lookup lookup) {
        assert (stereotypeFilter != null) : "you should specify a stereotype filter";
        this.myStereotypeFilter = stereotypeFilter;
        NodesTreeParams nodesTreeParams = new NodesTreeParams();
        Class[] classArray = stereotypeFilter.getTargetNodeClasses();
        nodesTreeParams.setTargetNodeClasses(classArray);
        nodesTreeParams.setLeafNodeClasses(classArray);
        ExtendedLookup extendedLookup = new ExtendedLookup(lookup, new Object[]{nodesTreeParams, stereotypeFilter});
        this.setLookup((Lookup)extendedLookup);
        this.initControls();
    }

    @Override
    public void createContent() {
        this.initComponents();
        super.createContent();
        ((BeanTreeView)this.treeView).setRootVisible(true);
        ((BeanTreeView)this.treeView).setSelectionMode(1);
        ((BeanTreeView)this.treeView).setPopupAllowed(false);
        this.getExplorerManager().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Node node = CorrelationPropertyTypeChooserPanel.this.getSelectedNode();
                if (node instanceof SchemaComponentNode) {
                    Object t = ((SchemaComponentNode)node).getReference();
                    if (t != null) {
                        String string = ResolverUtility.getDisplayName(t);
                        CorrelationPropertyTypeChooserPanel.this.fldTypeName.setText(string);
                    }
                } else if (node instanceof PrimitiveTypeNode) {
                    GlobalSimpleType globalSimpleType = (GlobalSimpleType)((PrimitiveTypeNode)node).getReference();
                    if (globalSimpleType != null) {
                        String string = ResolverUtility.getDisplayName((Component)globalSimpleType);
                        CorrelationPropertyTypeChooserPanel.this.fldTypeName.setText(string);
                    }
                } else {
                    CorrelationPropertyTypeChooserPanel.this.fldTypeName.setText("");
                }
            }
        });
        this.chbShowImportedOnly.setSelected(true);
        this.chbShowImportedOnly.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BpelModel bpelModel = (BpelModel)CorrelationPropertyTypeChooserPanel.this.getLookup().lookup(BpelModel.class);
                Process process = bpelModel.getProcess();
                BpelNode<Process> bpelNode = NodeUtils.findFirstNode(process, CorrelationPropertyTypeChooserPanel.this.getExplorerManager().getRootContext());
                Children children = bpelNode.getChildren();
                if (children instanceof ReloadableChildren) {
                    ((ReloadableChildren)children).reload();
                }
            }
        });
    }

    @Override
    public boolean afterClose() {
        super.afterClose();
        this.myStereotypeFilter = null;
        return true;
    }

    @Override
    protected Node constructRootNode() {
        Node node = null;
        BpelModel bpelModel = (BpelModel)this.getLookup().lookup(BpelModel.class);
        Process process = bpelModel.getProcess();
        TypeChooserNodeFactory typeChooserNodeFactory = new TypeChooserNodeFactory((NodeFactory)PropertyNodeFactory.getInstance());
        ChildTypeFilter childTypeFilter = new ChildTypeFilter(){

            public boolean isPairAllowed(NodeType nodeType, NodeType nodeType2) {
                if (CorrelationPropertyTypeChooserPanel.this.chbShowImportedOnly.isSelected()) {
                    return !nodeType2.equals((Object)NodeType.WSDL_FILE) && !nodeType2.equals((Object)NodeType.SCHEMA_FILE);
                }
                return true;
            }
        };
        ExtendedLookup extendedLookup = new ExtendedLookup(this.getLookup(), new Object[]{childTypeFilter});
        node = typeChooserNodeFactory.createNode(NodeType.PROCESS, process, (Lookup)extendedLookup);
        return node;
    }

    public TypeContainer getSelectedValue() {
        Node node = this.getSelectedNode();
        if (node instanceof SchemaComponentNode) {
            Object t = ((SchemaComponentNode)node).getReference();
            if (t instanceof GlobalElement) {
                return new TypeContainer((GlobalElement)t);
            }
            if (t instanceof GlobalType) {
                return new TypeContainer((GlobalType)t);
            }
        } else if (node instanceof PrimitiveTypeNode) {
            GlobalSimpleType globalSimpleType = (GlobalSimpleType)((PrimitiveTypeNode)node).getReference();
            return new TypeContainer((GlobalType)globalSimpleType);
        }
        return null;
    }

    public void setSelectedValue(TypeContainer typeContainer) {
        if (typeContainer == null) {
            this.setSelectedValue(null);
            return;
        }
        Constants.VariableStereotype variableStereotype = typeContainer.getStereotype();
        if (variableStereotype == null) {
            this.setSelectedValue(null);
            String string = NbBundle.getMessage(FormBundle.class, (String)"ERR_PROPERTY_TYPE_RESOLVE_PROBLEM", (Object)typeContainer.getRefString(), (Object)"");
            UserNotification.showMessageAsinc((String)string);
            return;
        }
        if (!this.myStereotypeFilter.isStereotypeAllowed(variableStereotype)) {
            return;
        }
        switch (variableStereotype) {
            case MESSAGE: {
                this.setSelectedValue(null);
                break;
            }
            case GLOBAL_ELEMENT: {
                final GlobalElement globalElement = typeContainer.getGlobalElement();
                boolean bl = ResolverUtility.isModelImported((Model)globalElement.getModel(), this.getLookup());
                if (!bl && this.chbShowImportedOnly.isSelected()) {
                    this.chbShowImportedOnly.setSelected(false);
                }
                NodeUtils.SearchVisitor searchVisitor = new NodeUtils.SearchVisitor(){

                    public boolean accept(Node node) {
                        Object t;
                        return node instanceof SchemaComponentNode && (t = ((SchemaComponentNode)node).getReference()) != null && t.equals(globalElement);
                    }

                    public boolean drillDeeper(Node node) {
                        return !(node instanceof SchemaComponentNode);
                    }
                };
                Node node = NodeUtils.findFirstNode(this.getExplorerManager().getRootContext(), searchVisitor, -1);
                this.setSelectedNode(node);
                break;
            }
            case PRIMITIVE_TYPE: 
            case GLOBAL_SIMPLE_TYPE: 
            case GLOBAL_COMPLEX_TYPE: 
            case GLOBAL_TYPE: {
                final GlobalType globalType = typeContainer.getGlobalType();
                boolean bl = ResolverUtility.isModelImported((Model)globalType.getModel(), this.getLookup());
                if (!bl && this.chbShowImportedOnly.isSelected()) {
                    this.chbShowImportedOnly.setSelected(false);
                }
                NodeUtils.SearchVisitor searchVisitor = new NodeUtils.SearchVisitor(){

                    public boolean accept(Node node) {
                        GlobalSimpleType globalSimpleType;
                        Object t;
                        return node instanceof SchemaComponentNode ? (t = ((SchemaComponentNode)node).getReference()) != null && t.equals(globalType) : node instanceof PrimitiveTypeNode && (globalSimpleType = (GlobalSimpleType)((PrimitiveTypeNode)node).getReference()) != null && globalSimpleType.equals(globalType);
                    }

                    public boolean drillDeeper(Node node) {
                        return !(node instanceof SchemaComponentNode);
                    }
                };
                Node node = NodeUtils.findFirstNode(this.getExplorerManager().getRootContext(), searchVisitor, -1);
                this.setSelectedNode(node);
            }
        }
    }

    @Override
    protected Validator createValidator() {
        return new MyValidator();
    }

    private void initComponents() {
        this.lblType = new JLabel();
        this.fldTypeName = new JTextField();
        this.chbShowImportedOnly = new JCheckBox();
        this.pnlLookupProvider = new AbstractTreeChooserPanel.TreeWrapperPanel(this);
        this.treeView = new BeanTreeView();
        this.lblType.setLabelFor(this.fldTypeName);
        this.lblType.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_Type"));
        this.lblType.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_Type"));
        this.lblType.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_Type"));
        this.fldTypeName.setEditable(false);
        this.fldTypeName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_TypeIndicator"));
        this.fldTypeName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_TypeIndicator"));
        this.chbShowImportedOnly.setText(NbBundle.getMessage(FormBundle.class, (String)"CHB_Show_Imported_Files_Only"));
        this.chbShowImportedOnly.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chbShowImportedOnly.setMargin(new Insets(0, 0, 0, 0));
        this.chbShowImportedOnly.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_CHB_Show_Imported_Files_Only"));
        this.chbShowImportedOnly.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_CHB_Show_Imported_Files_Only"));
        this.pnlLookupProvider.setFocusable(false);
        this.treeView.setBorder(new SoftBevelBorder(1));
        this.treeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_TypeChooser"));
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_TypeChooser"));
        GroupLayout groupLayout = new GroupLayout((Container)this.pnlLookupProvider);
        this.pnlLookupProvider.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((java.awt.Component)this.treeView, -1, 449, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((java.awt.Component)this.treeView, -1, 280, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((java.awt.Component)this.lblType).addPreferredGap(0).add((java.awt.Component)this.fldTypeName, -1, 398, Short.MAX_VALUE)).add((java.awt.Component)this.pnlLookupProvider, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((java.awt.Component)this.chbShowImportedOnly).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((java.awt.Component)this.pnlLookupProvider, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((java.awt.Component)this.chbShowImportedOnly).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((java.awt.Component)this.lblType, -2, 16, -2).add((java.awt.Component)this.fldTypeName, -2, 22, -2))));
    }

    private class MyValidator
    extends AbstractTreeChooserPanel.DefaultChooserValidator {
        private MyValidator() {
            super(CorrelationPropertyTypeChooserPanel.this);
        }

        protected String getIncorrectNodeSelectionReasonKey() {
            return "ERR_PROPERTY_TYPE_NOT_SPECIFIED";
        }
    }
}

