/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.choosers;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bpel.editors.api.ui.valid.ErrorMessagesBundle;
import org.netbeans.modules.bpel.model.api.BaseScope;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.NamedElement;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.VariableContainer;
import org.netbeans.modules.bpel.model.spi.FindHelper;
import org.netbeans.modules.bpel.properties.Constants;
import org.netbeans.modules.bpel.properties.ResolverUtility;
import org.netbeans.modules.bpel.properties.TypeContainer;
import org.netbeans.modules.bpel.properties.VirtualVariableContainer;
import org.netbeans.modules.bpel.properties.editors.FormBundle;
import org.netbeans.modules.soa.ui.SoaUtil;
import org.netbeans.modules.soa.ui.form.ChooserLifeCycle;
import org.netbeans.modules.soa.ui.form.CustomNodeEditor;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidator;
import org.netbeans.modules.soa.ui.form.valid.ValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewMessageVarChooser
extends JPanel
implements ChooserLifeCycle<VirtualVariableContainer>,
Validator.Provider,
CustomNodeEditor.Owner {
    private static final long serialVersionUID = 1L;
    private CustomNodeEditor myEditor;
    private DefaultValidator myValidator;
    private Message myVarType;
    private BpelEntity myTargetEntity;
    private String myTypeOwnerName;
    private Constants.MessageDirection myMsgDirection;
    private JComboBox cbxScope;
    private JTextField fldVariableName;
    private JTextField fldVariableType;
    private JLabel lblScope;
    private JLabel lblType;
    private JLabel lblVariableName;

    public NewMessageVarChooser(BpelEntity bpelEntity, String string, Message message, Constants.MessageDirection messageDirection) {
        this.myTargetEntity = bpelEntity;
        this.myTypeOwnerName = string;
        this.myVarType = message;
        this.myMsgDirection = messageDirection;
        this.createContent();
    }

    public void createContent() {
        this.initComponents();
        this.cbxScope.setRenderer(new DefaultListCellRenderer(){
            static final long serialVersionUID = 1L;

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object != null && object instanceof NamedElement) {
                    String string = ((NamedElement)object).getName();
                    this.setText(string);
                }
                return this;
            }
        });
        SoaUtil.activateInlineMnemonics((Container)this);
    }

    public boolean initControls() {
        Object object;
        String string = this.calculateMessageVarName();
        if (string != null) {
            this.fldVariableName.setText(string);
        }
        if (this.myVarType != null) {
            object = ResolverUtility.getDisplayName((org.netbeans.modules.xml.xam.Component)this.myVarType, this.myTargetEntity);
            this.myTargetEntity.getNamespaceContext();
            this.fldVariableType.setText((String)object);
        }
        if ((object = (FindHelper)Lookup.getDefault().lookup(FindHelper.class)) != null) {
            Object object2;
            Iterator iterator = object.scopeIterator(this.myTargetEntity);
            Vector<BaseScope> vector = new Vector<BaseScope>();
            while (iterator.hasNext()) {
                object2 = (BaseScope)iterator.next();
                vector.add((BaseScope)object2);
            }
            object2 = new DefaultComboBoxModel(vector);
            this.cbxScope.setModel(object2);
            this.cbxScope.setSelectedIndex(0);
        }
        return true;
    }

    private String calculateMessageVarName() {
        String string = null;
        String string2 = null;
        String string3 = this.myTypeOwnerName;
        if ((string3 = this.capitalizeFirstLetter(string3)) == null || string3.length() == 0) {
            string = "NewVariable";
        } else {
            switch (this.myMsgDirection) {
                case INPUT: {
                    string2 = string3 + "In";
                    break;
                }
                case OUTPUT: {
                    string2 = string3 + "Out";
                    break;
                }
                case FAULT: {
                    String string4 = "Fault";
                    String string5 = string3.substring(string3.length() - string4.length());
                    string2 = string5.equalsIgnoreCase(string4) ? string3 + "Var" : string3 + string4 + "Var";
                }
            }
        }
        for (int i = 0; i < 1000; ++i) {
            string = i == 0 ? string2 : string2 + i;
            boolean bl = false;
            Iterator<BaseScope> iterator = this.getScopeIterator();
            if (iterator != null) {
                block6: while (iterator.hasNext()) {
                    Variable[] variableArray;
                    BaseScope baseScope = iterator.next();
                    VariableContainer variableContainer = baseScope.getVariableContainer();
                    if (variableContainer == null) continue;
                    for (Variable variable : variableArray = variableContainer.getVariables()) {
                        if (!string.equals(variable.getName())) continue;
                        bl = true;
                        break block6;
                    }
                }
            }
            if (!bl) break;
        }
        return string;
    }

    private String capitalizeFirstLetter(String string) {
        String string2 = string.substring(0, 1);
        String string3 = string.substring(1);
        String string4 = string2.toUpperCase() + string3;
        return string4;
    }

    private Iterator<BaseScope> getScopeIterator() {
        FindHelper findHelper = (FindHelper)Lookup.getDefault().lookup(FindHelper.class);
        if (findHelper != null) {
            Iterator iterator = findHelper.scopeIterator(this.myTargetEntity);
            return iterator;
        }
        return null;
    }

    public CustomNodeEditor getParentEditor() {
        Container container;
        while ((container = this.getParent()) != null) {
            if (!(container instanceof CustomNodeEditor)) continue;
            return (CustomNodeEditor)container;
        }
        return null;
    }

    public BaseScope getTargetScope() {
        return (BaseScope)this.cbxScope.getSelectedItem();
    }

    public VirtualVariableContainer getSelectedValue() {
        String string = this.fldVariableName.getText();
        TypeContainer typeContainer = new TypeContainer(this.myVarType);
        BaseScope baseScope = (BaseScope)this.cbxScope.getSelectedItem();
        return new VirtualVariableContainer(string, typeContainer, baseScope);
    }

    public DefaultValidator getValidator() {
        if (this.myValidator == null && this.myEditor != null) {
            this.myValidator = new DefaultValidator((ValidStateManager.Provider)this.myEditor, ErrorMessagesBundle.class){

                public void doFastValidation() {
                    Object object = NewMessageVarChooser.this.cbxScope.getSelectedItem();
                    if (object == null) {
                        this.addReasonKey(Validator.Severity.ERROR, "ERR_SCOPE_NOT_SPECIFIED");
                    }
                }

                public void doDetailedValidation() {
                    VariableContainer variableContainer;
                    super.doDetailedValidation();
                    BaseScope baseScope = (BaseScope)NewMessageVarChooser.this.cbxScope.getSelectedItem();
                    if (baseScope != null && (variableContainer = baseScope.getVariableContainer()) != null) {
                        Variable[] variableArray;
                        String string = NewMessageVarChooser.this.fldVariableName.getText();
                        for (Variable variable : variableArray = variableContainer.getVariables()) {
                            if (!string.equals(variable.getName())) continue;
                            this.addReasonKey(Validator.Severity.ERROR, "ERR_NOT_UNIQUE_VARIABLE_NAME");
                        }
                    }
                }
            };
        }
        return this.myValidator;
    }

    public void setEditor(CustomNodeEditor customNodeEditor) {
        this.myEditor = customNodeEditor;
    }

    public CustomNodeEditor getEditor() {
        return this.myEditor;
    }

    public boolean unsubscribeListeners() {
        return true;
    }

    public boolean subscribeListeners() {
        return true;
    }

    public boolean afterClose() {
        return true;
    }

    public void setSelectedValue(VirtualVariableContainer virtualVariableContainer) {
    }

    private void initComponents() {
        this.lblVariableName = new JLabel();
        this.lblType = new JLabel();
        this.fldVariableName = new JTextField();
        this.fldVariableType = new JTextField();
        this.lblScope = new JLabel();
        this.cbxScope = new JComboBox();
        this.lblVariableName.setLabelFor(this.fldVariableName);
        this.lblVariableName.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_VariableName"));
        this.lblVariableName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_VariableName"));
        this.lblVariableName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_VariableName"));
        this.lblType.setLabelFor(this.fldVariableType);
        this.lblType.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_Type"));
        this.lblType.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_Type"));
        this.lblType.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_Type"));
        this.fldVariableName.setColumns(30);
        this.fldVariableType.setColumns(30);
        this.fldVariableType.setEditable(false);
        this.lblScope.setLabelFor(this.cbxScope);
        this.lblScope.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_Scope"));
        this.lblScope.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_Scope"));
        this.lblScope.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_Scope"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add(1, (Component)this.lblType, -1, -1, Short.MAX_VALUE).add(1, (Component)this.lblVariableName, -1, -1, Short.MAX_VALUE)).add((Component)this.lblScope)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.cbxScope, 0, 267, Short.MAX_VALUE).add(2, (Component)this.fldVariableName, -1, 267, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0).add((Component)this.fldVariableType, -1, 267, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.fldVariableName, -2, 22, -2).add((Component)this.lblVariableName)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblType).add((Component)this.fldVariableType, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.cbxScope, -2, -1, -2).add((Component)this.lblScope)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

